/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.List;

public class IncomingWorkspaceNode
implements IIncomingActivitySource {
    List activities;
    List baselines;
    IContextHandle workspace;
    IAuditable owner;
    IComponentSyncContext context;

    public IncomingWorkspaceNode(IComponentSyncContext context, IContextHandle workspace) {
        this.context = context;
        this.workspace = workspace;
    }

    public List getActivities() {
        return this.activities != null ? Collections.unmodifiableList(this.activities) : Collections.EMPTY_LIST;
    }

    public int size() {
        List activities = this.activities;
        int nBaselines = this.baselines == null ? 0 : this.baselines.size();
        int nActivities = activities == null ? 0 : activities.size();
        return nBaselines + nActivities;
    }

    public List getBaselines() {
        return this.baselines != null ? Collections.unmodifiableList(this.baselines) : Collections.EMPTY_LIST;
    }

    public IComponentSyncContext getModel() {
        return this.context;
    }

    public String getName() {
        return IncomingWorkspaceNode.getWorkspaceName(this.workspace);
    }

    public IAuditable getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return IncomingWorkspaceNode.getOwnerName(this.owner);
    }

    public IWorkspace getWorkspace() {
        return this.workspace instanceof IWorkspace ? (IWorkspace)this.workspace : null;
    }

    public IBaseline getBaseline() {
        return this.workspace instanceof IBaseline ? (IBaseline)this.workspace : null;
    }

    public void update(List activities, List baselines, IContextHandle workspace, IAuditable owner) {
        this.activities = activities;
        this.baselines = baselines;
        this.workspace = workspace;
        this.owner = owner;
    }

    public static String getOwnerName(IAuditable auditable) {
        if (auditable == null) {
            return "";
        }
        if (auditable instanceof IContributor) {
            return ((IContributor)auditable).getName();
        }
        if (auditable instanceof ITeamArea) {
            return ((ITeamArea)auditable).getName();
        }
        return "";
    }

    static String getWorkspaceName(IContextHandle connectable) {
        if (connectable == null) {
            return "";
        }
        if (connectable instanceof IWorkspace) {
            return ((IWorkspace)connectable).getName();
        }
        if (connectable instanceof IBaseline) {
            IBaseline baseline = (IBaseline)connectable;
            String name = baseline.getName();
            int id = baseline.getId();
            StringBuffer label = new StringBuffer();
            label.append(id);
            if (name.length() > 0) {
                label.append(": " + name);
            }
            return label.toString();
        }
        return "";
    }
}

