/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncIDWorkspace;
import com.ibm.team.filesystem.rcp.core.internal.changes.operations.CompareToOperation;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingWorkspaceNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingWorkspaceNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IItemCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutate;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQuery;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQueryContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CompareToNode
implements IMutate {
    public List[] children = new List[2];
    public IContextHandle from;
    public IContextHandle to;
    public List incomingFileChangeSets = new ArrayList();
    public List outgoingFileChangeSets = new ArrayList();
    public List incomingBaselines = new ArrayList();
    public List outgoingBaselines = new ArrayList();
    public OutgoingWorkspaceNode fromWorkspaceNode;
    public IncomingWorkspaceNode toWorkspaceNode;
    List activitySources;
    public IComponentSyncContext model;
    public IConnection teamPlaceFrom;
    public IConnection teamPlaceTo;
    public IComponent component;
    public SyncIDWorkspace vTimeFrom;
    public SyncIDWorkspace vTimeTo;
    IFileSystemView fileSystemViewFrom;
    IFileSystemView fileSystemViewTo;
    public int compareToFlags;
    public IChangeHistorySyncReport changeHistorySyncReport;
    public IUpdateReport conflictReport;
    public ILogicalConflictReport logicalConflictReport;
    public ILogicalConflictReport freeFlightLogicalConflictReport;
    public List outgoingChangeSetHandles;
    public List incomingChangeSetHandles;
    public IAuditableHandle fromOwnerHandle;
    public IAuditableHandle toOwnerHandle;
    public IAuditable fromOwner;
    public IAuditable toOwner;
    public IBaseline fromBasis;
    public IBaseline toBasis;
    public int componentFlowType;
    public boolean customQuery;
    static final IQuery QUERY = new IQuery(){

        public void computeItemsAndChildren(List elements, IQueryContext agent, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            CompareToOperation operation = new CompareToOperation(null);
            operation.computeItemsAndChildren(elements, agent);
            operation.run(monitor);
        }
    };

    public CompareToNode(IComponentSyncContext model, IConnection teamPlaceFrom, IConnection teamPlaceTo, IComponent component) {
        this.model = model;
        this.teamPlaceFrom = teamPlaceFrom;
        this.teamPlaceTo = teamPlaceTo;
        this.component = component;
        this.fileSystemViewFrom = FileSystemCore.getFileSystemManager((ITeamRepository)teamPlaceFrom.teamRepository()).getFileSystemView(teamPlaceFrom);
        this.fileSystemViewTo = FileSystemCore.getFileSystemManager((ITeamRepository)teamPlaceTo.teamRepository()).getFileSystemView(teamPlaceTo);
        if (teamPlaceFrom instanceof IWorkspaceConnection) {
            this.from = ((IWorkspaceConnection)teamPlaceFrom).getResolvedWorkspace();
        } else if (teamPlaceFrom instanceof IBaselineConnection) {
            this.from = ((IBaselineConnection)teamPlaceFrom).getResolvedBaseline();
        } else {
            throw new IllegalArgumentException("Unsupported type " + teamPlaceFrom);
        }
        if (teamPlaceTo instanceof IWorkspaceConnection) {
            this.to = ((IWorkspaceConnection)teamPlaceTo).getResolvedWorkspace();
        } else if (teamPlaceTo instanceof IBaselineConnection) {
            this.to = ((IBaselineConnection)teamPlaceTo).getResolvedBaseline();
        } else {
            throw new IllegalArgumentException("Unsupported type " + teamPlaceFrom);
        }
        this.fromWorkspaceNode = new OutgoingWorkspaceNode(model, this.from);
        this.toWorkspaceNode = new IncomingWorkspaceNode(model, this.to);
        this.activitySources = new ArrayList(2);
        this.activitySources.add(this.fromWorkspaceNode);
        this.activitySources.add(this.toWorkspaceNode);
        CompareInput input = null;
        if (model.getParentContext().getChangeInput() instanceof CompareInput) {
            input = (CompareInput)model.getParentContext().getChangeInput();
        }
        this.customQuery = input != null && input.useCustomQuery();
        ComponentSyncInfo info = model.getComponentSyncInfo();
        try {
            this.componentFlowType = ComponentFlowUtil.getComponentFlowType(info);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            this.componentFlowType = 0;
        }
    }

    public IQuery getQuery() {
        return QUERY;
    }

    public static IAuditableHandle getOwner(IContextHandle auditable) {
        if (auditable instanceof IWorkspace) {
            return ((IWorkspace)auditable).getOwner();
        }
        return null;
    }

    public List[] getChildren() {
        return this.children;
    }

    public List getItems() {
        return Collections.EMPTY_LIST;
    }

    public void clean(IItemCache cache, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (this.fromOwnerHandle != null) {
            this.fromOwner = cache.fetchCurrent(this.fromOwnerHandle, (IProgressMonitor)progress.newChild(1));
        }
        if (this.toOwnerHandle != null) {
            this.toOwner = cache.fetchCurrent(this.toOwnerHandle, (IProgressMonitor)progress.newChild(1));
        }
        this.fromWorkspaceNode.update(this.outgoingFileChangeSets, this.outgoingBaselines, this.from, this.fromOwner);
        this.toWorkspaceNode.update(this.incomingFileChangeSets, this.incomingBaselines, this.to, this.toOwner);
    }

    public void setRemote(IConnection remote) {
        this.teamPlaceTo = remote;
        this.vTimeTo = null;
        this.fileSystemViewTo = FileSystemCore.getFileSystemManager((ITeamRepository)this.teamPlaceTo.teamRepository()).getFileSystemView(this.teamPlaceTo);
        if (this.teamPlaceTo instanceof IWorkspaceConnection) {
            this.to = ((IWorkspaceConnection)this.teamPlaceTo).getResolvedWorkspace();
        } else if (this.teamPlaceTo instanceof IBaselineConnection) {
            this.to = ((IBaselineConnection)this.teamPlaceTo).getResolvedBaseline();
        } else {
            throw new IllegalArgumentException("Unsupported type " + this.teamPlaceFrom);
        }
        this.activitySources.remove(this.toWorkspaceNode);
        this.toWorkspaceNode = new IncomingWorkspaceNode(this.model, this.to);
        this.activitySources.add(this.toWorkspaceNode);
    }

    public static void update(List updateChangeSets, List newChangeSets, IConnection teamPlace, IActivitySource activitySource, IQueryContext context) {
        ArrayList<ChangeSetNode> oldChangeSetsRemoved = new ArrayList<ChangeSetNode>();
        IChangeSetHandle[] newChangeSetHandles = newChangeSets.toArray(new IChangeSetHandle[newChangeSets.size()]);
        for (ChangeSetNode old : updateChangeSets) {
            boolean found = false;
            int i = 0;
            while (i < newChangeSetHandles.length) {
                IChangeSetHandle newChangeSetHandle = newChangeSetHandles[i];
                if (old.handle.sameItemId((IItemHandle)newChangeSetHandle)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            oldChangeSetsRemoved.add(old);
        }
        ArrayList<IChangeSetHandle> newChangeSetsCreated = new ArrayList<IChangeSetHandle>();
        int i = 0;
        while (i < newChangeSetHandles.length) {
            IChangeSetHandle newChangeSetHandle = newChangeSetHandles[i];
            boolean found = false;
            for (ChangeSetNode old : updateChangeSets) {
                if (!newChangeSetHandle.sameItemId((IItemHandle)old.handle)) continue;
                found = true;
                break;
            }
            if (!found) {
                newChangeSetsCreated.add(newChangeSetHandle);
            }
            ++i;
        }
        if (!newChangeSetsCreated.isEmpty() || !oldChangeSetsRemoved.isEmpty()) {
            updateChangeSets.removeAll(oldChangeSetsRemoved);
            context.setRemoved(oldChangeSetsRemoved);
            for (IChangeSetHandle newChangeSetHandle : newChangeSetsCreated) {
                ChangeSetNode node = activitySource instanceof IOutgoingActivitySource ? new OutgoingChangeSetNode(teamPlace, newChangeSetHandle, (IOutgoingActivitySource)activitySource) : new IncomingChangeSetNode(teamPlace, newChangeSetHandle, (IIncomingActivitySource)activitySource);
                updateChangeSets.add(node);
                context.setAdded(Collections.singletonList(node));
            }
        }
        ((ComponentSyncContext)activitySource.getModel()).sort(updateChangeSets, newChangeSets);
        int id = 0;
        Iterator iActivities = updateChangeSets.iterator();
        while (iActivities.hasNext()) {
            ((ChangeSetNode)iActivities.next()).id = id++;
        }
    }

    public OutgoingChangeSetNode addActivity(IChangeSetHandle changeSet) {
        ArrayList<OutgoingChangeSetNode> outgoingFileChangeSets = new ArrayList<OutgoingChangeSetNode>(this.outgoingFileChangeSets);
        OutgoingChangeSetNode node = new OutgoingChangeSetNode(this.teamPlaceFrom, changeSet, this.fromWorkspaceNode);
        IAuditable owner = this.fromWorkspaceNode.getOwner();
        if (owner instanceof IContributor) {
            node.modifiedBy = (IContributor)owner;
        }
        ((ComponentSyncContext)this.model).mutator.setAdded(Collections.singletonList(node));
        node.id = -outgoingFileChangeSets.size();
        outgoingFileChangeSets.add(node);
        this.outgoingFileChangeSets = outgoingFileChangeSets;
        this.fromWorkspaceNode.update(outgoingFileChangeSets, this.outgoingBaselines, this.from, this.fromOwner);
        ArrayList<OutgoingChangeSetNode> newChangeSets = new ArrayList<OutgoingChangeSetNode>();
        newChangeSets.addAll(this.incomingFileChangeSets);
        newChangeSets.addAll(outgoingFileChangeSets);
        this.children[0] = newChangeSets;
        return node;
    }
}

