/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.common.IBasicChange;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IVersionableHandle;

public class ChangeSummaryNode
implements IRemoteChangeSummary {
    final IVersionableHandle handle;
    IChangeSummary changeSummary;
    final ChangeSetNode remoteActivity;

    public ChangeSummaryNode(IChangeSummary changeSummary, IRemoteActivity remoteActivity) {
        this.handle = changeSummary.item();
        this.changeSummary = changeSummary;
        this.remoteActivity = (ChangeSetNode)remoteActivity;
    }

    public IVersionableHandle getItem() {
        return this.handle;
    }

    public IRemoteActivity getActivity() {
        return this.remoteActivity;
    }

    public IChange getChange() {
        return this.remoteActivity.getChange(this.handle);
    }

    public IChangeSummary getChangeSummary() {
        return this.changeSummary;
    }

    public String getAfterPath() {
        return ComponentSyncUtil.toString(this.getAfterPathArray(), false);
    }

    public String getBeforePath() {
        return ComponentSyncUtil.toString(this.getBeforePathArray(), false);
    }

    public String getResourceName() {
        IChangeSummary changeSummary = this.changeSummary;
        String[] path = changeSummary.isChangeType(8) ? changeSummary.getNewPathHint() : changeSummary.getPathHint();
        return path[path.length - 1];
    }

    public String[] getAfterPathArray() {
        IChangeSummary changeSummary = this.changeSummary;
        return changeSummary.isChangeType(8) ? changeSummary.getNewPathHint() : changeSummary.getPathHint();
    }

    public String[] getBeforePathArray() {
        IChangeSummary changeSummary = this.changeSummary;
        return changeSummary.getPathHint();
    }

    boolean isSame(IChangeSummary changeSummary) {
        return this.isSameChangeSummary(this.changeSummary, changeSummary);
    }

    boolean isSameChangeSummary(IChangeSummary element1, IChangeSummary element2) {
        if (element2 == null) {
            return element1 == null;
        }
        if (element1 == null) {
            return false;
        }
        if (!element2.item().sameItemId((IItemHandle)element1.item())) {
            return false;
        }
        if (!element2.isSameChangeType((IBasicChange)element1)) {
            return false;
        }
        if (element2.beforeState() == null && element1.beforeState() != null) {
            return false;
        }
        if (element2.beforeState() != null && !element2.beforeState().sameStateId((IItemHandle)element1.beforeState())) {
            return false;
        }
        if (element2.afterState() == null && element1.afterState() != null) {
            return false;
        }
        return element2.afterState() == null || element2.afterState().sameStateId((IItemHandle)element1.afterState());
    }
}

