/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSummaryNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingFolderNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingFolderNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SuspendedChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SuspendedFolderNode;
import java.util.ArrayList;
import java.util.List;

public class ActivityFolderNode
implements IActivityFolder {
    final String[] path;
    final IRemoteActivity activity;

    public ActivityFolderNode(String[] path, IRemoteActivity activity) {
        this.path = path;
        this.activity = activity;
    }

    public IRemoteActivity getActivity() {
        return this.activity;
    }

    public String getPath() {
        if (this.path == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.path.length - 1) {
            buffer.append(this.path[i]);
            if (i != this.path.length - 2) {
                buffer.append('/');
            }
            ++i;
        }
        if (buffer.length() == 0) {
            buffer.append('/');
        }
        return buffer.toString();
    }

    public boolean contains(IRemoteChangeSummary change) {
        return this.contains((ChangeSummaryNode)change);
    }

    boolean contains(ChangeSummaryNode changeSummaryNode) {
        IChangeSummary changeSummary = changeSummaryNode.getChangeSummary();
        String[] pathHint = ModelUtil.getPathHint(changeSummary);
        if (pathHint == null || pathHint.length == 0) {
            return false;
        }
        if (pathHint.length != this.path.length) {
            return false;
        }
        int i = 0;
        while (i < this.path.length - 1) {
            if (!pathHint[i].equals(this.path[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static void add(List folders, ChangeSummaryNode changeSummaryNode, ChangeSetNode changeSetNode) {
        ActivityFolderNode folder;
        IChangeSummary changeSummary = changeSummaryNode.getChangeSummary();
        String[] pathHint = ModelUtil.getPathHint(changeSummary);
        for (ActivityFolderNode folder2 : folders) {
            if (!folder2.contains(changeSummaryNode)) continue;
            return;
        }
        if (changeSetNode instanceof OutgoingChangeSetNode) {
            folder = new OutgoingFolderNode(pathHint, (IOutgoingRemoteActivity)((Object)changeSetNode));
        } else if (changeSetNode instanceof IncomingChangeSetNode) {
            folder = new IncomingFolderNode(pathHint, (IIncomingRemoteActivity)((Object)changeSetNode));
        } else if (changeSetNode instanceof SuspendedChangeSetNode) {
            folder = new SuspendedFolderNode(pathHint, (ISuspendedRemoteActivity)((Object)changeSetNode));
        } else {
            throw new IllegalStateException("Invalid type for " + changeSetNode);
        }
        folders.add(folder);
    }

    static boolean contains(List changes, ActivityFolderNode folder) {
        for (ChangeSummaryNode change : changes) {
            if (!folder.contains(change)) continue;
            return true;
        }
        return false;
    }

    static void update(List folders, ChangeSetNode changeSetNode, List changes) {
        ArrayList newFolders = new ArrayList();
        for (ChangeSummaryNode node : changes) {
            ActivityFolderNode.add(newFolders, node, changeSetNode);
        }
        ComponentConflictUtil.update(folders, newFolders, new ComponentConflictUtil.UpdateItem(){

            public boolean sameItem(Object object, Object other) {
                return ((ActivityFolderNode)object).getPath().equals(((ActivityFolderNode)other).getPath());
            }

            public void updateSameItem(Object object, Object other) {
            }
        });
    }
}

