/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SuspendedNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQueryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SuspendOperation
extends FileSystemOperation {
    List elements;
    IQueryContext context;

    public SuspendOperation(DilemmaHandler handler) {
        super(handler);
    }

    public void computeItemsAndChildren(List elements, IQueryContext context) {
        this.elements = elements;
        this.context = context;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        try {
            monitor.beginTask(Messages.SuspendedNode_0, this.elements.size());
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                this.computeItemsAndChildren((SuspendedNode)iter.next(), this.context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    void computeItemsAndChildren(SuspendedNode src, IQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        List newChangeSets = src.teamPlace.suspendedChangeSets((IComponentHandle)src.model.getComponent());
        List changeSets = context.getCache().fetchCurrent(new ArrayList(newChangeSets), 0, monitor);
        if (changeSets == null) {
            changeSets = Collections.EMPTY_LIST;
        }
        src.update(src.suspendedChangeSets, changeSets, src.teamPlace, context);
        src.children[0] = src.suspendedChangeSets;
    }
}

