/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineSetSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IMultiComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.ItemCache;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSyncModelUpdateOperation
extends FileSystemOperation {
    ComponentSyncModel model;

    public ComponentSyncModelUpdateOperation(DilemmaHandler handler) {
        super(handler);
    }

    public void update(ComponentSyncModel model) {
        this.model = model;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IConnection collaboration;
        Collection<IWorkspaceConnection> loaded = this.model.getComponentSyncManager().getLoadedWorkspaces();
        IConnection infos = this.model.getComponentSyncManager().getComponentSyncs();
        HashSet<IWorkspaceSyncContext> workspaceContexts = new HashSet<IWorkspaceSyncContext>(this.model.workspaceContexts);
        HashSet<IComponentSyncContext> componentContexts = new HashSet<IComponentSyncContext>(this.model.componentContexts);
        HashSet<ITeamRepository> teamRepositories = new HashSet<ITeamRepository>(this.model.teamRepositories);
        Set<WorkspaceSyncContext> newWorkspaceContexts = Collections.synchronizedSet(new HashSet());
        Set<ComponentSyncContext> newComponentContexts = Collections.synchronizedSet(new HashSet());
        HashSet<ITeamRepository> newTeamRepositories = new HashSet<ITeamRepository>();
        HashMap<IWorkspaceConnection, WorkspaceSyncContext> newConnection2WorkspaceContext = new HashMap<IWorkspaceConnection, WorkspaceSyncContext>();
        for (IWorkspaceConnection wc : loaded) {
            IWorkspaceHandle collaborationHandle = ComponentFlowUtil.getCurrentCollaboration(wc);
            collaboration = ActiveWorkspaceManager.getConnection((IContextHandle)collaborationHandle, null);
            if (collaboration == null) {
                collaboration = wc;
            }
            WorkspaceSyncContext wsc = new WorkspaceSyncContext(this.model, wc.teamRepository(), wc, collaboration, null);
            newWorkspaceContexts.add(wsc);
            newConnection2WorkspaceContext.put(wc, wsc);
            newTeamRepositories.add(wc.teamRepository());
        }
        collaboration = infos;
        int collaborationHandle = ((ComponentSyncInfo[])collaboration).length;
        int n = 0;
        while (n < collaborationHandle) {
            IConnection info = collaboration[n];
            ITeamRepository repo = info.getLocalConnection() != null ? info.getLocalConnection().teamRepository() : info.getRemote().teamRepository();
            WorkspaceSyncContext wsc = (WorkspaceSyncContext)newConnection2WorkspaceContext.get(info.getLocal());
            ComponentSyncContext context = ComponentSyncContext.create((ComponentSyncInfo)info, this.model, this.model.getEventManager(), ItemCache.create(repo), wsc);
            newComponentContexts.add(context);
            ++n;
        }
        final HashMap updates = new HashMap();
        ComponentConflictUtil.UpdateItem wUpdateItem = new ComponentConflictUtil.UpdateItem(){

            public void updateSameItem(Object object, Object other) {
                updates.put((IWorkspaceSyncContext)other, (IWorkspaceSyncContext)object);
            }

            public boolean sameItem(Object object, Object other) {
                WorkspaceSyncContext wsc1 = (WorkspaceSyncContext)object;
                WorkspaceSyncContext wsc2 = (WorkspaceSyncContext)other;
                return wsc1.repo.equals(wsc2.repo) && wsc1.local.equals((Object)wsc2.local) && wsc1.remote.equals(wsc2.remote);
            }
        };
        ComponentConflictUtil.update(workspaceContexts, newWorkspaceContexts, wUpdateItem);
        ComponentConflictUtil.UpdateItem cUpdateItem = new ComponentConflictUtil.UpdateItem(){

            public void updateSameItem(Object object, Object other) {
            }

            public boolean sameItem(Object object, Object other) {
                ComponentSyncContext csc1 = (ComponentSyncContext)object;
                ComponentSyncContext csc2 = (ComponentSyncContext)other;
                return csc1.info.equals(csc2.info);
            }
        };
        ComponentConflictUtil.update(componentContexts, newComponentContexts, cUpdateItem);
        for (Object addition : cUpdateItem.getAdditions()) {
            ComponentSyncContext csc = (ComponentSyncContext)addition;
            IWorkspaceSyncContext parent = (IWorkspaceSyncContext)updates.get(csc.parent);
            if (parent == null) continue;
            csc.parent = parent;
        }
        ComponentConflictUtil.UpdateItem tUpdateItem = new ComponentConflictUtil.UpdateItem(){

            public void updateSameItem(Object object, Object other) {
            }

            public boolean sameItem(Object object, Object other) {
                return object.equals(other);
            }
        };
        ComponentConflictUtil.update(teamRepositories, newTeamRepositories, tUpdateItem);
        ComponentSyncModelUpdateOperation.updateComponentContexts(this.model, cUpdateItem.getAdditions(), cUpdateItem.getRemovals(), monitor);
        this.model.teamRepositories = teamRepositories;
        this.model.workspaceContexts = workspaceContexts;
        this.model.componentContexts = componentContexts;
        if (!tUpdateItem.getAdditions().isEmpty()) {
            this.model.queueEvent(new PropertyChangeEvent((IEventSource)this.model, "com.ibm.team.repository.PropertyAddMany", (Object)this, (Object)"teamRepositories", null, (Object)tUpdateItem.getAdditions()));
        }
        if (!tUpdateItem.getRemovals().isEmpty()) {
            this.model.queueEvent(new PropertyChangeEvent((IEventSource)this.model, "com.ibm.team.repository.PropertyRemoveMany", (Object)this, (Object)"teamRepositories", (Object)tUpdateItem.getRemovals(), null));
        }
        if (!wUpdateItem.getAdditions().isEmpty()) {
            this.model.queueEvent(new PropertyChangeEvent((IEventSource)this.model, "com.ibm.team.repository.PropertyAddMany", (Object)this, (Object)"workspaceSyncContexts", null, (Object)wUpdateItem.getAdditions()));
        }
        if (!wUpdateItem.getRemovals().isEmpty()) {
            this.model.queueEvent(new PropertyChangeEvent((IEventSource)this.model, "com.ibm.team.repository.PropertyRemoveMany", (Object)this, (Object)"workspaceSyncContexts", (Object)wUpdateItem.getRemovals(), null));
        }
        if (!cUpdateItem.getAdditions().isEmpty()) {
            this.model.queueEvent(new PropertyChangeEvent((IEventSource)this.model, "com.ibm.team.repository.PropertyAddMany", (Object)this, (Object)"componentSyncContexts", null, (Object)cUpdateItem.getAdditions()));
        }
        if (!cUpdateItem.getRemovals().isEmpty()) {
            this.model.queueEvent(new PropertyChangeEvent((IEventSource)this.model, "com.ibm.team.repository.PropertyRemoveMany", (Object)this, (Object)"componentSyncContexts", (Object)cUpdateItem.getRemovals(), null));
        }
    }

    public static IComponentSyncContext create(ComponentSyncModel model, ComponentSyncInfo info, IMultiComponentSyncContext workspaceContext, IProgressMonitor monitor) {
        if (workspaceContext instanceof IBaselineSetSyncContext) {
            if (model.baselineSetSyncContext != null && model.baselineSetSyncContext != workspaceContext) {
                throw new IllegalStateException();
            }
            model.baselineSetSyncContext = (IBaselineSetSyncContext)workspaceContext;
        } else if (workspaceContext instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext wsc = (IWorkspaceSyncContext)workspaceContext;
            if (model.getWorkspaceSyncContext(wsc.getLocal()) == null) {
                model.workspaceContexts.add(wsc);
                ITeamRepository repo = wsc.teamRepository();
                if (model.teamRepositories.add(repo)) {
                    model.queueEvent(new PropertyChangeEvent((IEventSource)model, "com.ibm.team.repository.PropertyAddMany", (Object)model, (Object)"teamRepositories", null, Collections.singletonList(repo)));
                }
                model.queueEvent(new PropertyChangeEvent((IEventSource)model, "com.ibm.team.repository.PropertyAddMany", (Object)model, (Object)"workspaceSyncContexts", null, Collections.singletonList(workspaceContext)));
            }
        } else {
            if (model.multiContext != null) {
                throw new IllegalStateException();
            }
            model.multiContext = workspaceContext;
        }
        ITeamRepository repo = info.getLocalConnection() != null ? info.getLocalConnection().teamRepository() : info.getRemote().teamRepository();
        ComponentSyncContext context = ComponentSyncContext.create(info, model, model.getEventManager(), ItemCache.create(repo), workspaceContext);
        context.init();
        model.componentContexts.add(context);
        model.queueEvent(new PropertyChangeEvent((IEventSource)model, "com.ibm.team.repository.PropertyAddMany", (Object)model, (Object)"componentSyncContexts", null, Collections.singletonList(context)));
        ComponentSyncModelUpdateOperation.updateComponentContexts(model, (Collection<IComponentSyncContext>)Collections.singletonList(context), Collections.EMPTY_LIST, monitor);
        return context;
    }

    /*
     * Exception decompiling
     */
    public static IStatus updateComponentContexts(ComponentSyncModel model, Collection<IComponentSyncContext> initContexts, Collection<IComponentSyncContext> disposeContexts, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

