/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.LocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;

public class ComponentSyncModelInitOperation
extends FileSystemOperation {
    ComponentSyncModel model;

    public ComponentSyncModelInitOperation(DilemmaHandler handler) {
        super(handler);
    }

    public void init(ComponentSyncModel model) {
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ComponentSyncModel componentSyncModel = this.model;
        synchronized (componentSyncModel) {
            Bundle bundle = FileSystemResourcesPlugin.getDefault().getBundle();
            while ((bundle.getState() & 8) != 0) {
                try {
                    ((Object)((Object)this)).wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        try {
            this.model.acquire();
            monitor.beginTask(Messages.ComponentSyncModel_3, 100);
            ((ComponentSyncManager)this.model.getComponentSyncManager()).update((IProgressMonitor)new SubProgressMonitor(monitor, 30));
            IComponentSyncContext[] contexts = this.model.getComponentSyncContexts();
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 70);
            try {
                subMonitor.beginTask(Messages.ComponentSyncModel_4, contexts.length);
                int i = 0;
                while (i < contexts.length) {
                    contexts[i].refresh(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    contexts[i].getLocalChangeSource().update();
                    ++i;
                }
            }
            finally {
                subMonitor.done();
            }
            ((LocalSynchronizationManager)this.model.getLocalSynchronizationManager()).init();
        }
        finally {
            this.model.release();
            monitor.done();
        }
    }
}

