/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.BaselineGroupNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQueryContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BaselineGroupOperation
extends FileSystemOperation {
    List elements;
    IQueryContext agent;

    public BaselineGroupOperation(DilemmaHandler handler) {
        super(handler);
    }

    public void computeItemsAndChildren(List elements, IQueryContext context) {
        this.elements = elements;
        this.agent = context;
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.elements.size() * 4));
            if (this.elements.isEmpty()) {
                return;
            }
            for (BaselineGroupNode group : this.elements) {
                if (!group.getResolve() && !group.activities.isEmpty()) {
                    group.isResolved = false;
                    this.agent.setRemoved(group.activities);
                    group.activities = Collections.EMPTY_LIST;
                }
                if (group.getResolve()) {
                    List allChangeSets;
                    ComponentSyncContext context = (ComponentSyncContext)group.getActivitySource().getModel();
                    IChangeHistorySyncReport historyReport = context.root.changeHistorySyncReport;
                    IComponent component = context.getComponent();
                    if (group instanceof IIncomingBaselineGroup) {
                        allChangeSets = historyReport.incomingChangeSets((IComponentHandle)component);
                    } else if (group instanceof IOutgoingBaselineGroup) {
                        allChangeSets = historyReport.outgoingChangeSets((IComponentHandle)component);
                    } else {
                        throw new IllegalStateException("Unexpected type for " + group);
                    }
                    List filteredHandles = null;
                    if (group.ancestor != null) {
                        IBaselineConnection bc = SCMPlatform.getWorkspaceManager((ITeamRepository)context.teamRepository()).getBaselineConnection(group.baseline, (IProgressMonitor)progress.newChild(1));
                        IBaselineConnection ac = SCMPlatform.getWorkspaceManager((ITeamRepository)context.teamRepository()).getBaselineConnection(group.ancestor, (IProgressMonitor)progress.newChild(1));
                        IChangeHistorySyncReport report = bc.changeHistory().compareChangeHistories(ac.changeHistory(), (IProgressMonitor)progress.newChild(1));
                        List newHandles = report.outgoingChangeSets();
                        filteredHandles = ComponentBaselineUtil.intersect(newHandles, allChangeSets);
                    } else {
                        List changeSetsAfterBasis;
                        if (group instanceof IIncomingBaselineGroup) {
                            changeSetsAfterBasis = historyReport.incomingChangeSetsAfterBasis((IComponentHandle)component);
                        } else if (group instanceof IOutgoingBaselineGroup) {
                            changeSetsAfterBasis = historyReport.outgoingChangeSetsAfterBasis((IComponentHandle)component);
                        } else {
                            throw new IllegalStateException("Unexpected type for " + group);
                        }
                        filteredHandles = ComponentBaselineUtil.diff(allChangeSets, changeSetsAfterBasis);
                        progress.worked(3);
                    }
                    List newActivities = ComponentBaselineUtil.createBaselineActivities(filteredHandles, group, (IProgressMonitor)progress.newChild(1));
                    ArrayList oldActivities = new ArrayList(group.activities);
                    ComponentBaselineUtil.updateActivities(oldActivities, newActivities);
                    this.agent.setRemoved(group.activities);
                    group.activities = oldActivities;
                    this.agent.setAdded(group.activities);
                    group.children[0] = oldActivities;
                    group.isResolved = true;
                    continue;
                }
                progress.worked(3);
            }
        }
        finally {
            monitor.done();
        }
    }
}

