/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackPathResolver
implements IPathResolver {
    private List<IPathResolver> nestedResolvers;

    public FallbackPathResolver(List<IPathResolver> toDelegateTo) {
        this.nestedResolvers = toDelegateTo;
    }

    public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<SiloedItemId<IVersionable>> filtered = new ArrayList<SiloedItemId<IVersionable>>();
        ArrayList<SiloedItemId<IVersionable>> nulls = new ArrayList<SiloedItemId<IVersionable>>();
        for (SiloedItemId<IVersionable> next : unresolved) {
            if (next.getItemId().isNull()) {
                nulls.add(next);
                continue;
            }
            filtered.add(next);
        }
        Map<SiloedItemId<IVersionable>, VersionablePath> currentState = FallbackPathResolver.createUnresolvedMap(filtered);
        SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.nestedResolvers.size());
        for (IPathResolver next : this.nestedResolvers) {
            boolean hasUnresolved = FallbackPathResolver.resolve(currentState, next, (IProgressMonitor)loopProgress.newChild(1));
            if (!hasUnresolved) break;
        }
        currentState.putAll(FallbackPathResolver.createUnresolvedMap(nulls));
        return currentState;
    }

    private static boolean resolve(Map<SiloedItemId<IVersionable>, VersionablePath> currentState, IPathResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<SiloedItemId> toResolve = new HashSet<SiloedItemId>();
        for (Map.Entry<SiloedItemId<IVersionable>, VersionablePath> next : currentState.entrySet()) {
            if (next.getValue().isAbsolute()) continue;
            toResolve.add(next.getValue().getSiloedRoot());
        }
        Map resolved = resolver.resolve(toResolve, monitor);
        boolean unresolvedRemain = false;
        for (Map.Entry<SiloedItemId<IVersionable>, VersionablePath> next : currentState.entrySet()) {
            VersionablePath rootPath = (VersionablePath)resolved.get(next.getKey());
            if (rootPath != null) {
                next.setValue(rootPath.append(next.getValue()));
            }
            if (next.getValue().isAbsolute()) continue;
            unresolvedRemain = true;
        }
        return unresolvedRemain;
    }

    private static Map<SiloedItemId<IVersionable>, VersionablePath> createUnresolvedMap(Collection<SiloedItemId<IVersionable>> unresolved) {
        HashMap<SiloedItemId<IVersionable>, VersionablePath> result = new HashMap<SiloedItemId<IVersionable>, VersionablePath>();
        for (SiloedItemId<IVersionable> next : unresolved) {
            result.put(next, VersionablePath.create(Collections.emptyList(), next, (boolean)false));
        }
        return result;
    }
}

