/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.AcceptDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAcceptOperation;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.AcceptEvent;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentLoader;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISyncFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWarnAcceptUser;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.LocalFolderNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.operations.UnshareProjectsOperation;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSyncUtil {
    public static Collection[] getRemoteActivities(Collection resources, boolean isIncoming) {
        HashSet allActivities = new HashSet();
        HashSet<IRemoteActivity> associatedActivities = new HashSet<IRemoteActivity>();
        HashSet<IRemoteActivity> conflictedActivities = new HashSet<IRemoteActivity>();
        HashSet<IComponentSyncContext> contextsWithLocalChanges = new HashSet<IComponentSyncContext>();
        ArrayList<IPath> resourcesPaths = new ArrayList<IPath>();
        HashSet<IComponentSyncContext> contexts = new HashSet<IComponentSyncContext>();
        Iterator iResources = resources.iterator();
        while (iResources.hasNext()) {
            IResource resource = (IResource)Adapters.getAdapter(iResources.next(), IResource.class);
            if (resource == null) continue;
            resourcesPaths.add(resource.getFullPath());
            IComponentSyncContext context = ComponentSyncUtil.getContext(resource);
            if (context == null) continue;
            contexts.add(context);
        }
        for (IComponentSyncContext context : contexts) {
            List activities;
            if (isIncoming) {
                activities = context.getIncomingActivitySource().getActivities();
            } else {
                activities = context.getOutgoingActivitySource().getActivities();
                if (!context.getLocalChangeSource().getLocalChanges().isEmpty()) {
                    contextsWithLocalChanges.add(context);
                }
            }
            allActivities.addAll(activities);
            for (IRemoteActivity activity : activities) {
                if (!context.hasConflict(activity) && !context.isUnresolved(activity)) continue;
                conflictedActivities.add(activity);
            }
        }
        for (IRemoteActivity activity : allActivities) {
            List changes = activity.getChanges();
            block4: for (IRemoteChangeSummary summary : changes) {
                Path pathInChange = isIncoming ? new Path(summary.getBeforePath()) : new Path(summary.getAfterPath());
                for (IPath fullPath : resourcesPaths) {
                    if (fullPath.segmentCount() != pathInChange.matchingFirstSegments(fullPath)) continue;
                    associatedActivities.add(activity);
                    continue block4;
                }
            }
        }
        if (isIncoming) {
            return new Collection[]{allActivities, associatedActivities, conflictedActivities};
        }
        return new Collection[]{allActivities, associatedActivities, conflictedActivities, contextsWithLocalChanges};
    }

    public static IComponentSyncContext getContext(IResource resource) {
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable == null) {
            return null;
        }
        return ComponentSyncUtil.getContext(shareable);
    }

    public static IComponentSyncContext getContext(IShareable shareable) {
        IShare share = shareable.getShare();
        if (share == null) {
            return null;
        }
        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
        IComponentHandle component = sharingDescriptor.getComponent();
        IContextHandle workspace = sharingDescriptor.getConnectionHandle();
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        IComponentSyncContext context = null;
        int i = 0;
        while (i < contexts.length) {
            if (contexts[i].isLocal() && contexts[i].getComponent().sameItemId((IItemHandle)component)) {
                IConnection connection = contexts[i].getOutgoingConnection();
                IWorkspace itemId = null;
                if (connection instanceof IWorkspaceConnection) {
                    itemId = ((IWorkspaceConnection)connection).getResolvedWorkspace();
                }
                if (connection instanceof IBaselineConnection) {
                    itemId = ((IBaselineConnection)connection).getResolvedBaseline();
                }
                if (workspace.sameItemId((IItemHandle)itemId)) {
                    context = contexts[i];
                    break;
                }
            }
            ++i;
        }
        return context;
    }

    public static IComponentSyncContext[] getComponentSyncContexts(IWorkspaceSyncContext context, boolean excludeDisconnected, boolean excludeNoChanges) {
        IComponentSyncContext[] contexts = context.getComponentSyncContexts();
        if (!excludeDisconnected && !excludeNoChanges) {
            return contexts;
        }
        ArrayList<IComponentSyncContext> result = new ArrayList<IComponentSyncContext>();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext compContext = contexts[i];
            if (!(excludeDisconnected && ComponentSyncUtil.isDisconnected(compContext) || excludeNoChanges && !compContext.hasChanges())) {
                result.add(contexts[i]);
            }
            ++i;
        }
        return result.toArray(new IComponentSyncContext[result.size()]);
    }

    public static boolean isDisconnected(IComponentSyncContext context) {
        IWorkspace workspace;
        IComponentSyncModel model = context.getComponentSyncModel();
        IWorkspace iWorkspace = workspace = context.getOutgoingTeamPlace() != null ? context.getOutgoingTeamPlace().getResolvedWorkspace() : null;
        if (workspace == null) {
            return true;
        }
        return !model.getLocalSynchronizationManager().isShared((IWorkspaceHandle)workspace, (IComponentHandle)context.getComponent());
    }

    public static boolean enableDeliver(Collection selection) {
        Set<IComponentSyncContext> contexts = ComponentSyncUtil.getContexts(selection);
        if (ComponentSyncUtil.hasComponentContextTwins(contexts)) {
            return false;
        }
        boolean allPrivateContexts = true;
        for (IComponentSyncContext context : contexts) {
            if (context.getType() == 3 || context.getType() == 4) {
                return true;
            }
            if (context.getType() == 1) continue;
            allPrivateContexts = false;
        }
        if (allPrivateContexts) {
            return false;
        }
        for (IComponentSyncContext context : contexts) {
            if (context.getOutgoingActivitySource().getConflictItems().isEmpty()) continue;
            return false;
        }
        Set[] result = ComponentSyncUtil.filter(selection, new Class[]{IOutgoingRemoteActivity.class, Object.class});
        if (!result[0].isEmpty() && result[1].isEmpty()) {
            return true;
        }
        result = ComponentSyncUtil.filter(selection, new Class[]{IOutgoingBaselineGroup.class, Object.class});
        return !result[0].isEmpty() && result[1].isEmpty();
    }

    public static boolean enableCheckinAndDeliver(Collection selection) {
        ArrayList<IUnresolvedItem> convertedSelection = new ArrayList<IUnresolvedItem>();
        for (Object object : selection) {
            if (object instanceof ILocalChange) {
                convertedSelection.add(ComponentSyncUtil.findUnresolvedItem((ILocalChange)object));
                continue;
            }
            convertedSelection.add((IUnresolvedItem)object);
        }
        Set<IComponentSyncContext> contexts = ComponentSyncUtil.getContexts(convertedSelection);
        boolean allPrivateContexts = true;
        for (IComponentSyncContext context : contexts) {
            if (context.getType() != 1) {
                allPrivateContexts = false;
            }
            if (context.getIncomingTeamPlace().isStream()) continue;
            return false;
        }
        return !allPrivateContexts;
    }

    public static boolean enableCheckin(IComponentSyncModel model) {
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            if (contexts[i].isLocal() && !ComponentSyncUtil.isDisconnected(contexts[i]) && contexts[i].getLocalChangeSource().size() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean enableAccept(IComponentSyncModel model, boolean excludeDisconnected) {
        IComponentSyncContext[] contexts;
        IComponentSyncContext[] iComponentSyncContextArray = contexts = model.getComponentSyncContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context1 = iComponentSyncContextArray[n2];
            if (!excludeDisconnected || !ComponentSyncUtil.isDisconnected(context1)) {
                IComponentSyncContext[] iComponentSyncContextArray2 = contexts;
                int n3 = contexts.length;
                int n4 = 0;
                while (n4 < n3) {
                    IComponentSyncContext context2 = iComponentSyncContextArray2[n4];
                    if (!(excludeDisconnected && ComponentSyncUtil.isDisconnected(context2) || context1 == context2 || !context1.getComponent().sameItemId((IItemHandle)context2.getComponent()) || context1.getOutgoingConnection() != context2.getOutgoingConnection() || context1.getIncomingConnection() == context2.getIncomingConnection())) {
                        return false;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        iComponentSyncContextArray = contexts;
        n = contexts.length;
        n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (!excludeDisconnected || !ComponentSyncUtil.isDisconnected(context)) {
                if (context.getType() == 5 || context.getType() == 6) {
                    return true;
                }
                IIncomingActivitySource source = context.getIncomingActivitySource();
                if (!source.getActivities().isEmpty() || !source.getBaselines().isEmpty()) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean enableDeliver(IComponentSyncModel model, boolean excludeDisconnected) {
        IComponentSyncContext[] contexts;
        IComponentSyncContext[] iComponentSyncContextArray = contexts = model.getComponentSyncContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context1 = iComponentSyncContextArray[n2];
            if (!excludeDisconnected || !ComponentSyncUtil.isDisconnected(context1)) {
                IComponentSyncContext[] iComponentSyncContextArray2 = contexts;
                int n3 = contexts.length;
                int n4 = 0;
                while (n4 < n3) {
                    IComponentSyncContext context2 = iComponentSyncContextArray2[n4];
                    if (!(excludeDisconnected && ComponentSyncUtil.isDisconnected(context2) || context1 == context2 || !context1.getComponent().sameItemId((IItemHandle)context2.getComponent()) || context1.getOutgoingConnection() != context2.getOutgoingConnection() || context1.getIncomingConnection() == context2.getIncomingConnection())) {
                        return false;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        boolean hasChanges = false;
        int i = 0;
        while (i < contexts.length) {
            if (!(contexts[i].getType() == 1 || excludeDisconnected && ComponentSyncUtil.isDisconnected(contexts[i]))) {
                IOutgoingActivitySource source;
                if (contexts[i].getType() == 3 || contexts[i].getType() == 4) {
                    hasChanges = true;
                }
                if (!(source = contexts[i].getOutgoingActivitySource()).getActivities().isEmpty() || !source.getBaselines().isEmpty()) {
                    hasChanges = true;
                }
                if (contexts[i].hasConflict(source) || contexts[i].isUnresolved(source)) {
                    return false;
                }
            }
            ++i;
        }
        return hasChanges;
    }

    public static void accept(Collection selection, IComponentLoader loader, AcceptDilemmaHandler acceptProblemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ComponentSyncUtil_AcceptJobName, (int)100);
        sub.setTaskName(Messages.ComponentSyncUtil_AcceptJobName);
        try {
            Set<IComponentSyncContext> components = ComponentSyncUtil.getContexts(selection);
            if (components.isEmpty()) {
                return;
            }
            ArrayList<AcceptEvent> events = new ArrayList<AcceptEvent>();
            for (IComponentSyncContext context : components) {
                int type = context.getType();
                if (type != 2 && type != 5 && type != 6) continue;
                AcceptEvent event = new AcceptEvent();
                event.type = context.getType();
                event.context = context;
                event.combined = false;
                event.activities = null;
                if (context.getType() == 2) {
                    Set elements = ComponentSyncUtil.filter(selection, context);
                    Set[] activities = ComponentSyncUtil.filter((Collection)elements, new Class[]{IIncomingRemoteActivity.class});
                    event.activities = activities[0];
                }
                event.doit = true;
                events.add(event);
            }
            if (acceptProblemHandler instanceof IWarnAcceptUser) {
                ((IWarnAcceptUser)acceptProblemHandler).setEventsForFailures(events);
            }
            ComponentSyncModel model = (ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel();
            model.sendAcceptingEvent(events);
            sub.worked(5);
            HashMap<UUID, IWorkspaceConnection> workspaces = new HashMap<UUID, IWorkspaceConnection>();
            HashMap<UUID, ArrayList<IComponent>> connectToComponentsAdded = new HashMap<UUID, ArrayList<IComponent>>();
            HashMap<UUID, ArrayList<IComponent>> connectToComponentsRemoved = new HashMap<UUID, ArrayList<IComponent>>();
            try {
                ArrayList<IComponent> componentsAdded;
                IWorkspaceConnection connection;
                sub.subTask(Messages.ComponentSyncUtil_AcceptChangeSetsJobName);
                sub.setWorkRemaining(events.size() * 2);
                IAcceptOperation acceptOp = IEclipseFileSystemManager.instance.getAcceptOperation(acceptProblemHandler);
                int accepts = 0;
                for (AcceptEvent acceptEvent : events) {
                    if (!acceptEvent.doit) continue;
                    ComponentSyncContext context = (ComponentSyncContext)acceptEvent.context;
                    connection = context.getOutgoingTeamPlace();
                    UUID uuid = connection.getResolvedWorkspace().getItemId();
                    workspaces.put(uuid, connection);
                    switch (context.getType()) {
                        case 2: {
                            ++accepts;
                            context.prepareAcceptOperation(acceptOp, acceptEvent.activities, (IProgressMonitor)sub.newChild(1));
                            break;
                        }
                        case 5: {
                            ComponentFlowUtil.acceptComponent(context, (IProgressMonitor)sub.newChild(2));
                            componentsAdded = (List)connectToComponentsAdded.get(uuid);
                            if (componentsAdded == null) {
                                componentsAdded = new ArrayList<IComponent>();
                                connectToComponentsAdded.put(uuid, componentsAdded);
                            }
                            componentsAdded.add(context.getComponent());
                            break;
                        }
                        case 6: {
                            ComponentFlowUtil.acceptComponent(context, (IProgressMonitor)sub.newChild(1));
                            ArrayList<IComponent> componentsRemoved = (ArrayList<IComponent>)connectToComponentsRemoved.get(uuid);
                            if (componentsRemoved == null) {
                                componentsRemoved = new ArrayList<IComponent>();
                                connectToComponentsRemoved.put(uuid, componentsRemoved);
                            }
                            componentsRemoved.add(context.getComponent());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Internal Error: Unexpected component flow type " + context.getType());
                        }
                    }
                }
                for (Map.Entry entry : workspaces.entrySet()) {
                    UUID uuid = (UUID)entry.getKey();
                    connection = (IWorkspaceConnection)entry.getValue();
                    List componentsRemoved = (List)connectToComponentsRemoved.get(uuid);
                    if (componentsRemoved != null && !componentsRemoved.isEmpty()) {
                        new UnshareProjectsOperation((IConnection)connection, componentsRemoved, true).run((IProgressMonitor)sub.newChild(componentsRemoved.size()));
                    }
                    if ((componentsAdded = (ArrayList<IComponent>)connectToComponentsAdded.get(uuid)) == null || componentsAdded.isEmpty()) continue;
                    loader.load(connection, (List<? extends IComponentHandle>)componentsAdded);
                }
                acceptOp.run((IProgressMonitor)sub.newChild(accepts));
            }
            finally {
                model.sendAcceptedEvent(events);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static Collection<IComponentSyncContext> getLoadedContexts(IComponentHandle component, boolean checkLocal, boolean checkShared) {
        ArrayList<IComponentSyncContext> result = new ArrayList<IComponentSyncContext>();
        ComponentSyncModel model = (ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel();
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            boolean isShared;
            IComponentSyncContext context = contexts[i];
            IComponent c = context.getComponent();
            if (!(!component.sameItemId((IItemHandle)c) || checkLocal && !context.isLocal() || checkShared && !(isShared = model.getLocalSynchronizationManager().isShared((IWorkspaceHandle)context.getWorkspaceSyncContext().getLocal().getResolvedWorkspace(), (IComponentHandle)c)))) {
                result.add(context);
            }
            ++i;
        }
        return result;
    }

    public static Collection<IComponentSyncContext> getBestContextsForAccept(IComponentHandle component) {
        Collection<IComponentSyncContext> result = ComponentSyncUtil.getLoadedContexts(component, true, true);
        if (result.isEmpty()) {
            result = ComponentSyncUtil.getLoadedContexts(component, true, false);
        }
        return result;
    }

    public static void acceptPatch(List changeSets, AcceptDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor = ModelUtil.monitorFor(monitor);
        try {
            monitor.beginTask(Messages.ComponentSyncUtil_AcceptPatchJobName, changeSets.size());
            ComponentSyncModel model = (ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel();
            for (IChangeSet changeSet : changeSets) {
                IComponentHandle component = changeSet.getComponent();
                IComponentSyncContext[] contexts = model.getComponentSyncContexts();
                IComponentSyncContext context = null;
                int i = 0;
                while (i < contexts.length) {
                    IComponentSyncContext componentSyncContext = contexts[i];
                    IComponent comp = componentSyncContext.getComponent();
                    boolean isShared = componentSyncContext.getComponentSyncModel().getLocalSynchronizationManager().isShared((IWorkspaceHandle)componentSyncContext.getWorkspaceSyncContext().getLocal().getResolvedWorkspace(), (IComponentHandle)comp);
                    if (comp.sameItemId((IItemHandle)component) && isShared) {
                        context = componentSyncContext;
                    }
                    ++i;
                }
                if (context == null) {
                    throw new IllegalStateException(Messages.ComponentSyncUtil_ErrorMessage);
                }
                context.acceptPatch(Collections.singletonList(changeSet), problemHandler, null);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static boolean enableAccept(Collection selection) {
        Set<IComponentSyncContext> contexts = ComponentSyncUtil.getContexts(selection);
        if (ComponentSyncUtil.hasComponentContextTwins(contexts)) {
            return false;
        }
        for (IComponentSyncContext context : contexts) {
            if (context.getType() == 5 || context.getType() == 6) {
                return true;
            }
            if (!ComponentSyncUtil.isReplaced(context)) continue;
            return true;
        }
        Set[] result = ComponentSyncUtil.filter(selection, new Class[]{IIncomingRemoteActivity.class, Object.class});
        if (!result[0].isEmpty() && result[1].isEmpty()) {
            return true;
        }
        result = ComponentSyncUtil.filter(selection, new Class[]{IIncomingBaselineGroup.class, Object.class});
        return !result[0].isEmpty() && result[1].isEmpty();
    }

    public static boolean allLoggedIn(Collection componentSyncContexts) {
        for (IComponentSyncContext component : componentSyncContexts) {
            if (component.getLoggedIn()) continue;
            return false;
        }
        return true;
    }

    public static boolean allLocal(Collection<IComponentSyncContext> contexts) {
        for (IComponentSyncContext context : contexts) {
            if (context.isLocal()) continue;
            return false;
        }
        return true;
    }

    public static boolean allType(Collection<IComponentSyncContext> contexts, int type) {
        for (IComponentSyncContext context : contexts) {
            if (context.getType() == type) continue;
            return false;
        }
        return true;
    }

    public static IOutgoingRemoteActivity find(IComponentSyncContext context, IChangeSetHandle changeSet) {
        for (IRemoteActivity activity : context.getOutgoingActivitySource().getActivities()) {
            if (!activity.getChangeSetHandle().sameItemId((IItemHandle)changeSet)) continue;
            return (IOutgoingRemoteActivity)activity;
        }
        return null;
    }

    public static IShareable findShareable(IRemoteChangeSummary change, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IRemoteActivity activity = change.getActivity();
        IComponentSyncContext context = activity.getActivitySource().getModel();
        IComponent component = context.getComponent();
        IShareable shareable = null;
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int i = 0;
        while (i < contexts.length) {
            if (contexts[i].getComponent().sameItemId((IItemHandle)component)) {
                progress.setWorkRemaining(contexts.length - i);
                shareable = ComponentSyncUtil.findShareable((IWorkspaceHandle)contexts[i].getOutgoingTeamPlace().getResolvedWorkspace(), (IComponentHandle)component, change, (IProgressMonitor)progress.newChild(1));
                if (shareable != null) break;
            }
            ++i;
        }
        progress.done();
        return shareable;
    }

    private static IShareable findShareable(IWorkspaceHandle ws, IComponentHandle component, IRemoteChangeSummary change, IProgressMonitor monitor) throws FileSystemClientException {
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        return sharingManager.findShareable(sharingManager.getDefaultCFARoot(), change.getItem(), component, (IContextHandle)ws, monitor);
    }

    public static IShareable findShareable(IConflictItem conflict, boolean includeEvilTwin, IProgressMonitor progress) {
        IShareable shareable = null;
        IComponentSyncContext context = conflict.getOutgoingActivitySource().getModel();
        IVersionableHandle item = conflict.getItem();
        IComponent component = context.getComponent();
        IWorkspace workspace = context.getOutgoingTeamPlace().getResolvedWorkspace();
        try {
            IResource resource;
            IPath fullName;
            ISharingManager sharingManager = FileSystemCore.getSharingManager();
            shareable = sharingManager.findShareable(sharingManager.getDefaultCFARoot(), item, (IComponentHandle)component, (IContextHandle)workspace, null);
            if (shareable == null && includeEvilTwin && (fullName = (IPath)sharingManager.getPathRelativeToShares(sharingManager.getDefaultCFARoot(), (IContextHandle)workspace, (IComponentHandle)component, Collections.singletonList(conflict.getLogicalChange().getAncestorPathHint()), progress).get(0)) != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fullName)) != null) {
                shareable = (IShareable)resource.getAdapter(IShareable.class);
            }
        }
        catch (FileSystemClientException e) {
            StatusUtil.log((Object)conflict, (Throwable)e);
        }
        return shareable;
    }

    public static IShareable findEvilTwin(IConflictItem conflict, IProgressMonitor progress) {
        IShareable shareable = null;
        IComponentSyncContext context = conflict.getOutgoingActivitySource().getModel();
        IVersionableHandle item = conflict.getItem();
        IComponent component = context.getComponent();
        IWorkspace workspace = context.getOutgoingTeamPlace().getResolvedWorkspace();
        try {
            IResource resource;
            IPath fullName;
            ISharingManager sharingManager = FileSystemCore.getSharingManager();
            shareable = sharingManager.findShareable(sharingManager.getDefaultCFARoot(), item, (IComponentHandle)component, (IContextHandle)workspace, null);
            if (shareable == null && (fullName = (IPath)sharingManager.getPathRelativeToShares(sharingManager.getDefaultCFARoot(), (IContextHandle)workspace, (IComponentHandle)component, Collections.singletonList(conflict.getLogicalChange().getAncestorPathHint()), progress).get(0)) != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fullName)) != null) {
                shareable = (IShareable)resource.getAdapter(IShareable.class);
                return shareable;
            }
        }
        catch (FileSystemClientException e) {
            StatusUtil.log((Object)conflict, (Throwable)e);
        }
        return null;
    }

    public static boolean isRemoteContentAccessible(IShareable shareable) {
        IResource resource = (IResource)shareable.getAdapter(IResource.class);
        if (!(resource instanceof IFile)) {
            return false;
        }
        IShare share = shareable.getShare();
        if (share == null) {
            return false;
        }
        ISharingDescriptor descriptor = share.getSharingDescriptor();
        if (descriptor == null) {
            return false;
        }
        ITeamRepository repo = RepositoryUtils.getTeamRepository((String)descriptor.getRepositoryUri(), (UUID)descriptor.getRepositoryId());
        if (repo == null) {
            return false;
        }
        return repo.loggedIn();
    }

    public static boolean isRemoteContentAccessible(ILocalChange change) {
        ISharingDescriptor descriptor;
        block9: {
            IShare share;
            block8: {
                IShareable shareable;
                block7: {
                    block6: {
                        try {
                            shareable = change.getShareable();
                            if (shareable != null) break block6;
                            return false;
                        }
                        catch (FileSystemClientException e) {
                            FileSystemResourcesPlugin.log(e);
                            return false;
                        }
                    }
                    IResource resource = (IResource)shareable.getAdapter(IResource.class);
                    if (resource instanceof IFile) break block7;
                    return false;
                }
                share = shareable.getShare();
                if (share != null) break block8;
                return false;
            }
            descriptor = share.getSharingDescriptor();
            if (descriptor != null) break block9;
            return false;
        }
        ITeamRepository repo = RepositoryUtils.getTeamRepository((String)descriptor.getRepositoryUri(), (UUID)descriptor.getRepositoryId());
        return repo != null;
    }

    public static List filterComponentContextTwins(Collection selection) {
        ArrayList result = new ArrayList();
        HashSet<String> filter = new HashSet<String>();
        for (Object elt : selection) {
            if (elt instanceof IComponentSyncContext) {
                String key;
                IComponentSyncContext context = (IComponentSyncContext)elt;
                IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                if (wc == null || filter.contains(key = String.valueOf(wc.getResolvedWorkspace().getItemId().getUuidValue()) + context.getComponent().getItemId().getUuidValue())) continue;
                filter.add(key);
                result.add(elt);
                continue;
            }
            result.add(elt);
        }
        return result;
    }

    public static boolean hasComponentContextTwins(Collection selection) {
        for (Object elt1 : selection) {
            if (!(elt1 instanceof IComponentSyncContext)) continue;
            IComponentSyncContext context1 = (IComponentSyncContext)elt1;
            for (Object elt2 : selection) {
                IComponentSyncContext context2;
                if (!(elt2 instanceof IComponentSyncContext) || context1 == (context2 = (IComponentSyncContext)elt2) || !context1.getComponent().sameItemId((IItemHandle)context2.getComponent()) || context1.getOutgoingConnection() != context2.getOutgoingConnection() || context1.getIncomingConnection() == context2.getIncomingConnection()) continue;
                return true;
            }
        }
        return false;
    }

    public static Set filter(Collection selection, IComponentSyncContext context) {
        if (selection.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<IComponentSyncContext> result = new HashSet<IComponentSyncContext>();
        for (Object element : selection) {
            if (ComponentSyncUtil.hasContext(element, context)) {
                result.add(context);
                continue;
            }
            if (ComponentSyncUtil.getContext(element) != context) continue;
            result.add((IComponentSyncContext)element);
        }
        return result;
    }

    static boolean hasContext(Object element, IComponentSyncContext context) {
        if (element instanceof IWorkspaceSyncContext) {
            IComponentSyncContext[] contexts = ((IWorkspaceSyncContext)element).getComponentSyncContexts();
            int i = 0;
            while (i < contexts.length) {
                if (contexts[i] == context) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Set filter(Collection selection, IWorkspaceSyncContext context) {
        if (selection.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet result = new HashSet();
        for (Object element : selection) {
            IComponentSyncContext c = ComponentSyncUtil.getContext(element);
            if (c == null || c.getWorkspaceSyncContext() != context) continue;
            result.add(element);
        }
        return result;
    }

    public static Set[] filter(Collection selection, Class[] types) {
        Set[] result = new Set[types.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new HashSet();
            ++i;
        }
        block1: for (Object element : selection) {
            int i2 = 0;
            while (i2 < types.length) {
                Collection<Object> activities;
                ISyncFolder folder;
                IRemoteActivity activity;
                Object source;
                IComponentSyncContext context;
                IWorkspaceSyncContext workspaceContext;
                IComponentSyncContext[] contexts;
                Set[] setArray;
                if (types[i2] == IWorkspaceSyncContext.class && element instanceof IWorkspaceSyncContext) {
                    result[i2].add(element);
                    continue block1;
                }
                if (element instanceof IWorkspaceSyncContext && (setArray = ComponentSyncUtil.filter((Collection)Arrays.asList(contexts = (workspaceContext = (IWorkspaceSyncContext)element).getComponentSyncContexts()), new Class[]{types[i2], Object.class}))[1].isEmpty()) {
                    result[i2].addAll(setArray[0]);
                    continue block1;
                }
                if (types[i2] == IComponentSyncContext.class && element instanceof IComponentSyncContext) {
                    result[i2].add(element);
                    continue block1;
                }
                if (types[i2] == IOutgoingActivitySource.class) {
                    if (element instanceof IOutgoingActivitySource) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].add(context.getOutgoingActivitySource());
                        continue block1;
                    }
                }
                if (types[i2] == IIncomingActivitySource.class) {
                    if (element instanceof IIncomingActivitySource) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].add(context.getIncomingActivitySource());
                        continue block1;
                    }
                }
                if (types[i2] == IActivitySource.class) {
                    if (element instanceof IActivitySource) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].addAll(context.getActivitySources());
                        continue block1;
                    }
                }
                if (types[i2] == IOutgoingRemoteActivity.class) {
                    if (element instanceof IOutgoingRemoteActivity) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IOutgoingActivitySource) {
                        source = (IActivitySource)element;
                        result[i2].addAll(ComponentSyncUtil.getActivities((IActivitySource)source));
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].addAll(context.getOutgoingActivitySource().getActivities());
                        continue block1;
                    }
                }
                if (types[i2] == IIncomingRemoteActivity.class) {
                    if (element instanceof IIncomingRemoteActivity) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IIncomingActivitySource) {
                        source = (IActivitySource)element;
                        result[i2].addAll(ComponentSyncUtil.getActivities((IActivitySource)source));
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].addAll(context.getIncomingActivitySource().getActivities());
                        continue block1;
                    }
                }
                if (types[i2] == ISuspendedRemoteActivity.class) {
                    if (element instanceof ISuspendedRemoteActivity) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof ISuspendedActivitySource) {
                        source = (ISuspendedActivitySource)element;
                        result[i2].addAll(source.getActivities());
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].addAll(context.getSuspendedActivitySource().getActivities());
                        continue block1;
                    }
                }
                if (types[i2] == IRemoteActivity.class) {
                    if (element instanceof IRemoteActivity) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IActivitySource) {
                        source = (IActivitySource)element;
                        result[i2].addAll(ComponentSyncUtil.getActivities((IActivitySource)source));
                        continue block1;
                    }
                }
                if (types[i2] == IOutgoingRemoteChangeSummary.class) {
                    if (element instanceof IOutgoingRemoteChangeSummary) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IOutgoingRemoteActivity) {
                        activity = (IOutgoingRemoteActivity)element;
                        result[i2].addAll(activity.getChanges());
                        continue block1;
                    }
                    if (element instanceof IOutgoingActivityFolder) {
                        folder = (IOutgoingActivityFolder)element;
                        result[i2].addAll(folder.getActivity().getChanges((IActivityFolder)folder));
                        continue block1;
                    }
                    if (element instanceof IOutgoingActivitySource) {
                        source = (IOutgoingActivitySource)element;
                        activities = ComponentSyncUtil.getActivities((IActivitySource)source);
                        for (IRemoteActivity iRemoteActivity : activities) {
                            result[i2].addAll(iRemoteActivity.getChanges());
                        }
                        continue block1;
                    }
                }
                if (types[i2] == IIncomingRemoteChangeSummary.class) {
                    if (element instanceof IIncomingRemoteChangeSummary) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IIncomingRemoteActivity) {
                        activity = (IIncomingRemoteActivity)element;
                        result[i2].addAll(activity.getChanges());
                        continue block1;
                    }
                    if (element instanceof IIncomingActivityFolder) {
                        folder = (IIncomingActivityFolder)element;
                        result[i2].addAll(folder.getActivity().getChanges((IActivityFolder)folder));
                        continue block1;
                    }
                    if (element instanceof IIncomingActivitySource) {
                        source = (IIncomingActivitySource)element;
                        activities = ComponentSyncUtil.getActivities((IActivitySource)source);
                        for (IRemoteActivity iRemoteActivity : activities) {
                            result[i2].addAll(iRemoteActivity.getChanges());
                        }
                        continue block1;
                    }
                }
                if (types[i2] == ISuspendedRemoteChangeSummary.class) {
                    if (element instanceof ISuspendedRemoteChangeSummary) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof ISuspendedRemoteActivity) {
                        activity = (ISuspendedRemoteActivity)element;
                        result[i2].addAll(activity.getChanges());
                        continue block1;
                    }
                    if (element instanceof ISuspendedActivityFolder) {
                        folder = (ISuspendedActivityFolder)element;
                        result[i2].addAll(folder.getActivity().getChanges((IActivityFolder)folder));
                        continue block1;
                    }
                    if (element instanceof ISuspendedActivitySource) {
                        source = (ISuspendedActivitySource)element;
                        activities = source.getActivities();
                        for (IRemoteActivity iRemoteActivity : activities) {
                            result[i2].addAll(iRemoteActivity.getChanges());
                        }
                        continue block1;
                    }
                }
                if (types[i2] == IRemoteChangeSummary.class) {
                    if (element instanceof IRemoteChangeSummary) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IRemoteActivity) {
                        activity = (IRemoteActivity)element;
                        result[i2].addAll(activity.getChanges());
                        continue block1;
                    }
                    if (element instanceof IActivityFolder) {
                        folder = (IActivityFolder)element;
                        result[i2].addAll(folder.getActivity().getChanges((IActivityFolder)folder));
                        continue block1;
                    }
                    if (element instanceof IActivitySource) {
                        source = (IActivitySource)element;
                        activities = ComponentSyncUtil.getActivities((IActivitySource)source);
                        for (IRemoteActivity iRemoteActivity : activities) {
                            result[i2].addAll(iRemoteActivity.getChanges());
                        }
                        continue block1;
                    }
                }
                if (types[i2] == IFileSystemWorkItem.class) {
                    if (element instanceof IFileSystemWorkItem) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IRemoteActivity) {
                        result[i2].addAll(((IRemoteActivity)element).getWorkItems());
                        continue block1;
                    }
                    if (element instanceof IActivitySource) {
                        source = (IActivitySource)element;
                        activities = ComponentSyncUtil.getActivities((IActivitySource)source);
                        for (IRemoteActivity iRemoteActivity : activities) {
                            result[i2].addAll(iRemoteActivity.getWorkItems());
                        }
                        continue block1;
                    }
                }
                if (types[i2] == ILocalChange.class) {
                    if (element instanceof ILocalChange) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof ILocalFolder) {
                        folder = (ILocalFolder)element;
                        result[i2].addAll(folder.getLocalChangeSource().getLocalChanges((ILocalFolder)folder));
                        continue block1;
                    }
                    if (element instanceof ILocalChangeSource) {
                        source = (ILocalChangeSource)element;
                        result[i2].addAll(source.getLocalChanges());
                        continue block1;
                    }
                    if (element instanceof IUnresolvedItem) {
                        IUnresolvedItem item = (IUnresolvedItem)element;
                        result[i2].addAll(item.getLocalChanges());
                        continue block1;
                    }
                    if (element instanceof IUnresolvedFolder) {
                        folder = (IUnresolvedFolder)element;
                        for (IUnresolvedItem item : folder.getItems()) {
                            result[i2].addAll(item.getLocalChanges());
                        }
                        continue block1;
                    }
                    if (element instanceof IUnresolvedSource) {
                        source = (IUnresolvedSource)element;
                        result[i2].addAll(source.getModel().getLocalChangeSource().getLocalChanges());
                        continue block1;
                    }
                }
                if (types[i2] == IConflictItem.class) {
                    if (element instanceof IConflictItem) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof ILocalChangeSource) {
                        source = (ILocalChangeSource)element;
                        result[i2].addAll(source.getModel().getOutgoingActivitySource().getConflictItems());
                        continue block1;
                    }
                }
                if (types[i2] == IIncomingBaselineGroup.class) {
                    if (element instanceof IIncomingBaselineGroup) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IIncomingActivitySource) {
                        source = (IActivitySource)element;
                        result[i2].addAll(source.getBaselines());
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].addAll(context.getIncomingActivitySource().getBaselines());
                        continue block1;
                    }
                }
                if (types[i2] == IOutgoingBaselineGroup.class) {
                    if (element instanceof IOutgoingBaselineGroup) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IOutgoingActivitySource) {
                        source = (IActivitySource)element;
                        result[i2].addAll(source.getBaselines());
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].addAll(context.getOutgoingActivitySource().getBaselines());
                        continue block1;
                    }
                }
                if (types[i2] == IBaselineGroup.class) {
                    if (element instanceof IBaselineGroup) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IActivitySource) {
                        source = (IActivitySource)element;
                        result[i2].addAll(source.getBaselines());
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        result[i2].addAll(context.getIncomingActivitySource().getBaselines());
                        result[i2].addAll(context.getOutgoingActivitySource().getBaselines());
                        continue block1;
                    }
                }
                if (types[i2] == IUnresolvedItem.class) {
                    if (element instanceof IUnresolvedItem) {
                        result[i2].add(element);
                        continue block1;
                    }
                    if (element instanceof IUnresolvedFolder) {
                        folder = (IUnresolvedFolder)element;
                        result[i2].addAll(folder.getItems());
                        continue block1;
                    }
                    if (element instanceof IUnresolvedSource) {
                        source = (IUnresolvedSource)element;
                        for (IUnresolvedFolder folder2 : source.getFolders()) {
                            result[i2].addAll(folder2.getItems());
                        }
                        continue block1;
                    }
                    if (element instanceof IComponentSyncContext) {
                        context = (IComponentSyncContext)element;
                        for (IUnresolvedFolder folder2 : context.getUnresolvedSource().getFolders()) {
                            result[i2].addAll(folder2.getItems());
                        }
                        continue block1;
                    }
                }
                if (types[i2] == Object.class) {
                    result[i2].add(element);
                    continue block1;
                }
                ++i2;
            }
        }
        return result;
    }

    public static Set<ITeamRepository> getTeamRepositories(Collection selection) {
        HashSet<ITeamRepository> result = new HashSet<ITeamRepository>();
        for (Object element : selection) {
            ITeamRepository repo = ComponentSyncUtil.getTeamRepository(element);
            if (repo == null) continue;
            result.add(repo);
        }
        return result;
    }

    public static ITeamRepository getTeamRepository(Object element) {
        if (element instanceof IItemHandle) {
            Object origin = ((IItemHandle)element).getOrigin();
            return origin instanceof ITeamRepository ? (ITeamRepository)origin : null;
        }
        if (element instanceof ILocalChange) {
            IComponentSyncContext context = ComponentSyncUtil.getContext(FileSystemResourcesPlugin.getComponentSyncModel(), (ILocalChange)element);
            return context != null ? context.teamRepository() : null;
        }
        IWorkspaceSyncContext wsc = ComponentSyncUtil.getWorkspaceContext(element);
        return wsc != null ? wsc.teamRepository() : null;
    }

    public static Set<IWorkspaceSyncContext> getWorkspaceContexts(Collection selection) {
        HashSet<IWorkspaceSyncContext> result = new HashSet<IWorkspaceSyncContext>();
        for (Object element : selection) {
            IWorkspaceSyncContext context = ComponentSyncUtil.getWorkspaceContext(element);
            if (context == null) continue;
            result.add(context);
        }
        return result;
    }

    public static IWorkspaceSyncContext getWorkspaceContext(Object element) {
        if (element instanceof IWorkspaceSyncContext) {
            return (IWorkspaceSyncContext)element;
        }
        IComponentSyncContext context = ComponentSyncUtil.getContext(element);
        return context != null ? context.getWorkspaceSyncContext() : null;
    }

    public static Set<IComponentSyncContext> getContexts(Collection selection) {
        HashSet<IComponentSyncContext> result = new HashSet<IComponentSyncContext>();
        for (Object element : selection) {
            if (element instanceof IWorkspaceSyncContext) {
                IComponentSyncContext[] contexts = ((IWorkspaceSyncContext)element).getComponentSyncContexts();
                result.addAll((Collection<IComponentSyncContext>)Arrays.asList(contexts));
                continue;
            }
            IComponentSyncContext context = ComponentSyncUtil.getContext(element);
            if (context == null) continue;
            result.add(context);
        }
        return result;
    }

    public static IComponentSyncContext getContext(Object element) {
        if (element instanceof IComponentSyncContext) {
            return (IComponentSyncContext)element;
        }
        if (element instanceof IActivitySource) {
            return ((IActivitySource)element).getModel();
        }
        if (element instanceof IUnresolvedSource) {
            return ((IUnresolvedSource)element).getModel();
        }
        if (element instanceof ILocalChangeSource) {
            return ((ILocalChangeSource)element).getModel();
        }
        if (element instanceof IRemoteActivity) {
            return ((IRemoteActivity)element).getActivitySource().getModel();
        }
        if (element instanceof IRemoteChangeSummary) {
            return ((IRemoteChangeSummary)element).getActivity().getActivitySource().getModel();
        }
        if (element instanceof IFileSystemWorkItem) {
            return ((IFileSystemWorkItem)element).getActivity().getActivitySource().getModel();
        }
        if (element instanceof IActivityFolder) {
            return ((IActivityFolder)element).getActivity().getActivitySource().getModel();
        }
        if (element instanceof IConflictItem) {
            return ((IConflictItem)element).getOutgoingActivitySource().getModel();
        }
        if (element instanceof IUnresolvedFolder) {
            return ((IUnresolvedFolder)element).getUnresolvedSource().getModel();
        }
        if (element instanceof IUnresolvedItem) {
            return ((IUnresolvedItem)element).getFolder().getUnresolvedSource().getModel();
        }
        if (element instanceof IBaselineGroup) {
            return ((IBaselineGroup)element).getActivitySource().getModel();
        }
        return null;
    }

    public static Collection<IUnresolvedItem> getConflictedItems(IUnresolvedFolder folder) {
        ArrayList<IUnresolvedItem> result = new ArrayList<IUnresolvedItem>();
        for (IUnresolvedItem item : folder.getItems()) {
            if (item.getConflictItems().isEmpty() && item.getPatches().isEmpty()) continue;
            result.add(item);
        }
        return result;
    }

    public static Collection<IUnresolvedFolder> getConflictedFolders(IUnresolvedSource source) {
        ArrayList<IUnresolvedFolder> result = new ArrayList<IUnresolvedFolder>();
        for (IUnresolvedFolder folder : source.getFolders()) {
            if (ComponentSyncUtil.getConflictedItems(folder).isEmpty()) continue;
            result.add(folder);
        }
        return result;
    }

    public static boolean isConflicted(IUnresolvedSource source) {
        return !ComponentSyncUtil.getConflictedFolders(source).isEmpty();
    }

    public static boolean hasMergeStates(IChange change) {
        return change != null && !change.mergeStates().isEmpty();
    }

    public static int countItemsMerged(IActivityFolder folder) {
        int count = 0;
        for (IRemoteChangeSummary c : folder.getActivity().getChanges(folder)) {
            IChange change = c.getChange();
            if (!ComponentSyncUtil.hasMergeStates(change)) continue;
            ++count;
        }
        return count;
    }

    public static int countItemsMerged(IRemoteActivity activity) {
        int count = 0;
        IChangeSet changeSet = activity.getChangeSet();
        if (changeSet != null) {
            for (IChange change : changeSet.changes()) {
                if (!ComponentSyncUtil.hasMergeStates(change)) continue;
                ++count;
            }
        }
        return count;
    }

    public static int countItemsMerged(Collection<IRemoteActivity> activities) {
        int count = 0;
        for (IRemoteActivity activity : activities) {
            count += ComponentSyncUtil.countItemsMerged(activity);
        }
        return count;
    }

    public static boolean isCompatibleRepository(Object[] selection, ITeamRepository repository) {
        int i = 0;
        while (i < selection.length) {
            Object element = selection[i];
            Object origin = null;
            if (element instanceof IItemHandle) {
                origin = ((IItemHandle)element).getOrigin();
            } else {
                IComponentSyncContext context = ComponentSyncUtil.getContext(element);
                Object object = origin = context != null ? context.teamRepository() : null;
            }
            if (origin != null && origin != repository) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Collection unreachables(Collection roots, Collection elements) {
        HashSet set = new HashSet();
        for (Object element : elements) {
            boolean reachable = false;
            for (Object root : roots) {
                IActivitySource source;
                IRemoteActivity activity;
                IFileSystemWorkItem workItem;
                IRemoteChangeSummary change;
                if (element instanceof IRemoteChangeSummary && ((change = (IRemoteChangeSummary)element) == root || change.getActivity() == root || change.getActivity().getActivitySource() == root || change.getActivity().getActivitySource().getModel() == root)) {
                    reachable = true;
                    break;
                }
                if (element instanceof IFileSystemWorkItem && ((workItem = (IFileSystemWorkItem)element) == root || workItem.getActivity() == root || workItem.getActivity().getActivitySource() == root || workItem.getActivity().getActivitySource().getModel() == root)) {
                    reachable = true;
                    break;
                }
                if (element instanceof IRemoteActivity && ((activity = (IRemoteActivity)element) == root || activity.getActivitySource() == root || activity.getActivitySource().getModel() == root)) {
                    reachable = true;
                    break;
                }
                if (!(element instanceof IActivitySource) || (source = (IActivitySource)element) != root && source.getModel() != root) continue;
                reachable = true;
                break;
            }
            if (reachable) continue;
            set.add(element);
        }
        return set;
    }

    public static IActivityFolder findFolder(IRemoteChangeSummary change) {
        IRemoteActivity activity = change.getActivity();
        List folders = activity.getFolders();
        for (IActivityFolder folder : folders) {
            if (!folder.contains(change)) continue;
            return folder;
        }
        return null;
    }

    public static ILocalFolder findLocalFolder(ILocalChange localChange) {
        IComponentSyncContext context = ComponentSyncUtil.getContext(FileSystemResourcesPlugin.getComponentSyncModel(), localChange);
        if (context == null) {
            return null;
        }
        ILocalChangeSource source = context.getLocalChangeSource();
        for (LocalFolderNode folder : source.getFolders()) {
            if (!folder.contains(localChange)) continue;
            return folder;
        }
        return null;
    }

    public static IUnresolvedItem findUnresolvedItem(ILocalChange localChange) {
        IComponentSyncContext context = ComponentSyncUtil.getContext(FileSystemResourcesPlugin.getComponentSyncModel(), localChange);
        if (context == null) {
            return null;
        }
        for (IUnresolvedFolder folder : context.getUnresolvedSource().getFolders()) {
            for (IUnresolvedItem item : folder.getItems()) {
                if (!item.getLocalChanges().contains(localChange)) continue;
                return item;
            }
        }
        return null;
    }

    public static IUnresolvedItem findUnresolvedItem(IConflictItem conflictItem) {
        for (IUnresolvedFolder folder : conflictItem.getOutgoingActivitySource().getModel().getUnresolvedSource().getFolders()) {
            for (IUnresolvedItem item : folder.getItems()) {
                if (!item.getConflictItems().contains(conflictItem)) continue;
                return item;
            }
        }
        return null;
    }

    public static List getActiveActivities(List activities) {
        ArrayList<IRemoteActivity> result = new ArrayList<IRemoteActivity>();
        for (IRemoteActivity activity : activities) {
            if (!activity.getActivitySource().getModel().isActive(activity)) continue;
            result.add(activity);
        }
        return result;
    }

    public static Collection<IBaselineGroup> getBaselineGroups(IActivitySource source, boolean isResolved) {
        ArrayList<IBaselineGroup> result = new ArrayList<IBaselineGroup>();
        for (IBaselineGroup bg : source.getBaselines()) {
            if (bg.isResolved() != isResolved) continue;
            result.add(bg);
        }
        return result;
    }

    public static Collection<IRemoteActivity> getActivities(IActivitySource source) {
        List baselines = source.getBaselines();
        if (baselines.isEmpty()) {
            return source.getActivities();
        }
        ArrayList<IRemoteActivity> activities = new ArrayList<IRemoteActivity>();
        activities.addAll(source.getActivities());
        for (IBaselineGroup bg : baselines) {
            activities.addAll(bg.getActivities());
        }
        return activities;
    }

    public static void setAutoSave(IComponentSyncModel model, boolean enable) {
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            contexts[i].getLocalChangeSource().setAutoCheckinMode(enable);
            ++i;
        }
    }

    public static void setAutoComplete(IComponentSyncModel model, boolean enable) {
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            contexts[i].getLocalChangeSource().setAutoComplete(enable && contexts[i].getType() == 1);
            ++i;
        }
    }

    public static List getCheckInActivities(IComponentSyncModel model, Collection localChanges) {
        if (localChanges.isEmpty() || !ComponentSyncUtil.sameComponent(localChanges)) {
            return Collections.EMPTY_LIST;
        }
        ILocalChange localChange = (ILocalChange)localChanges.iterator().next();
        IComponentSyncContext context = ComponentSyncUtil.getContext(model, localChange);
        return context != null ? ComponentSyncUtil.getActiveActivities(context.getOutgoingActivitySource().getActivities()) : Collections.EMPTY_LIST;
    }

    public static List getMoveToActivities(IComponentSyncContext context, Collection changes) {
        List activeActivities = ComponentSyncUtil.getActiveActivities(context.getOutgoingActivitySource().getActivities());
        for (IOutgoingRemoteChangeSummary summary : changes) {
            activeActivities.remove(summary.getActivity());
        }
        return activeActivities;
    }

    public static IComponentSyncContext getContext(IComponentSyncModel model, ILocalChange localChange) {
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            if (localChange.getComponent().sameItemId((IItemHandle)contexts[i].getComponent())) {
                IWorkspace itemId = null;
                IConnection connection = contexts[i].getOutgoingConnection();
                if (connection instanceof IWorkspaceConnection) {
                    itemId = ((IWorkspaceConnection)connection).getResolvedWorkspace();
                }
                if (connection instanceof IBaselineConnection) {
                    itemId = ((IBaselineConnection)connection).getResolvedBaseline();
                }
                if (localChange.getConnection().sameItemId((IItemHandle)itemId)) {
                    return contexts[i];
                }
            }
            ++i;
        }
        return null;
    }

    public static IFileItemHandle[] getUpdateStates(IRemoteChangeSummary change) {
        ComponentSyncContext context = (ComponentSyncContext)change.getActivity().getActivitySource().getModel();
        IUpdateReport report = context.getConflictReport();
        if (report == null) {
            return null;
        }
        IItemConflictReport itemReport = ModelUtil.getItemConflictReport(report, change.getChangeSummary());
        if (itemReport == null) {
            return null;
        }
        return new IFileItemHandle[]{(IFileItemHandle)itemReport.getSelectedContributorState(), (IFileItemHandle)itemReport.getProposedContributorState(), (IFileItemHandle)itemReport.getCommonAncestorState()};
    }

    public static boolean sameComponent(Collection localChanges) {
        IComponentHandle component = null;
        for (Object element : localChanges) {
            if (!(element instanceof ILocalChange)) {
                return false;
            }
            ILocalChange localChange = (ILocalChange)element;
            IComponentHandle current = localChange.getComponent();
            if (component != null && !component.sameItemId((IItemHandle)current)) {
                return false;
            }
            component = current;
        }
        return true;
    }

    public static boolean sameComponent(Collection localChanges, IComponentHandle component) {
        for (Object element : localChanges) {
            if (!(element instanceof ILocalChange)) {
                return false;
            }
            ILocalChange localChange = (ILocalChange)element;
            IComponentHandle current = localChange.getComponent();
            if (!component.sameItemId((IItemHandle)current)) {
                return false;
            }
            component = current;
        }
        return true;
    }

    public static Collection getComponentHandles(Collection changeSets) {
        HashMap<UUID, IComponentHandle> components = new HashMap<UUID, IComponentHandle>();
        Iterator iChangeSets = changeSets.iterator();
        while (iChangeSets.hasNext()) {
            IComponentHandle handle = ((IChangeSet)iChangeSets.next()).getComponent();
            components.put(handle.getItemId(), handle);
        }
        return components.values();
    }

    public static List<IChangeSetHandle> getChangeSetHandles(Collection activities) {
        ArrayList<IChangeSetHandle> result = new ArrayList<IChangeSetHandle>(activities.size());
        for (IRemoteActivity elt : activities) {
            result.add(elt.getChangeSetHandle());
        }
        return result;
    }

    public static List<IAuditableHandle> getWorkItemHandles(Collection workItems) {
        ArrayList<IAuditableHandle> result = new ArrayList<IAuditableHandle>(workItems.size());
        for (IFileSystemWorkItem elt : workItems) {
            result.add(elt.getWorkItemHandle());
        }
        return result;
    }

    public static List<IRemoteActivity> getOutgoingActivitiesFor(List changeSets, IWorkspaceConnection source) {
        return ComponentSyncUtil.getOutgoingActivitiesFor(FileSystemResourcesPlugin.getComponentSyncModel(), changeSets, source);
    }

    public static List<IRemoteActivity> getOutgoingActivitiesFor(IComponentSyncModel model, List changeSets, IWorkspaceConnection source) {
        IWorkspaceSyncContext workspaceContext = model.getWorkspaceSyncContext(source);
        if (workspaceContext == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IRemoteActivity> activities = new ArrayList<IRemoteActivity>();
        IComponentSyncContext[] contexts = workspaceContext.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext context = contexts[i];
            ArrayList outgoingActivities = new ArrayList();
            outgoingActivities.addAll(context.getOutgoingActivitySource().getActivities());
            for (IBaselineGroup bg : context.getOutgoingActivitySource().getBaselines()) {
                outgoingActivities.addAll(bg.getActivities());
            }
            for (IRemoteActivity activity : outgoingActivities) {
                IChangeSetHandle handle = activity.getChangeSetHandle();
                for (IChangeSetHandle changeSet : changeSets) {
                    if (!changeSet.sameItemId((IItemHandle)handle)) continue;
                    activities.add(activity);
                }
            }
            ++i;
        }
        return activities;
    }

    public static List<IRemoteActivity> getAllActivitiesFor(IComponentSyncModel model, List<IChangeSetHandle> changeSets) {
        ArrayList<IRemoteActivity> activities = new ArrayList<IRemoteActivity>();
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext context = contexts[i];
            ArrayList outgoingActivities = new ArrayList();
            outgoingActivities.addAll(context.getOutgoingActivitySource().getActivities());
            outgoingActivities.addAll(context.getIncomingActivitySource().getActivities());
            outgoingActivities.addAll(context.getSuspendedActivitySource().getActivities());
            for (IBaselineGroup bg : context.getOutgoingActivitySource().getBaselines()) {
                outgoingActivities.addAll(bg.getActivities());
            }
            for (IBaselineGroup bg : context.getIncomingActivitySource().getBaselines()) {
                outgoingActivities.addAll(bg.getActivities());
            }
            for (IRemoteActivity activity : outgoingActivities) {
                IChangeSetHandle handle = activity.getChangeSetHandle();
                for (IChangeSetHandle changeSet : changeSets) {
                    if (!changeSet.sameItemId((IItemHandle)handle)) continue;
                    activities.add(activity);
                }
            }
            ++i;
        }
        return activities;
    }

    public static boolean isLocalChangesOverride(IComponentSyncContext context, Collection<? extends IRemoteActivity> activities) {
        ILocalChangeSource localSource = context.getLocalChangeSource();
        if (localSource == null || localSource.size() == 0) {
            return false;
        }
        List localChanges = localSource.getLocalChanges();
        for (ILocalChange iLocalChange : localChanges) {
            if (!(iLocalChange.getTarget() instanceof IFolderHandle) || iLocalChange.isType(2)) continue;
            return true;
        }
        for (IRemoteActivity iRemoteActivity : activities) {
            List changes = iRemoteActivity.getChanges();
            for (IRemoteChangeSummary change : changes) {
                IChangeSummary changeSummary = change.getChangeSummary();
                if (changeSummary.item() instanceof IFolderHandle && !changeSummary.isChangeType(1)) {
                    return true;
                }
                if (!ComponentSyncUtil.match(change, localChanges)) continue;
                return true;
            }
        }
        return false;
    }

    public static IBaselineGroup getBaselineGroup(IRemoteActivity activity) {
        for (IBaselineGroup bg : activity.getActivitySource().getBaselines()) {
            if (!bg.getActivities().contains(activity)) continue;
            return bg;
        }
        return null;
    }

    public static boolean contains(IUnresolvedItem item, Object element) {
        return item.getLocalChanges().contains(element) || item.getConflictItems().contains(element) || item.getPatches().contains(element);
    }

    public static boolean match(IRemoteChangeSummary change, Collection localChanges) {
        for (ILocalChange localChange : localChanges) {
            IChangeSummary changeSummary = change.getChangeSummary();
            if (changeSummary.item().sameItemId((IItemHandle)localChange.getTarget())) {
                return true;
            }
            if (localChange.isType(4) || !localChange.getResultingPath().toString().equals(change.getAfterPath())) continue;
            return true;
        }
        return false;
    }

    public static String toString(String[] path, boolean ignoreLast) {
        StringBuffer buffer = new StringBuffer();
        int length = path.length;
        if (ignoreLast) {
            --length;
        }
        int i = 0;
        while (i < length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return buffer.toString();
    }

    /*
     * Exception decompiling
     */
    public static void save(IComponentSyncContext model, IVersionableHandle item, IRunnableWithProgress saveable, IProgressMonitor monitor) throws TeamRepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static ILocalChange getRelatedLocalChanges(IVersionableHandle item, IContextHandle connection, IComponentHandle component) {
        ILocalChange[] changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(connection, component, FileSystemCore.getSharingManager().getDefaultCFARoot());
        int i = 0;
        while (i < changes.length) {
            ILocalChange localChange = changes[i];
            IVersionableHandle target = localChange.getTarget();
            if (target != null && target.sameItemId((IItemHandle)item)) {
                return localChange;
            }
            ++i;
        }
        return null;
    }

    public static void deliver(Collection<IRemoteActivity> activities, DeliverDilemmaHandler handler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        HashMap<IComponentSyncContext, ArrayList<IChangeSetHandle>> toDeliver = new HashMap<IComponentSyncContext, ArrayList<IChangeSetHandle>>();
        for (IRemoteActivity remoteActivity : activities) {
            IComponentSyncContext context = remoteActivity.getActivitySource().getModel();
            ArrayList<IChangeSetHandle> changeSets = (ArrayList<IChangeSetHandle>)toDeliver.get(context);
            if (changeSets == null) {
                changeSets = new ArrayList<IChangeSetHandle>(3);
                toDeliver.put(context, changeSets);
            }
            changeSets.add(remoteActivity.getChangeSetHandle());
        }
        SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)toDeliver.keySet().size());
        for (IComponentSyncContext context : toDeliver.keySet()) {
            IDeliverOperation deliverOp = IEclipseFileSystemManager.instance.getDeliverOperation(handler);
            deliverOp.deliver(context.getOutgoingTeamPlace(), context.getIncomingTeamPlace(), context.getChangeHistorySyncReport(), Collections.emptyList(), (List)toDeliver.get(context), Collections.emptyList());
            deliverOp.run((IProgressMonitor)loopProgress.newChild(1));
        }
    }

    public static boolean isReplaced(IComponentSyncContext context) {
        if (context.getType() != 2) {
            return false;
        }
        IChangeHistorySyncReport report = context.getChangeHistorySyncReport();
        if (report != null) {
            IComponent component = context.getComponent();
            for (IComponentHandle replaced : report.getReplacedComponents()) {
                if (!component.sameItemId((IItemHandle)replaced)) continue;
                return true;
            }
        }
        return false;
    }
}

