/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.operations.AcceptDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAcceptOperation;
import com.ibm.team.filesystem.rcp.core.IEclipseFileSystemManager;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.AcceptEvent;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWarnAcceptUser;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.BaselineGroupNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingBaselineGroupNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingBaselineGroupNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.listeners.EventManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutate;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBaselineUtil {
    public static List createBaselineGroups(List baselines, IActivitySource source, IBaselineHandle lastAncestor, IProgressMonitor monitor) throws TeamRepositoryException {
        baselines = source.getModel().teamRepository().itemManager().fetchCompleteItems(baselines, 0, null);
        IBaseline lastBaselineAncestor = lastAncestor != null ? (IBaseline)source.getModel().teamRepository().itemManager().fetchCompleteItem((IItemHandle)lastAncestor, 0, null) : null;
        ArrayList<OutgoingBaselineGroupNode> result = new ArrayList<OutgoingBaselineGroupNode>();
        if (!baselines.isEmpty()) {
            Iterator iBaselines = baselines.iterator();
            IBaseline baseline = (IBaseline)iBaselines.next();
            while (iBaselines.hasNext()) {
                IBaseline ancestor = (IBaseline)iBaselines.next();
                BaselineGroupNode node = null;
                if (source instanceof IOutgoingActivitySource) {
                    node = new OutgoingBaselineGroupNode(baseline, ancestor, source);
                } else if (source instanceof IIncomingActivitySource) {
                    node = new IncomingBaselineGroupNode(baseline, ancestor, source);
                } else {
                    throw new IllegalArgumentException();
                }
                result.add((OutgoingBaselineGroupNode)node);
                baseline = ancestor;
            }
            BaselineGroupNode node = null;
            if (source instanceof IOutgoingActivitySource) {
                node = new OutgoingBaselineGroupNode(baseline, lastBaselineAncestor, source);
            } else if (source instanceof IIncomingActivitySource) {
                node = new IncomingBaselineGroupNode(baseline, lastBaselineAncestor, source);
            } else {
                throw new IllegalArgumentException();
            }
            result.add((OutgoingBaselineGroupNode)node);
        }
        return result;
    }

    public static void updateBaselineGroups(List oldBaselines, List newBaselines) {
        ComponentConflictUtil.updateSorted(oldBaselines, newBaselines, new ComponentConflictUtil.UpdateItem(){

            public boolean sameItem(Object object, Object other) {
                return ((BaselineGroupNode)object).getBaseline().sameItemId((IItemHandle)((BaselineGroupNode)other).getBaseline());
            }

            public void updateSameItem(Object object, Object other) {
            }
        });
        int id = 0;
        Iterator iGroups = newBaselines.iterator();
        while (iGroups.hasNext()) {
            ((BaselineGroupNode)iGroups.next()).id = id++;
        }
    }

    public static List createBaselineActivities(List changeSets, BaselineGroupNode group, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IncomingChangeSetNode> result = new ArrayList<IncomingChangeSetNode>();
        IComponentSyncContext context = group.getActivitySource().getModel();
        IWorkspaceConnection connection = null;
        if (group instanceof IncomingBaselineGroupNode) {
            connection = context.getIncomingTeamPlace();
        } else if (group instanceof OutgoingBaselineGroupNode) {
            connection = context.getOutgoingTeamPlace();
        } else {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalStateException();
        }
        for (IChangeSetHandle handle : changeSets) {
            ChangeSetNode node = null;
            if (group instanceof IncomingBaselineGroupNode) {
                node = new IncomingChangeSetNode((IConnection)connection, handle, (IIncomingActivitySource)group.getActivitySource());
            } else if (group instanceof OutgoingBaselineGroupNode) {
                node = new OutgoingChangeSetNode((IConnection)connection, handle, (IOutgoingActivitySource)group.getActivitySource());
            } else {
                throw new IllegalArgumentException();
            }
            result.add((IncomingChangeSetNode)node);
        }
        Collections.reverse(result);
        return result;
    }

    public static void updateActivities(List oldActivities, List newActivities) {
        ComponentConflictUtil.update(oldActivities, newActivities, new ComponentConflictUtil.UpdateItem(){

            public boolean sameItem(Object object, Object other) {
                return ((IRemoteActivity)object).getChangeSetHandle().sameItemId((IItemHandle)((IRemoteActivity)other).getChangeSetHandle());
            }

            public void updateSameItem(Object object, Object other) {
            }
        });
        int id = 0;
        Iterator iActivities = oldActivities.iterator();
        while (iActivities.hasNext()) {
            ((ChangeSetNode)iActivities.next()).id = id++;
        }
    }

    public static void resolve(IBaselineGroup group) {
        group.setResolve(true);
        ComponentSyncContext context = (ComponentSyncContext)group.getActivitySource().getModel();
        EventManager eventManager = context.getEventManager();
        eventManager.requestUpdate((IComponentSyncContext)context, (IMutate)((Object)group));
        eventManager.requestUpdate((IComponentSyncContext)context, EventManager.CONTEXT_FULL_REFRESH_OPERATION);
    }

    public static void syncResolve(IBaselineGroup group) {
        group.setResolve(true);
        ComponentSyncContext context = (ComponentSyncContext)group.getActivitySource().getModel();
        context.markDirty((IMutate)((Object)group));
    }

    public static int compareTo(IBaselineGroup group1, IBaselineGroup group2) {
        BaselineGroupNode node1 = (BaselineGroupNode)group1;
        BaselineGroupNode node2 = (BaselineGroupNode)group2;
        return node1.id < node2.id ? -1 : (node1.id == node2.id ? 0 : 1);
    }

    public static Collection getIncomingBaselineGroups(Collection contexts, IWorkspaceConnection incoming, Collection acceptedChangeSets) {
        HashSet<IBaselineGroup> result = new HashSet<IBaselineGroup>();
        for (IComponentSyncContext context : contexts) {
            if (context.getIncomingTeamPlace() != incoming) continue;
            for (IBaselineGroup group : context.getIncomingActivitySource().getBaselines()) {
                boolean include = false;
                for (IRemoteActivity activity : group.getActivities()) {
                    Iterator iAcceptedHandles = acceptedChangeSets.iterator();
                    while (iAcceptedHandles.hasNext()) {
                        if (!activity.getChangeSetHandle().sameItemId((IItemHandle)((IChangeSetHandle)iAcceptedHandles.next()))) continue;
                        include = true;
                        break;
                    }
                    if (include) break;
                }
                if (!include) continue;
                result.add(group);
            }
        }
        return result;
    }

    public static List intersect(List source, List other) {
        ArrayList<IItemHandle> result = new ArrayList<IItemHandle>();
        block0: for (IItemHandle item : source) {
            for (IItemHandle otherItem : other) {
                if (!item.sameItemId(otherItem)) continue;
                result.add(item);
                continue block0;
            }
        }
        return result;
    }

    public static List diff(List source, List other) {
        ArrayList<IItemHandle> result = new ArrayList<IItemHandle>();
        for (IItemHandle item : source) {
            boolean found = false;
            for (IItemHandle otherItem : other) {
                if (!item.sameItemId(otherItem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(item);
        }
        return result;
    }

    public static void acceptBaselines(Collection<IIncomingBaselineGroup> incomingBaselines, AcceptDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ComponentBaselineUtil_ProgressMessage, (int)100);
        final ArrayList<AcceptEvent> events = new ArrayList<AcceptEvent>();
        final HashMap<IComponentSyncContext, IIncomingBaselineGroup> input = new HashMap<IComponentSyncContext, IIncomingBaselineGroup>();
        for (IIncomingBaselineGroup bg : incomingBaselines) {
            IComponentSyncContext context = bg.getActivitySource().getModel();
            AcceptEvent event = new AcceptEvent();
            event.type = context.getType();
            event.context = context;
            event.combined = true;
            event.activities = null;
            event.baselines = new ArrayList<IBaselineHandle>();
            event.doit = true;
            events.add(event);
            input.put(context, bg);
        }
        final ComponentSyncModel model = (ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel();
        model.sendAcceptingEvent(events);
        final IAcceptOperation acceptOp = IEclipseFileSystemManager.instance.getAcceptOperation(problemHandler);
        for (AcceptEvent event : events) {
            if (event.doit) continue;
            input.remove(event.context);
        }
        new FlowInfo(input.keySet()){

            @Override
            public void iterate(IWorkspaceConnection source, IWorkspaceConnection target, Set<IComponentSyncContext> contexts, IProgressMonitor monitor) throws TeamRepositoryException {
                ArrayList<IBaseline> baselines = new ArrayList<IBaseline>();
                for (IComponentSyncContext context : contexts) {
                    baselines.add(((IIncomingBaselineGroup)input.get(context)).getBaseline());
                }
                int flags = model.getCompareToFlags();
                IChangeHistorySyncReport syncReport = SyncCache.get().fetch((IWorkspaceConnection)source, (IWorkspaceConnection)target, (int)flags, (IProgressMonitor)monitor).syncReport;
                acceptOp.acceptCombined(source, syncReport, baselines, Collections.EMPTY_LIST);
                for (AcceptEvent event : events) {
                    if (!contexts.contains(event.context)) continue;
                    if (event.baselines == null) {
                        event.baselines = new ArrayList<IBaselineHandle>(baselines.size());
                    }
                    event.baselines.addAll(baselines);
                }
            }
        }.start((IProgressMonitor)progress.newChild(10), Messages.ComponentBaselineUtil_ProgressMessageInitialization);
        if (problemHandler instanceof IWarnAcceptUser) {
            ((IWarnAcceptUser)problemHandler).setEventsForFailures(events);
        }
        try {
            acceptOp.run((IProgressMonitor)progress.newChild(90));
        }
        finally {
            model.sendAcceptedEvent(events);
        }
    }

    public static void acceptWithBaselines(Collection<IComponentSyncContext> contexts, AcceptDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ComponentBaselineUtil_ProgressMessage, (int)100);
        final ArrayList<AcceptEvent> events = new ArrayList<AcceptEvent>();
        for (IComponentSyncContext context : contexts) {
            if (!ComponentBaselineUtil.needAcceptWithBaselines(context)) continue;
            AcceptEvent event = new AcceptEvent();
            event.type = context.getType();
            event.context = context;
            event.combined = true;
            event.activities = null;
            event.baselines = new ArrayList<IBaselineHandle>();
            event.doit = true;
            events.add(event);
        }
        final ComponentSyncModel model = (ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel();
        model.sendAcceptingEvent(events);
        ArrayList<IComponentSyncContext> input = new ArrayList<IComponentSyncContext>();
        for (AcceptEvent event : events) {
            if (!event.doit) continue;
            input.add(event.context);
        }
        final IAcceptOperation acceptOp = IEclipseFileSystemManager.instance.getAcceptOperation(problemHandler);
        new FlowInfo(input){

            @Override
            public void iterate(IWorkspaceConnection source, IWorkspaceConnection target, Set<IComponentSyncContext> contexts, IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ComponentBaselineUtil_ProgressMessage, (int)2);
                ArrayList<IBaselineHandle> baselines = new ArrayList<IBaselineHandle>();
                ArrayList incomingChangeSets = new ArrayList();
                for (IComponentSyncContext context : contexts) {
                    IComponent component = context.getComponent();
                    IChangeHistorySyncReport syncReport = context.getChangeHistorySyncReport();
                    IBaselineHandle baseline = (IBaselineHandle)syncReport.remoteBases().get(component);
                    if (ModelUtil.containsSameItemId(syncReport.incomingBaselines((IComponentHandle)context.getComponent()), (IItemHandle)baseline)) {
                        baselines.add(baseline);
                    }
                    incomingChangeSets.addAll(syncReport.incomingChangeSetsAfterBasis((IComponentHandle)component));
                }
                int flags = model.getCompareToFlags();
                IChangeHistorySyncReport syncReport = SyncCache.get().fetch((IWorkspaceConnection)source, (IWorkspaceConnection)target, (int)flags, (IProgressMonitor)progress.newChild((int)1)).syncReport;
                acceptOp.acceptCombined(source, syncReport, baselines, incomingChangeSets);
                for (AcceptEvent event : events) {
                    if (!contexts.contains(event.context)) continue;
                    if (event.baselines == null) {
                        event.baselines = new ArrayList<IBaselineHandle>(baselines.size());
                    }
                    event.baselines.addAll(baselines);
                }
            }
        }.start((IProgressMonitor)progress.newChild(10), Messages.ComponentBaselineUtil_ProgressMessage);
        if (problemHandler instanceof IWarnAcceptUser) {
            ((IWarnAcceptUser)problemHandler).setEventsForFailures(events);
        }
        try {
            acceptOp.run((IProgressMonitor)progress.newChild(90));
        }
        finally {
            model.sendAcceptedEvent(events);
        }
    }

    static boolean needDeliverWithBaselines(IComponentSyncContext context) throws TeamRepositoryException {
        if (context.getType() != 2) {
            return false;
        }
        IWorkspaceConnection wcFrom = context.getOutgoingTeamPlace();
        IComponent component = context.getComponent();
        IChangeHistorySyncReport syncReport = context.getChangeHistorySyncReport();
        if (syncReport == null) {
            return false;
        }
        IBaselineHandle baseline = wcFrom.getComponentInfo((IComponentHandle)component).basis();
        List<IBaselineHandle> baselines = ModelUtil.containsSameItemId(syncReport.outgoingBaselines((IComponentHandle)component), (IItemHandle)baseline) ? Collections.singletonList(baseline) : Collections.EMPTY_LIST;
        List outgoingChangeSets = syncReport.outgoingChangeSetsAfterBasis((IComponentHandle)component);
        return !baselines.isEmpty() || !outgoingChangeSets.isEmpty();
    }

    static boolean needAcceptWithBaselines(IComponentSyncContext context) throws TeamRepositoryException {
        if (context.getType() != 2) {
            return false;
        }
        context.getIncomingTeamPlace();
        IComponent component = context.getComponent();
        IChangeHistorySyncReport syncReport = context.getChangeHistorySyncReport();
        if (syncReport == null) {
            return false;
        }
        IBaselineHandle baseline = (IBaselineHandle)syncReport.remoteBases().get(component);
        List<IBaselineHandle> baselines = ModelUtil.containsSameItemId(syncReport.incomingBaselines((IComponentHandle)component), (IItemHandle)baseline) ? Collections.singletonList(baseline) : Collections.EMPTY_LIST;
        List incomingChangeSets = syncReport.incomingChangeSetsAfterBasis((IComponentHandle)component);
        return !baselines.isEmpty() || !incomingChangeSets.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FlowInfo {
        Collection<IComponentSyncContext> contexts;

        public FlowInfo(Collection<IComponentSyncContext> contexts) {
            this.contexts = contexts;
        }

        public Set<IWorkspaceConnection> getSources() {
            HashSet<IWorkspaceConnection> result = new HashSet<IWorkspaceConnection>();
            for (IComponentSyncContext context : this.contexts) {
                if (context.getOutgoingTeamPlace() == null) {
                    throw new IllegalArgumentException();
                }
                result.add(context.getOutgoingTeamPlace());
            }
            return result;
        }

        public Set<IWorkspaceConnection> getTargets(IWorkspaceConnection source) {
            HashSet<IWorkspaceConnection> result = new HashSet<IWorkspaceConnection>();
            for (IComponentSyncContext context : this.contexts) {
                IWorkspaceConnection wc = context.getIncomingTeamPlace();
                if (source != context.getOutgoingTeamPlace()) continue;
                result.add(wc);
            }
            return result;
        }

        public Set<IComponentSyncContext> getContexts(IConnection source, IConnection target) {
            HashSet<IComponentSyncContext> result = new HashSet<IComponentSyncContext>();
            for (IComponentSyncContext context : this.contexts) {
                if (context.getOutgoingConnection() != source || context.getIncomingConnection() != target) continue;
                result.add(context);
            }
            return result;
        }

        public void iterate(IWorkspaceConnection source, IWorkspaceConnection target, Set<IComponentSyncContext> contexts, IProgressMonitor monitor) throws TeamRepositoryException {
        }

        public void start(IProgressMonitor monitor, String taskName) throws TeamRepositoryException {
            Set<IWorkspaceConnection> sources = this.getSources();
            SubMonitor sourcesProgress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)sources.size());
            for (IWorkspaceConnection source : sources) {
                Set<IWorkspaceConnection> targets = this.getTargets(source);
                SubMonitor targetsProgress = sourcesProgress.newChild(1);
                targetsProgress.setWorkRemaining(targets.size());
                for (IWorkspaceConnection target : targets) {
                    this.iterate(source, target, this.getContexts((IConnection)source, (IConnection)target), (IProgressMonitor)targetsProgress.newChild(1));
                }
            }
        }
    }
}

