/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.operations.ComponentSyncModelUpdateOperation;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.BaselineSetSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.MultiComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkspaceSyncContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBaselineSetUtil {
    public static IComponentSyncModel create(CompareInput input, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentSyncModel model = ComponentBaselineSetUtil.create();
        ComponentBaselineSetUtil.init(model, input, monitor);
        return model;
    }

    public static IComponentSyncModel create() {
        return new ComponentSyncModel();
    }

    public static void init(IComponentSyncModel model, CompareInput input, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ModelUtil.monitorFor(monitor);
        try {
            IWorkspaceConnection remote;
            IWorkspaceConnection local;
            ITeamRepository repo;
            monitor.beginTask("", 100);
            ((ComponentSyncModel)model).input = input;
            Object source = input.getSource();
            Object target = input.getTarget();
            if (source == null && target == null) {
                throw new IllegalArgumentException("Source and target cannot be both null");
            }
            if (!(source == null || source instanceof IWorkspaceHandle || source instanceof IBaselineHandle || source instanceof IBaselineSetHandle || source instanceof IConnection)) {
                throw new IllegalArgumentException("Wrong type for source " + source);
            }
            if (!(target == null || target instanceof IWorkspaceHandle || target instanceof IBaselineHandle || target instanceof IBaselineSetHandle || target instanceof IConnection)) {
                throw new IllegalArgumentException("Wrong type for target " + target);
            }
            if (target == null) {
                target = source;
            }
            if (source == null) {
                source = target;
            }
            source = ComponentBaselineSetUtil.fetch(source, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            target = ComponentBaselineSetUtil.fetch(target, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            Container containerSource = Container.get(source, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            Container containerTarget = Container.get(target, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            List<ComponentSyncInfo> infos = ComponentBaselineSetUtil.getInfos(containerSource, containerTarget, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            List components = input.getComponents();
            if (components != null) {
                ComponentBaselineSetUtil.filterInfos(infos, components);
            }
            MultiComponentSyncContext mcsc = null;
            ITeamRepository iTeamRepository = repo = containerSource.repo != null ? containerSource.repo : containerTarget.repo;
            if (containerSource.source instanceof IWorkspaceConnection) {
                local = (IWorkspaceConnection)containerSource.source;
                remote = containerTarget.source instanceof IConnection ? (IConnection)containerTarget.source : local;
                mcsc = new WorkspaceSyncContext(model, repo, local, (IConnection)remote, input);
            } else if (containerSource.source instanceof IBaselineSet) {
                local = (IBaselineSet)containerSource.source;
                remote = containerTarget.source instanceof IBaselineSet ? (IBaselineSet)containerTarget.source : local;
                mcsc = new BaselineSetSyncContext(model, repo, (IBaselineSet)local, (IBaselineSet)remote, input);
            } else {
                mcsc = new MultiComponentSyncContext(model, repo, input);
            }
            boolean useCustomQuery = input.useCustomQuery();
            if (useCustomQuery) {
                mcsc.refreshCustomChanges((IProgressMonitor)new SubProgressMonitor(monitor, 15));
            } else {
                monitor.worked(15);
            }
            for (ComponentSyncInfo info : infos) {
                boolean include = true;
                if (useCustomQuery) {
                    boolean bl = include = mcsc.getCustomChanges((IComponentHandle)info.getComponent(), true).size() > 0 || mcsc.getCustomChanges((IComponentHandle)info.getComponent(), false).size() > 0;
                }
                if (include) {
                    ComponentSyncModelUpdateOperation.create((ComponentSyncModel)model, info, mcsc, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    continue;
                }
                monitor.worked(5);
            }
        }
        finally {
            monitor.done();
        }
    }

    static Object fetch(Object elt, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask("", 1);
            if (elt == null) {
                return null;
            }
            if (elt instanceof IConnection) {
                Object object = elt;
                return object;
            }
            if (!(elt instanceof IItemHandle)) {
                throw new IllegalArgumentException("Wrong type for " + elt);
            }
            IItemHandle handle = (IItemHandle)elt;
            ITeamRepository repo = (ITeamRepository)handle.getOrigin();
            if (repo == null) {
                throw new IllegalArgumentException("Origin not set on " + handle);
            }
            if (handle instanceof IBaselineSetHandle) {
                IItem iItem = repo.itemManager().fetchCompleteItem(handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return iItem;
            }
            if (handle instanceof IWorkspaceHandle) {
                IWorkspaceConnection iWorkspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return iWorkspaceConnection;
            }
            if (handle instanceof IBaselineHandle) {
                IBaselineConnection iBaselineConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection((IBaselineHandle)handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return iBaselineConnection;
            }
            throw new IllegalStateException("Unsupported type " + elt);
        }
        finally {
            monitor.done();
        }
    }

    static List<ComponentSyncInfo> getInfos(Container source, Container target, IProgressMonitor monitor) throws TeamRepositoryException {
        IConnection connectionTarget;
        IConnection connectionSource;
        IComponent component;
        ArrayList<ComponentSyncInfo> infos = new ArrayList<ComponentSyncInfo>();
        for (UUID key : source.components.keySet()) {
            component = source.components.get(key);
            connectionSource = source.connections.get(key);
            connectionTarget = target.connections.get(key);
            if (connectionTarget == null && connectionSource instanceof IWorkspaceConnection && target.other instanceof IWorkspaceConnection) {
                connectionTarget = target.other;
            }
            if (connectionTarget == null) continue;
            infos.add(new ComponentSyncInfo(component, connectionSource, connectionTarget));
        }
        for (UUID key : target.components.keySet()) {
            component = target.components.get(key);
            if (source.components.get(key) != null) continue;
            connectionSource = source.other;
            connectionTarget = target.connections.get(key);
            if (!(connectionSource instanceof IWorkspaceConnection) || !(connectionTarget instanceof IWorkspaceConnection)) continue;
            infos.add(new ComponentSyncInfo(component, connectionSource, connectionTarget));
        }
        return infos;
    }

    static void filterInfos(List<ComponentSyncInfo> infos, List<IComponentHandle> components) {
        ComponentSyncInfo[] componentSyncInfoArray = infos.toArray(new ComponentSyncInfo[infos.size()]);
        int n = componentSyncInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentSyncInfo info = componentSyncInfoArray[n2];
            if (ModelUtil.find(components, (IItemHandle)info.getComponent(), false) == null) {
                infos.remove(info);
            }
            ++n2;
        }
    }

    public static HashMap<UUID, List<IChangeSetHandle>[]> customChangeSetsPerComponent(CompareInput input, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IChangeSetHandle>[] value;
        if (!input.useCustomQuery()) {
            throw new IllegalArgumentException("Must be custom query");
        }
        input.runCustomQuery(null);
        List itemHandles = input.getOutgoing();
        List outgoing = itemHandles != null ? repo.itemManager().fetchCompleteItems(input.getOutgoing(), 0, null) : Collections.EMPTY_LIST;
        itemHandles = input.getIncoming();
        List incoming = itemHandles != null ? repo.itemManager().fetchCompleteItems(itemHandles, 0, null) : Collections.EMPTY_LIST;
        HashMap<UUID, List<IChangeSetHandle>[]> result = new HashMap<UUID, List<IChangeSetHandle>[]>();
        for (IChangeSet changeSet : outgoing) {
            value = result.get(changeSet.getComponent().getItemId());
            if (value == null) {
                value = new ArrayList[]{new ArrayList<IChangeSetHandle>(), new ArrayList<IChangeSetHandle>()};
                result.put(changeSet.getComponent().getItemId(), value);
            }
            value[0].add((IChangeSetHandle)changeSet);
        }
        for (IChangeSet changeSet : incoming) {
            value = result.get(changeSet.getComponent().getItemId());
            if (value == null) {
                value = new ArrayList[]{new ArrayList<IChangeSetHandle>(), new ArrayList<IChangeSetHandle>()};
                result.put(changeSet.getComponent().getItemId(), value);
            }
            value[1].add((IChangeSetHandle)changeSet);
        }
        return result;
    }

    static class Container {
        Object source;
        ITeamRepository repo;
        Map<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        Map<UUID, IConnection> connections = new HashMap<UUID, IConnection>();
        IConnection other;

        Container() {
        }

        static Container init(IBaselineConnection bc, IProgressMonitor monitor) throws TeamRepositoryException {
            Container c = new Container();
            c.source = bc;
            c.repo = bc.teamRepository();
            c.components.put(bc.getComponent().getItemId(), (IComponent)bc.teamRepository().itemManager().fetchCompleteItem((IItemHandle)bc.getComponent(), 0, monitor));
            c.connections.put(bc.getComponent().getItemId(), (IConnection)bc);
            c.other = null;
            return c;
        }

        static Container init(IWorkspaceConnection wc, IProgressMonitor monitor) throws TeamRepositoryException {
            Container c = new Container();
            c.source = wc;
            c.repo = wc.teamRepository();
            for (IComponent component : wc.teamRepository().itemManager().fetchCompleteItems(wc.getComponents(), 0, monitor)) {
                c.components.put(component.getItemId(), component);
                c.connections.put(component.getItemId(), (IConnection)wc);
            }
            c.other = wc;
            return c;
        }

        static Container init(IBaselineSet bs, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                ITeamRepository repo;
                int size = bs.getBaselines().size();
                monitor.beginTask(Messages.ComponentBaselineSetUtil_ProgressMessage, 3 * size);
                Container c = new Container();
                c.source = bs;
                c.repo = repo = (ITeamRepository)bs.getOrigin();
                List baselines = repo.itemManager().fetchCompleteItems(bs.getBaselines(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, size));
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
                for (IBaseline baseline : baselines) {
                    components.add(baseline.getComponent());
                }
                int index = 0;
                for (IComponent component : repo.itemManager().fetchCompleteItems(components, 0, (IProgressMonitor)new SubProgressMonitor(monitor, size))) {
                    c.components.put(component.getItemId(), component);
                    c.connections.put(component.getItemId(), (IConnection)wm.getBaselineConnection((IBaseline)baselines.get(index), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                    ++index;
                }
                c.other = null;
                Container container = c;
                return container;
            }
            finally {
                monitor.done();
            }
        }

        static Container get(Object object, IProgressMonitor monitor) throws TeamRepositoryException {
            if (object instanceof IBaselineSet) {
                return Container.init((IBaselineSet)object, monitor);
            }
            if (object instanceof IBaselineConnection) {
                return Container.init((IBaselineConnection)object, monitor);
            }
            if (object instanceof IWorkspaceConnection) {
                return Container.init((IWorkspaceConnection)object, monitor);
            }
            throw new IllegalArgumentException("Unsupported type " + object);
        }
    }
}

