/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCache {
    Collection<IWorkspaceConnection> refreshed = new ArrayList<IWorkspaceConnection>();
    HashMap<UUID, IChangeSetLinkSummary> changeSetLinkSummaries = new HashMap();

    public void refresh(Collection<IWorkspaceConnection> connections, IProgressMonitor monitor) {
        HashMap map = new HashMap();
        for (IWorkspaceConnection wc : connections) {
            if (this.refreshed.contains(wc)) continue;
            ITeamRepository repo = wc.teamRepository();
            if (!map.containsKey(repo)) {
                map.put(repo, new HashSet());
            }
            ((Set)map.get(repo)).add(wc);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)map.keySet().size());
        for (Map.Entry entry : map.entrySet()) {
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)entry.getKey()));
            try {
                Set wcs = (Set)entry.getValue();
                if (wcs.isEmpty()) {
                    progress.worked(1);
                    continue;
                }
                wm.refreshWorkspaceConnections((Collection)wcs, (IProgressMonitor)progress.newChild(1));
                this.refreshed.addAll(wcs);
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
    }

    public void refresh(IWorkspaceConnection connection, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.refreshed.contains(connection)) {
            return;
        }
        connection.refresh(monitor);
        this.refreshed.add(connection);
    }

    public List<IChangeSetLinkSummary> getChangeSetLinkSummary(Collection<? extends IChangeSetHandle> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IChangeSetLinkSummary> result = new ArrayList<IChangeSetLinkSummary>();
        HashMap map = new HashMap();
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            if (!(iChangeSetHandle.getOrigin() instanceof ITeamRepository)) continue;
            ITeamRepository repo = (ITeamRepository)iChangeSetHandle.getOrigin();
            if (!map.containsKey(repo)) {
                map.put(repo, new ArrayList());
            }
            ((List)map.get(repo)).add(iChangeSetHandle);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)map.keySet().size());
        for (Map.Entry entry : map.entrySet()) {
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)entry.getKey()));
            try {
                result.addAll(this.getChangeSetLinkSummary(wm, (Collection)entry.getValue(), (IProgressMonitor)subMonitor.newChild(1)));
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        return result;
    }

    public List<IChangeSetLinkSummary> getChangeSetLinkSummary(IWorkspaceManager wm, Collection<? extends IChangeSetHandle> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IChangeSetLinkSummary> result = new ArrayList<IChangeSetLinkSummary>();
        ArrayList<IChangeSetHandle> missing = new ArrayList<IChangeSetHandle>();
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            IChangeSetLinkSummary cached = this.changeSetLinkSummaries.get(iChangeSetHandle.getItemId());
            if (cached != null) {
                result.add(cached);
                continue;
            }
            if (this.changeSetLinkSummaries.containsKey(iChangeSetHandle.getItemId())) continue;
            missing.add(iChangeSetHandle);
        }
        if (!missing.isEmpty()) {
            List list = wm.getChangeSetLinkSummary(missing, monitor);
            for (IChangeSetHandle changeSet : missing) {
                this.changeSetLinkSummaries.put(changeSet.getItemId(), null);
            }
            for (IChangeSetLinkSummary summary : list) {
                this.changeSetLinkSummaries.put(summary.getChangeSet().getItemId(), summary);
            }
            result.addAll(list);
        }
        return result;
    }
}

