/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.IComponentSyncManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.QueryCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentCollaborationUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSyncManager
extends EventSource
implements IComponentSyncManager {
    private Set loadingWorkspaces = Collections.synchronizedSet(new HashSet());
    private Map<UUID, IWorkspaceConnection> loadedWorkspaces = Collections.synchronizedMap(new HashMap());
    private Set<ComponentSyncInfo> componentSyncs = Collections.synchronizedSet(new HashSet());
    private Object updateLock = new Object();

    public void dispose() {
    }

    public void clear() {
        this.loadedWorkspaces.clear();
        this.componentSyncs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkspaceConnection[] getLoadingWorkspaces() {
        Set set = this.loadingWorkspaces;
        synchronized (set) {
            return this.loadingWorkspaces.toArray(new IWorkspaceConnection[this.loadingWorkspaces.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IWorkspaceConnection> getLoadedWorkspaces() {
        Map<UUID, IWorkspaceConnection> map = this.loadedWorkspaces;
        synchronized (map) {
            return new ArrayList<IWorkspaceConnection>(this.loadedWorkspaces.values());
        }
    }

    @Override
    public void loading(IWorkspaceConnection wc) {
        try {
            this.acquire();
            if (this.loadingWorkspaces.add(wc)) {
                this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyAdd", (Object)this, (Object)"loadingWorkspaces", null, (Object)wc));
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void loadingDone(IWorkspaceConnection wc) {
        try {
            this.acquire();
            if (this.loadingWorkspaces.remove(wc)) {
                this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyRemove", (Object)this, (Object)"loadingWorkspaces", (Object)wc, null));
            }
        }
        finally {
            this.release();
        }
    }

    void load(IWorkspaceConnection wc, IConnection collaboration) {
        try {
            this.acquire();
            this.loadedWorkspaces.put(wc.getResolvedWorkspace().getItemId(), wc);
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyAdd", (Object)this, (Object)"loadedWorkspaces", (Object)collaboration, (Object)wc));
        }
        finally {
            this.release();
        }
    }

    void unload(IWorkspaceConnection wc) {
        try {
            this.acquire();
            this.loadedWorkspaces.remove(wc.getResolvedWorkspace().getItemId());
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyRemove", (Object)this, (Object)"loadedWorkspaces", (Object)wc, null));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isLoading(IWorkspaceHandle workspace) {
        Set set = this.loadingWorkspaces;
        synchronized (set) {
            IWorkspaceConnection wc;
            Iterator i = this.loadingWorkspaces.iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while (!(wc = (IWorkspaceConnection)i.next()).getResolvedWorkspace().sameItemId((IItemHandle)workspace));
            return true;
        }
    }

    public boolean isLoaded(IWorkspaceHandle workspace) {
        return this.loadedWorkspaces.containsKey(workspace.getItemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void update(IProgressMonitor monitor) throws TeamRepositoryException {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("ComponentSyncManager.update");
        }
        Object object = this.updateLock;
        synchronized (object) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            this.updateWorkspaceConnections((IProgressMonitor)progress.newChild(1));
            ComponentSyncInfo[] oldSyncs = this.getComponentSyncs();
            HashSet<IWorkspaceConnection> allConnections = new HashSet<IWorkspaceConnection>();
            ComponentSyncInfo[] componentSyncInfoArray = oldSyncs;
            int n = oldSyncs.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentSyncInfo info = componentSyncInfoArray[n2];
                if (info.local instanceof IWorkspaceConnection) {
                    allConnections.add((IWorkspaceConnection)info.local);
                }
                if (info.remote instanceof IWorkspaceConnection) {
                    allConnections.add((IWorkspaceConnection)info.remote);
                }
                ++n2;
            }
            Collection<IWorkspaceConnection> loaded = this.getLoadedWorkspaces();
            try {
                void var13_18;
                progress.setWorkRemaining(loaded.size() * 10);
                HashMap<IWorkspaceConnection, IConnection[]> collaborations = new HashMap<IWorkspaceConnection, IConnection[]>();
                ArrayList<ComponentSyncInfo> newSyncs = new ArrayList<ComponentSyncInfo>();
                boolean allFlows = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("show_all_flow_targets");
                for (IWorkspaceConnection local : loaded) {
                    IConnection[] iConnectionArray;
                    if (allFlows) {
                        iConnectionArray = ComponentCollaborationUtil.getAllWorkspaceCollaborationConnections(local, (IProgressMonitor)progress.newChild(1));
                    } else {
                        IConnection[] iConnectionArray2 = new IConnection[1];
                        iConnectionArray = iConnectionArray2;
                        iConnectionArray2[0] = ComponentCollaborationUtil.getWorkspaceCollaborationConnection(local, (IProgressMonitor)progress.newChild(1));
                    }
                    IConnection[] flows = iConnectionArray;
                    collaborations.put(local, flows);
                    allConnections.add(local);
                    Object object2 = flows;
                    int n3 = ((Object)object2).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object flow = object2[n4];
                        if (flow instanceof IWorkspaceConnection) {
                            allConnections.add((IWorkspaceConnection)flow);
                        }
                        ++n4;
                    }
                }
                QueryCache cache = new QueryCache();
                cache.refresh(allConnections, (IProgressMonitor)progress.newChild(1));
                progress.setWorkRemaining(collaborations.entrySet().size());
                for (Map.Entry entry : collaborations.entrySet()) {
                    newSyncs.addAll(this.create((IWorkspaceConnection)entry.getKey(), (IConnection[])entry.getValue(), allFlows, cache, (IProgressMonitor)progress.newChild(1)));
                }
                boolean bl = false;
                while (var13_18 < oldSyncs.length) {
                    boolean removed = true;
                    for (ComponentSyncInfo info : newSyncs) {
                        if (!oldSyncs[var13_18].equals(info)) continue;
                        removed = false;
                        break;
                    }
                    if (removed) {
                        this.remove(oldSyncs[var13_18]);
                    }
                    ++var13_18;
                }
                for (ComponentSyncInfo componentSyncInfo : newSyncs) {
                    boolean added = true;
                    int i2 = 0;
                    while (i2 < oldSyncs.length) {
                        if (componentSyncInfo.equals(oldSyncs[i2])) {
                            added = false;
                            break;
                        }
                        ++i2;
                    }
                    if (!added) continue;
                    this.add(componentSyncInfo);
                }
            }
            finally {
                monitor.done();
            }
        }
        if (ModelUtil.TRACE_REFRESH) {
            ModelUtil.logEnd("ComponentSyncManager.update", traceBegin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Map<ComponentSyncInfo, ComponentSyncInfo> oldInfo2NewInfo) {
        Set<ComponentSyncInfo> set = this.componentSyncs;
        synchronized (set) {
            for (Map.Entry<ComponentSyncInfo, ComponentSyncInfo> entry : oldInfo2NewInfo.entrySet()) {
                if (!this.componentSyncs.remove(entry.getKey())) continue;
                this.componentSyncs.add(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentSyncInfo[] getComponentSyncs() {
        Set<ComponentSyncInfo> set = this.componentSyncs;
        synchronized (set) {
            return this.componentSyncs.toArray(new ComponentSyncInfo[this.componentSyncs.size()]);
        }
    }

    void add(ComponentSyncInfo info) {
        try {
            this.acquire();
            if (this.componentSyncs.add(info)) {
                this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyAdd", (Object)this, (Object)"componentSyncs", null, (Object)info));
            }
        }
        finally {
            this.release();
        }
    }

    void remove(ComponentSyncInfo info) {
        try {
            this.acquire();
            if (this.componentSyncs.remove(info)) {
                this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyRemove", (Object)this, (Object)"componentSyncs", (Object)info, null));
            }
        }
        finally {
            this.release();
        }
    }

    List<ComponentSyncInfo> create(IWorkspaceConnection local, IConnection[] collaborations, boolean allFlows, QueryCache cache, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (local instanceof IWorkspaceConnection) {
            try {
                cache.refresh(local, (IProgressMonitor)progress.newChild(1));
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (ConnectionException connectionException) {}
        }
        ArrayList<ComponentSyncInfo> result = new ArrayList<ComponentSyncInfo>();
        IConnection[] iConnectionArray = collaborations;
        int n = collaborations.length;
        int n2 = 0;
        while (n2 < n) {
            Collection scopes;
            IConnection collaboration = iConnectionArray[n2];
            if (local != collaboration && collaboration instanceof IWorkspaceConnection) {
                try {
                    cache.refresh((IWorkspaceConnection)collaboration, (IProgressMonitor)progress.newChild(1));
                }
                catch (NotLoggedInException notLoggedInException) {
                }
                catch (ConnectionException connectionException) {}
            }
            List<IComponentHandle> localComponents = ModelUtil.getComponents((IConnection)local);
            List<IComponentHandle> remoteComponents = ModelUtil.getComponents(collaboration);
            Collection componentScopes = null;
            if (collaboration instanceof IWorkspaceConnection && !(scopes = local.getFlowTable().getComponentScopes((IFlowNodeHandle)((IWorkspaceConnection)collaboration).getResolvedWorkspace())).isEmpty()) {
                componentScopes = scopes;
            }
            List<IComponentHandle> allComponents = new ArrayList<IComponentHandle>();
            for (IComponentHandle iComponentHandle : localComponents) {
                if (componentScopes != null && !ComponentSyncManager.sameItemId(componentScopes, (IItemHandle)iComponentHandle)) continue;
                allComponents.add(iComponentHandle);
            }
            for (IComponentHandle iComponentHandle : remoteComponents) {
                if (componentScopes != null && !ComponentSyncManager.sameItemId(componentScopes, (IItemHandle)iComponentHandle) || ComponentSyncManager.sameItemId(allComponents, (IItemHandle)iComponentHandle)) continue;
                allComponents.add(iComponentHandle);
            }
            allComponents = local.teamRepository().itemManager().fetchCompleteItems(allComponents, 0, (IProgressMonitor)progress.newChild(1));
            progress.setWorkRemaining(2 * allComponents.size());
            for (IComponent iComponent : allComponents) {
                IConnection remote;
                IConnection iConnection = remote = allFlows ? collaboration : ComponentCollaborationUtil.getComponentCollaborationConnection(local, (IComponentHandle)iComponent, collaboration, (IProgressMonitor)progress.newChild(1));
                if (remote instanceof IWorkspaceConnection) {
                    try {
                        cache.refresh((IWorkspaceConnection)remote, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (NotLoggedInException notLoggedInException) {
                    }
                    catch (ConnectionException connectionException) {}
                } else {
                    progress.worked(1);
                }
                result.add(new ComponentSyncInfo(iComponent, (IConnection)local, remote));
            }
            ++n2;
        }
        return result;
    }

    static boolean sameItemId(Collection handles, IItemHandle handle) {
        for (IItemHandle current : handles) {
            if (!handle.sameItemId(current)) continue;
            return true;
        }
        return false;
    }

    void updateWorkspaceConnections(IProgressMonitor monitor) {
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        IWorkspaceHandle[] activeWorkspaces = manager.getActiveWorkspaces();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(activeWorkspaces.length * 2));
        for (IWorkspaceConnection wc : this.getLoadedWorkspaces()) {
            if (manager.isActive((IWorkspaceHandle)wc.getResolvedWorkspace())) continue;
            this.unload(wc);
        }
        IWorkspaceHandle[] iWorkspaceHandleArray = activeWorkspaces;
        int n = activeWorkspaces.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo;
            IWorkspaceHandle workspace = iWorkspaceHandleArray[n2];
            if (this.loadedWorkspaces.get(workspace.getItemId()) == null && (repo = (ITeamRepository)workspace.getOrigin()).loggedIn()) {
                try {
                    IWorkspaceConnection wc = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspace, (IProgressMonitor)progress.newChild(1));
                    IConnection collaboration = ComponentCollaborationUtil.getWorkspaceCollaborationConnection(wc, (IProgressMonitor)progress.newChild(1));
                    this.load(wc, collaboration);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    manager.deactivate(workspace);
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                }
            }
            ++n2;
        }
    }
}

