/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes;

import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentCollaborationEvent;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveWorkspaceManager
extends EventSource
implements IActiveWorkspaceManager,
ITeamRepositoryService.IRepositoryServiceListener {
    Map<UUID, IWorkspaceHandle> activeWorkspaces = Collections.synchronizedMap(new HashMap());
    CollaborationWorkspaceManager cwm = new CollaborationWorkspaceManager();
    static final String PREF_LOADEDWORKSPACES = "loadedWorkspaces";
    static ActiveWorkspaceManager INSTANCE;
    volatile boolean disposed;

    public static synchronized ActiveWorkspaceManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActiveWorkspaceManager();
            TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)INSTANCE);
            INSTANCE.update();
        }
        return INSTANCE;
    }

    public static synchronized void restart() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    private void update() {
        if (this.disposed) {
            return;
        }
        try {
            this.read();
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    public void addedRepository(ITeamRepository repository) {
        this.update();
    }

    public void removedRepository(ITeamRepository repository) {
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
    }

    public void clear() {
        try {
            Preferences loadWorkspacePrefs = this.getPrefsNode();
            loadWorkspacePrefs.removeNode();
            this.activeWorkspaces.clear();
        }
        catch (BackingStoreException e) {
            StatusUtil.log((Object)this, (String)"Unable to clear loaded workspace list", (Throwable)e);
        }
    }

    void saveActiveWorkspaces() {
        Preferences loadWorkspacePrefs = this.getPrefsNode();
        if (loadWorkspacePrefs == null) {
            return;
        }
        try {
            loadWorkspacePrefs.removeNode();
            loadWorkspacePrefs = this.getPrefsNode();
            int i = 0;
            IWorkspaceHandle[] iWorkspaceHandleArray = this.getActiveWorkspaces();
            int n = iWorkspaceHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkspaceHandle workspace = iWorkspaceHandleArray[n2];
                Preferences prefs = loadWorkspacePrefs.node("" + i);
                prefs.put(IWorkspace.ITEM_ID_PROPERTY, workspace.getItemId().getUuidValue());
                ITeamRepository repo = (ITeamRepository)workspace.getOrigin();
                prefs.put("uri", repo.getRepositoryURI());
                if (repo.getId() != null) {
                    prefs.put("id", repo.getId().getUuidValue());
                }
                ++i;
                ++n2;
            }
            loadWorkspacePrefs.flush();
        }
        catch (BackingStoreException e) {
            StatusUtil.log((Object)this, (String)"Unable to save active workspaces list", (Throwable)e);
        }
    }

    private Preferences getPrefsNode() {
        Preferences loadWorkspacePrefs = new InstanceScope().getNode("com.ibm.team.filesystem.rcp.core").node(PREF_LOADEDWORKSPACES);
        return loadWorkspacePrefs;
    }

    private void read() throws TeamRepositoryException {
        Preferences serverPrefs = this.getPrefsNode();
        if (serverPrefs == null) {
            return;
        }
        try {
            try {
                this.acquire();
                String[] allLoadedPrefs = serverPrefs.childrenNames();
                int i = 0;
                while (i < allLoadedPrefs.length) {
                    block10: {
                        Preferences prefs = null;
                        try {
                            prefs = serverPrefs.node(allLoadedPrefs[i]);
                        }
                        catch (IllegalStateException illegalStateException) {
                            break block10;
                        }
                        String uuidValue = prefs.get("id", "");
                        ITeamRepository repo = uuidValue.length() == 0 ? RepositoryUtils.getTeamRepository((String)prefs.get("uri", ""), (int)4) : RepositoryUtils.getTeamRepository((String)prefs.get("uri", ""), (int)4, (UUID)UUID.valueOf((String)uuidValue));
                        if (repo != null) {
                            String itemid = prefs.get(IWorkspace.ITEM_ID_PROPERTY, null);
                            IWorkspaceHandle workspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemid), null);
                            this.activeWorkspaces.put(workspace.getItemId(), workspace);
                            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyAdd", (Object)this, (Object)"activeWorkspaces", null, (Object)workspace));
                        }
                    }
                    ++i;
                }
            }
            catch (BackingStoreException e) {
                StatusUtil.log((Object)this, (String)"Unable to read persisted active workspaces list", (Throwable)e);
                this.release();
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkspaceHandle[] getActiveWorkspaces() {
        Map<UUID, IWorkspaceHandle> map = this.activeWorkspaces;
        synchronized (map) {
            return this.activeWorkspaces.values().toArray(new IWorkspaceHandle[this.activeWorkspaces.values().size()]);
        }
    }

    @Override
    public void activate(IWorkspaceHandle workspace) {
        if (workspace.getOrigin() == null) {
            throw new IllegalArgumentException("Origin not set");
        }
        try {
            this.acquire();
            this.activeWorkspaces.put(workspace.getItemId(), workspace);
            this.saveActiveWorkspaces();
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyAdd", (Object)this, (Object)"activeWorkspaces", null, (Object)workspace));
        }
        finally {
            this.release();
        }
    }

    @Override
    public void deactivate(IWorkspaceHandle workspace) {
        try {
            this.acquire();
            this.activeWorkspaces.remove(workspace.getItemId());
            this.saveActiveWorkspaces();
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyRemove", (Object)this, (Object)"activeWorkspaces", (Object)workspace, null));
        }
        finally {
            this.release();
        }
    }

    @Override
    public boolean isActive(IWorkspaceHandle workspace) {
        return this.activeWorkspaces.get(workspace.getItemId()) != null;
    }

    @Override
    public IContextHandle getWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.cwm.getWorkspaceCollaboration(activeWorkspace, monitor);
    }

    @Override
    public IContextHandle getComponentCollaboration(IWorkspaceHandle activeWorkspace, IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.cwm.getComponentCollaboration(activeWorkspace, component, monitor);
    }

    @Override
    public void setWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IWorkspaceHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cwm.setWorkspaceCollaboration(activeWorkspace, collaboration, persist, monitor);
    }

    @Override
    public void setWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IBaselineHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cwm.setWorkspaceCollaboration(activeWorkspace, collaboration, persist, monitor);
    }

    @Override
    public void setComponentCollaboration(IWorkspaceHandle activeWorkspace, Collection<? extends IComponentHandle> components, IWorkspaceHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cwm.setComponentCollaboration(activeWorkspace, components, collaboration, persist, monitor);
    }

    @Override
    public void setComponentCollaboration(IWorkspaceHandle activeWorkspace, Collection<? extends IComponentHandle> components, IBaselineHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cwm.setComponentCollaboration(activeWorkspace, components, collaboration, persist, monitor);
    }

    public static IConnection getConnection(IContextHandle connectionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (connectionHandle instanceof IWorkspaceHandle) {
            return SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)connectionHandle.getOrigin())).getWorkspaceConnection((IWorkspaceHandle)connectionHandle, monitor);
        }
        if (connectionHandle instanceof IBaselineHandle) {
            return SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)connectionHandle.getOrigin())).getBaselineConnection((IBaselineHandle)connectionHandle, monitor);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CollaborationWorkspaceManager {
        Hashtable<UUID, WorkspaceCollaboration> workspaceCollaborations = new Hashtable();

        CollaborationWorkspaceManager() {
        }

        public IContextHandle getWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress);
            return c.collaboration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WorkspaceCollaboration internalGetCollaboration(IWorkspaceHandle activeWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
            Hashtable<UUID, WorkspaceCollaboration> hashtable = this.workspaceCollaborations;
            synchronized (hashtable) {
                WorkspaceCollaboration c = this.workspaceCollaborations.get(activeWorkspace.getItemId());
                if (c == null) {
                    c = this.load(activeWorkspace, monitor);
                    this.workspaceCollaborations.put(activeWorkspace.getItemId(), c);
                }
                return c;
            }
        }

        private WorkspaceCollaboration load(IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkspaceConnection connection = this.getWorkspaceConnection(workspace, monitor);
            IWorkspaceHandle workspaceCollaboration = ComponentFlowUtil.getCurrentCollaboration(connection);
            if (workspaceCollaboration == null) {
                workspaceCollaboration = FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)connection);
            }
            WorkspaceCollaboration result = new WorkspaceCollaboration(workspace, (IContextHandle)workspaceCollaboration);
            for (IComponentHandle component : connection.getComponents()) {
                IWorkspaceHandle componentCollaboration = ComponentFlowUtil.getCurrentCollaboration(connection, component);
                if (componentCollaboration == null) continue;
                result.setComponentCollaboration(component, (IContextHandle)componentCollaboration);
            }
            return result;
        }

        private IWorkspaceConnection getWorkspaceConnection(IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
            return (IWorkspaceConnection)ActiveWorkspaceManager.getConnection((IContextHandle)workspace, monitor);
        }

        public IContextHandle getComponentCollaboration(IWorkspaceHandle activeWorkspace, IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
            return c.getCollaboration(component);
        }

        public void setWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IWorkspaceHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            if (persist) {
                IWorkspaceConnection local = this.getWorkspaceConnection(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                IWorkspaceConnection remote = this.getWorkspaceConnection(collaboration, (IProgressMonitor)progress.newChild(1));
                IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
                boolean modified = false;
                if (!ComponentFlowUtil.hasCollaboration(local, remote)) {
                    ComponentFlowUtil.addCollaboration(flowTable, local, remote);
                    modified = true;
                }
                if (!collaboration.sameItemId((IItemHandle)ComponentFlowUtil.getCurrentCollaboration(local))) {
                    ComponentFlowUtil.setCurrentCollaboration(flowTable, collaboration);
                    for (IComponentHandle component : local.getComponents()) {
                        ComponentFlowUtil.setCurrentCollaboration(flowTable, component, null);
                    }
                    modified = true;
                }
                if (modified) {
                    local.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(1));
                }
            }
            try {
                ActiveWorkspaceManager.this.acquire();
                WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                IContextHandle old = c.resetCollaboration((IContextHandle)collaboration);
                ActiveWorkspaceManager.this.queueEvent(new PropertyChangeEvent((IEventSource)ActiveWorkspaceManager.this, "com.ibm.team.repository.PropertySet", (Object)activeWorkspace, (Object)"workspaceCollaboration", (Object)old, (Object)collaboration));
            }
            finally {
                ActiveWorkspaceManager.this.release();
                progress.done();
            }
        }

        public void setWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IBaselineHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            try {
                ActiveWorkspaceManager.this.acquire();
                WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                IContextHandle old = c.resetCollaboration((IContextHandle)collaboration);
                ActiveWorkspaceManager.this.queueEvent(new PropertyChangeEvent((IEventSource)ActiveWorkspaceManager.this, "com.ibm.team.repository.PropertySet", (Object)activeWorkspace, (Object)"workspaceCollaboration", (Object)old, (Object)collaboration));
            }
            finally {
                ActiveWorkspaceManager.this.release();
                progress.done();
            }
        }

        public void setComponentCollaboration(IWorkspaceHandle activeWorkspace, Collection<? extends IComponentHandle> components, IWorkspaceHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            if (persist) {
                IWorkspaceConnection local = this.getWorkspaceConnection(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                IWorkspaceConnection iWorkspaceConnection = this.getWorkspaceConnection(collaboration, (IProgressMonitor)progress.newChild(1));
                IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
                boolean modified = false;
                if (!ComponentFlowUtil.hasCollaboration(local, iWorkspaceConnection)) {
                    ComponentFlowUtil.addCollaboration(flowTable, local, iWorkspaceConnection);
                    modified = true;
                }
                for (IComponentHandle iComponentHandle : components) {
                    if (collaboration.sameItemId((IItemHandle)ComponentFlowUtil.getCurrentCollaboration(local, iComponentHandle))) continue;
                    ComponentFlowUtil.setCurrentCollaboration(flowTable, iComponentHandle, collaboration);
                    modified = true;
                }
                if (modified) {
                    local.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(1));
                }
            }
            try {
                ActiveWorkspaceManager.this.acquire();
                WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                for (IComponentHandle iComponentHandle : components) {
                    c.setComponentCollaboration(iComponentHandle, (IContextHandle)collaboration);
                    ActiveWorkspaceManager.this.queueEvent(new ComponentCollaborationEvent(ActiveWorkspaceManager.this, activeWorkspace, iComponentHandle, (IContextHandle)collaboration));
                }
            }
            finally {
                ActiveWorkspaceManager.this.release();
                progress.done();
            }
        }

        public void setComponentCollaboration(IWorkspaceHandle activeWorkspace, Collection<? extends IComponentHandle> components, IBaselineHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            try {
                ActiveWorkspaceManager.this.acquire();
                WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                for (IComponentHandle iComponentHandle : components) {
                    c.setComponentCollaboration(iComponentHandle, (IContextHandle)collaboration);
                    ActiveWorkspaceManager.this.queueEvent(new ComponentCollaborationEvent(ActiveWorkspaceManager.this, activeWorkspace, iComponentHandle, (IContextHandle)collaboration));
                }
            }
            finally {
                ActiveWorkspaceManager.this.release();
                progress.done();
            }
        }

        class WorkspaceCollaboration {
            IWorkspaceHandle workspace;
            IContextHandle collaboration;
            Hashtable<UUID, IContextHandle> componentCollaborations = new Hashtable();

            public WorkspaceCollaboration(IWorkspaceHandle workspace, IContextHandle collaboration) {
                this.workspace = workspace;
                this.collaboration = collaboration;
            }

            public IContextHandle setComponentCollaboration(IComponentHandle component, IContextHandle collaboration) {
                return this.componentCollaborations.put(component.getItemId(), collaboration);
            }

            public IContextHandle resetCollaboration(IContextHandle newCollaboration) {
                IContextHandle old = this.collaboration;
                this.componentCollaborations.clear();
                this.collaboration = newCollaboration;
                return old;
            }

            public IContextHandle getCollaboration(IComponentHandle component) {
                IContextHandle collaboration = this.componentCollaborations.get(component.getItemId());
                return collaboration != null ? collaboration : this.collaboration;
            }
        }
    }
}

