/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal;

import com.ibm.team.filesystem.rcp.core.internal.ItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredFetcher {
    private ChangeListenerList<FilteredFetcher, ItemChangeEvent> listeners = new ChangeListenerList();
    private ITeamRepository repo;
    private Set<ItemId<IItem>> pendingRequests = new HashSet<ItemId<IItem>>();
    private WeakHashMap<IItem, StateId<IItem>> lastKnownState = new WeakHashMap();
    private WeakHashMap<IChangeListener<FilteredFetcher, List<ItemChangeEvent>>, ISharedItemChangeListener> listenerMap = new WeakHashMap();

    public FilteredFetcher(ITeamRepository repo) {
        this.repo = repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IItem> Map<ItemId<T>, T> fetchCurrents(Collection<ItemId<T>> items, boolean refresh, FetchProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        FilteredFetcher filteredFetcher;
        Map map;
        FilteredFetcher filteredFetcher2 = this;
        synchronized (filteredFetcher2) {
            for (ItemId<T> next : items) {
                ItemId upcast = ItemId.upcast(next);
                this.pendingRequests.add((ItemId<IItem>)upcast);
            }
        }
        try {
            Map result = RepoFetcher.fetchCurrents((ITeamRepository)this.repo, items, (boolean)refresh, (FetchProfile)profile, (IProgressMonitor)monitor);
            FilteredFetcher filteredFetcher3 = this;
            synchronized (filteredFetcher3) {
                for (Map.Entry next : result.entrySet()) {
                    StateId upcastState = StateId.upcast((StateId)StateId.forItem((IItem)((IItem)next.getValue())));
                    this.lastKnownState.put((IItem)next.getValue(), (StateId<IItem>)upcastState);
                }
            }
            map = result;
            filteredFetcher = this;
        }
        catch (Throwable throwable) {
            FilteredFetcher filteredFetcher4 = this;
            synchronized (filteredFetcher4) {
                for (ItemId<T> next : items) {
                    ItemId upcast = ItemId.upcast(next);
                    this.pendingRequests.remove(upcast);
                }
            }
        }
        synchronized (filteredFetcher) {
            for (ItemId<T> next : items) {
                ItemId upcast = ItemId.upcast(next);
                this.pendingRequests.remove(upcast);
            }
        }
        return map;
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IItemType itemType, IChangeListener<FilteredFetcher, List<ItemChangeEvent>> toAdd) {
        ISharedItemChangeListener newListener = this.convertListener(toAdd);
        FilteredFetcher filteredFetcher = this;
        synchronized (filteredFetcher) {
            this.listenerMap.put(toAdd, newListener);
        }
        this.repo.itemManager().addItemChangeListener(itemType, newListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IItem item, IChangeListener<FilteredFetcher, List<ItemChangeEvent>> toAdd) {
        ISharedItemChangeListener newListener;
        FilteredFetcher filteredFetcher = this;
        synchronized (filteredFetcher) {
            newListener = this.listenerMap.get(toAdd);
            if (newListener == null) {
                newListener = this.convertListener(toAdd);
                this.listenerMap.put(toAdd, newListener);
            }
        }
        this.repo.itemManager().addItemChangeListener(item, newListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IItemType itemType, IChangeListener<FilteredFetcher, List<ItemChangeEvent>> toAdd) {
        ISharedItemChangeListener newListener;
        FilteredFetcher filteredFetcher = this;
        synchronized (filteredFetcher) {
            newListener = this.listenerMap.get(toAdd);
        }
        if (newListener != null) {
            this.repo.itemManager().removeItemChangeListener(itemType, newListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IItem itemType, IChangeListener<FilteredFetcher, List<ItemChangeEvent>> toAdd) {
        ISharedItemChangeListener newListener;
        FilteredFetcher filteredFetcher = this;
        synchronized (filteredFetcher) {
            newListener = this.listenerMap.get(toAdd);
        }
        if (newListener != null) {
            this.repo.itemManager().removeItemChangeListener(itemType, newListener);
        }
    }

    private ISharedItemChangeListener convertListener(final IChangeListener<FilteredFetcher, List<ItemChangeEvent>> toAdd) {
        ISharedItemChangeListener newListener = new ISharedItemChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemsChanged(List events) {
                ArrayList<ItemChangeEvent> convertedEvents = new ArrayList<ItemChangeEvent>();
                FilteredFetcher filteredFetcher = FilteredFetcher.this;
                synchronized (filteredFetcher) {
                    for (Object nextObj : events) {
                        if (!(nextObj instanceof ISharedItemChangeEvent)) continue;
                        ISharedItemChangeEvent changeEvent = (ISharedItemChangeEvent)nextObj;
                        ItemId itemId = ItemId.forItem((IItem)changeEvent.getSharedItem());
                        if (FilteredFetcher.this.pendingRequests.contains(itemId)) continue;
                        IItem afterState = changeEvent.getAfterState();
                        if (afterState != null) {
                            StateId lastKnownStateId;
                            StateId stateId = StateId.forItem((IItem)afterState);
                            if (NullUtil.equals((Object)stateId, (Object)(lastKnownStateId = (StateId)FilteredFetcher.this.lastKnownState.get(changeEvent.getSharedItem())))) continue;
                            convertedEvents.add(ItemChangeEvent.create(changeEvent));
                            continue;
                        }
                        convertedEvents.add(ItemChangeEvent.create(changeEvent));
                    }
                }
                toAdd.changed((Object)FilteredFetcher.this, convertedEvents);
            }
        };
        return newListener;
    }

    public void removeListener(IChangeListener<FilteredFetcher, ItemChangeEvent> toRemove) {
        this.listeners.remove(toRemove);
    }

    public <T extends IItem> Map<ItemId<T>, T> fetchCurrents(Collection<ItemId<T>> items, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchCurrents(items, refresh, FetchProfile.createFullProfile(), monitor);
    }
}

