/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal;

import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.resources.LinkedResourceIgnoreProvider;
import com.ibm.team.repository.rcp.core.preferences.TempFileStore;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class FileSystemResourcesPlugin
extends Plugin {
    public static final String ID = "com.ibm.team.filesystem.rcp.core";
    public static final String PROVIDER_ID = "com.ibm.team.filesystem.rcp.core.provider";
    public static final String SHOW_ALL_FLOW_TARGETS_PREFERENCE = "show_all_flow_targets";
    public static final boolean SHOW_ALL_FLOW_TARGETS_PREFERENCE_DEFAULT = false;
    public static final String HIDE_EMPTY_BASELINES_PREFERENCE = "hide_empty_baselines";
    public static final boolean HIDE_EMPTY_BASELINES_PREFERENCE_DEFAULT = false;
    public static final String MAX_CHANGES_PER_CHANGE_SET = "max_changes_per_change_set";
    public static final int MAX_CHANGES_PER_CHANGE_SET_DEFAULT = 1000;
    private static FileSystemResourcesPlugin plugin;

    public static TempFileStore createStreamStore() {
        return new TempFileStore(FileSystemResourcesPlugin.getDefault().getBundle(), "patch");
    }

    public FileSystemResourcesPlugin() {
        if (plugin != null) {
            throw new IllegalStateException("FileSystemResourcesPlugin is being instantiated twice.");
        }
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace();
        SharingManager.getInstance().getIgnoreManager().addIgnoreProvider("linkResourceIgnores", (IIgnoreProvider)LinkedResourceIgnoreProvider.getInstance(), null);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static FileSystemResourcesPlugin getDefault() {
        return plugin;
    }

    public static IActiveWorkspaceManager getActiveWorkspaceManager() {
        return ActiveWorkspaceManager.getInstance();
    }

    public static IComponentSyncModel getComponentSyncModel() {
        return ComponentSyncModel.getInstance();
    }

    public static void log(Throwable e) {
        FileSystemResourcesPlugin.getDefault().getLog().log(StatusUtil.newStatus((Object)FileSystemResourcesPlugin.getDefault().getBundle(), (Throwable)e));
    }
}

