/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.workingcopy;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractWorkingCopy
implements IWorkingCopy {
    private boolean dirty;
    private ChangeListenerList listeners = new ChangeListenerList();
    private Display display;
    private boolean hasConflict;
    private boolean valid = true;

    public AbstractWorkingCopy() {
        this.display = Display.getCurrent();
        if (this.display == null) {
            throw new IllegalStateException("This method may only be called from the UI thread");
        }
    }

    public AbstractWorkingCopy(Display theDisplay) {
        this.display = theDisplay;
        Assert.isNotNull((Object)this.display);
    }

    protected final Display getDisplay() {
        return this.display;
    }

    public boolean isValid() {
        return this.valid;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    protected void setValid(boolean isValid) {
        if (this.valid != isValid) {
            this.valid = isValid;
            this.notifyListeners(PROP_VALID);
        }
    }

    public final void addListener(IChangeListener listener) {
        Assert.isTrue((Display.getCurrent() == this.display ? 1 : 0) != 0, (String)"This method may only be called from the UI thread");
        this.listeners.add(listener);
    }

    public final void removeListener(IChangeListener listener) {
        Assert.isTrue((Display.getCurrent() == this.display ? 1 : 0) != 0, (String)"This method may only be called from the UI thread");
        this.listeners.remove(listener);
    }

    protected final void notifyListeners(final Object property) {
        if (Display.getCurrent() == this.display) {
            this.listeners.notifyListeners((Object)this, property);
        } else {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    AbstractWorkingCopy.this.listeners.notifyListeners((Object)AbstractWorkingCopy.this, property);
                }
            });
        }
    }

    public final boolean hasConflict() {
        return this.hasConflict;
    }

    protected final void setConflict(boolean hasConflict) {
        if (this.hasConflict != hasConflict) {
            this.hasConflict = hasConflict;
            this.notifyListeners(PROP_CONFLICT);
        }
    }

    protected final void setDirty(boolean isDirty) {
        if (isDirty != this.dirty) {
            this.dirty = isDirty;
            this.notifyListeners(PROP_DIRTY);
        }
    }
}

