/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.wizards;

import com.ibm.team.repository.rcp.ui.wizards.ChainedWizard;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.PageChain;
import com.ibm.team.repository.rcp.ui.wizards.SimplePageChain;
import com.ibm.team.repository.rcp.ui.wizards.SingleChainWizard;
import com.ibm.team.repository.rcp.ui.wizards.UnionChain;
import com.ibm.team.repository.rcp.ui.wizards.WizardDialogWithCustomButtons;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardUtil {
    public static boolean advance(IWizard wizard) {
        IWizardPage currentPage = wizard.getContainer().getCurrentPage();
        if (currentPage.isPageComplete()) {
            IWizardPage nextPage = wizard.getNextPage(currentPage);
            if (nextPage != null) {
                wizard.getContainer().showPage(nextPage);
                return true;
            }
            if (wizard.canFinish() && wizard.performFinish()) {
                IWizardContainer wc = wizard.getContainer();
                if (wizard instanceof ChainedWizard) {
                    ChainedWizard cw = (ChainedWizard)wizard;
                    wc = cw.getWrappedContainer();
                }
                if (wc instanceof WizardDialog) {
                    WizardDialog dialog = (WizardDialog)wc;
                    dialog.close();
                }
                return true;
            }
        }
        return false;
    }

    public static PageChain createChain(IWizardPage singlePage) {
        return new SimplePageChain(Collections.singletonList(singlePage));
    }

    public static PageChain combinePages(List<IWizardPage> pages) {
        return new SimplePageChain(pages);
    }

    public static PageChain combineChains(List<PageChain> subchains) {
        UnionChain result = new UnionChain();
        for (PageChain next : subchains) {
            result.addSubChain(next);
        }
        return result;
    }

    public static IWizard createWizard(PageChain chain, IRunnableWithResult<Boolean> runnable) {
        return new SingleChainWizard(chain, runnable);
    }

    public static void open(Shell shell, String dialogTitle, String finishButtonText, boolean showProgressMonitor, PageChain pages, IRunnableWithResult<Boolean> runnable) {
        WizardUtil.open(shell, dialogTitle, finishButtonText, showProgressMonitor, pages, runnable, null);
    }

    public static void open(Shell shell, String dialogTitle, String finishButtonText, boolean showProgressMonitor, PageChain pages, IRunnableWithResult<Boolean> runnable, final String helpContextId) {
        SingleChainWizard wizard = new SingleChainWizard(pages, runnable){

            public void addPages() {
                super.addPages();
                if (helpContextId != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), helpContextId);
                }
            }
        };
        WizardDialogWithCustomButtons wd = new WizardDialogWithCustomButtons(shell, (IWizard)wizard, showProgressMonitor);
        wd.setFinishButtonText(finishButtonText);
        wd.setBlockOnOpen(false);
        wizard.setWindowTitle(dialogTitle);
        wd.open();
    }

    public static void open(Shell shell, String dialogTitle, PageChain pages, IRunnableWithResult<Boolean> onFinish) {
        WizardUtil.open(shell, dialogTitle, IDialogConstants.FINISH_LABEL, true, pages, onFinish);
    }

    public static void open(Shell shell, String dialogTitle, IWizardPage page, IRunnableWithResult<Boolean> onFinish) {
        WizardUtil.open(shell, dialogTitle, IDialogConstants.OK_LABEL, true, page, onFinish);
    }

    public static void open(Shell shell, String dialogTitle, IWizardPage page, IRunnableWithResult<Boolean> onFinish, String helpContextId) {
        WizardUtil.open(shell, dialogTitle, IDialogConstants.OK_LABEL, true, WizardUtil.createChain(page), onFinish, helpContextId);
    }

    public static void open(Shell shell, String dialogTitle, String finishButtonText, boolean showProgressMonitor, IWizardPage page, IRunnableWithResult<Boolean> runnable) {
        WizardUtil.open(shell, dialogTitle, finishButtonText, showProgressMonitor, WizardUtil.createChain(page), runnable);
    }

    public static void open(Shell shell, String dialogTitle, String finishButtonText, boolean showProgressMonitor, IWizardPage page, IRunnableWithResult<Boolean> runnable, String helpContextId) {
        WizardUtil.open(shell, dialogTitle, finishButtonText, showProgressMonitor, WizardUtil.createChain(page), runnable, helpContextId);
    }
}

