/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.wizards;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WizardPageJobRunner
implements IOperationRunner {
    private IWizardContainer container;
    private LinkedHashMap queryNames = new LinkedHashMap();
    private boolean scheduled;
    private Display display;

    public WizardPageJobRunner(IWizardContainer container) {
        this.container = container;
        this.display = Display.getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue(Operation toCancel) {
        LinkedHashMap linkedHashMap = this.queryNames;
        synchronized (linkedHashMap) {
            this.queryNames.remove(toCancel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(final String operationName, Operation toRun) {
        boolean shouldSchedule = false;
        LinkedHashMap linkedHashMap = this.queryNames;
        synchronized (linkedHashMap) {
            if (!this.queryNames.containsKey(toRun)) {
                this.queryNames.put(toRun, operationName);
            }
            if (!this.scheduled) {
                this.scheduled = true;
                shouldSchedule = true;
            }
        }
        try {
            if (shouldSchedule) {
                this.container.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                        StatusCollector sc = new StatusCollector();
                        WizardPageJobRunner.this.run(progress, sc);
                        final IStatus status = sc.getStatus();
                        if (!status.isOK()) {
                            WizardPageJobRunner.this.display.asyncExec(new Runnable(){

                                public void run() {
                                    WizardPageJobRunner.this.reportError(operationName, status);
                                }
                            });
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            this.reportError(operationName, StatusUtil.newStatus((Object)this, (Throwable)e.getTargetException()));
        }
        catch (InterruptedException interruptedException) {}
    }

    private void reportError(String operationName, IStatus status) {
        Shell shell = this.container.getShell();
        StatusUtil.log((IStatus)status);
        if (!shell.isDisposed()) {
            ErrorDialog.openError((Shell)shell, (String)operationName, null, (IStatus)status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(SubMonitor reporter, IStatusCollector problems) throws InvocationTargetException {
        try {
            while (true) {
                String nextName;
                Operation next;
                int remain;
                LinkedHashMap linkedHashMap = this.queryNames;
                synchronized (linkedHashMap) {
                    remain = this.queryNames.size();
                    if (remain == 0) {
                        break;
                    }
                    next = (Operation)this.queryNames.keySet().iterator().next();
                    nextName = (String)this.queryNames.remove(next);
                }
                reporter.setWorkRemaining(remain * 100);
                try {
                    if (nextName == null) {
                        throw new NullPointerException();
                    }
                    reporter.setTaskName("");
                    next.run((IProgressMonitor)reporter.newChild(100, 0), problems);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (OperationFailedException e) {
                    problems.reportProblem(e.getReason());
                }
            }
        }
        catch (Throwable throwable) {
            LinkedHashMap linkedHashMap = this.queryNames;
            synchronized (linkedHashMap) {
                this.scheduled = false;
            }
            throw throwable;
        }
        LinkedHashMap linkedHashMap = this.queryNames;
        synchronized (linkedHashMap) {
            this.scheduled = false;
        }
    }
}

