/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.utils;

import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class UIContext
implements IShellProvider {
    private volatile Display display;
    private Shell targetShell;
    private IOperationRunner userOperationRunner;
    private IWorkbenchPage page;

    private UIContext(Display display, Shell targetShell, IWorkbenchPage page, IOperationRunner userOperationRunner) {
        this.display = display;
        this.targetShell = targetShell;
        this.page = page;
        this.userOperationRunner = userOperationRunner;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Shell getShell() {
        return this.targetShell;
    }

    public IOperationRunner getUserOperationRunner() {
        return this.userOperationRunner;
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public static UIContext createPartContext(IWorkbenchPart part) {
        PartSiteJobRunner userOperationRunner = new PartSiteJobRunner(part.getSite(), true);
        return new UIContext(Display.getCurrent(), part.getSite().getShell(), part.getSite().getPage(), userOperationRunner);
    }

    public static UIContext createPartContext(IWorkbenchPart part, String jobName) {
        PartSiteJobRunner userOperationRunner = new PartSiteJobRunner(part.getSite(), true);
        userOperationRunner.setName(jobName);
        return new UIContext(Display.getCurrent(), part.getSite().getShell(), part.getSite().getPage(), userOperationRunner);
    }

    public static UIContext createPageContext(Shell shell, IWorkbenchPage page, String jobName) {
        Display display = Display.getCurrent();
        if (display == null) {
            throw new IllegalStateException();
        }
        return UIContext.createPageContext(display, shell, page, jobName);
    }

    public static UIContext createPageContext(Shell shell, IWorkbenchPage page) {
        return UIContext.createPageContext(shell, page, Messages.UIContext_0);
    }

    public static UIContext createPageContext(Display display, Shell shell, IWorkbenchPage page) {
        JobRunner userJobRunner = new JobRunner(true);
        return new UIContext(display, shell, page, userJobRunner);
    }

    public static UIContext createPageContext(Display display, Shell shell, IWorkbenchPage page, String jobName) {
        JobRunner userJobRunner = new JobRunner(jobName, true);
        return new UIContext(display, shell, page, userJobRunner);
    }

    public static UIContext createShellContext(Shell shell, IOperationRunner userOperationRunner) {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww == null) {
            throw new IllegalStateException(Messages.UIContext_1);
        }
        IWorkbenchPage page = ww.getActivePage();
        if (page == null) {
            throw new IllegalStateException("No active workbench page");
        }
        return new UIContext(shell.getDisplay(), shell, page, userOperationRunner);
    }

    public static UIContext createShellContext(Shell shell) {
        return UIContext.createShellContext(shell, Messages.UIContext_3);
    }

    public static UIContext createShellContext(Shell shell, String jobName) {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww == null) {
            throw new IllegalStateException("No active workbench page");
        }
        IWorkbenchPage page = ww.getActivePage();
        if (page == null) {
            throw new IllegalStateException("No active workbench page");
        }
        return UIContext.createPageContext(shell, page, jobName);
    }

    public void asyncExec(final Runnable runnable) {
        SWTUtil.greedyExec(this.display, new Runnable(){

            public void run() {
                if (UIContext.this.targetShell.isDisposed()) {
                    return;
                }
                runnable.run();
            }
        });
    }
}

