/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.utils;

import com.ibm.team.repository.rcp.ui.internal.parts.PassthroughMnemonicGenerator;
import com.ibm.team.repository.rcp.ui.internal.parts.StandardMnemonicGenerator;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.IDialogConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MnemonicGenerator
implements IMnemonicGenerationAlgorithm {
    private Map<Character, Integer> inUse = new HashMap<Character, Integer>();
    private IMnemonicGenerationAlgorithm algorithm;
    private MnemonicGenerator root;

    public MnemonicGenerator(boolean doesSomething) {
        this.algorithm = doesSomething ? new StandardMnemonicGenerator() : new PassthroughMnemonicGenerator();
    }

    public MnemonicGenerator(IMnemonicGenerationAlgorithm parentGenerator) {
        this.algorithm = parentGenerator;
    }

    private MnemonicGenerator(IMnemonicGenerationAlgorithm root, MnemonicGenerator parent) {
        this.algorithm = root;
        this.root = parent;
    }

    @Override
    public String generateLabel(Set<Character> mnemonicsInUse, String preferredString) {
        Set<Character> used;
        if (mnemonicsInUse.isEmpty()) {
            used = this.inUse.keySet();
        } else if (this.inUse.isEmpty()) {
            used = mnemonicsInUse;
        } else {
            used = new HashSet<Character>();
            used.addAll((Collection<Character>)this.inUse.keySet());
            used.addAll(mnemonicsInUse);
        }
        return this.algorithm.generateLabel(used, preferredString);
    }

    public String generate(String preferred) {
        String result = this.algorithm.generateLabel(this.inUse.keySet(), preferred);
        char key = LegacyActionTools.extractMnemonic((String)result);
        if (key != '\u0000') {
            this.reserve(key);
        }
        return result;
    }

    public void reserve(char toReserve) {
        toReserve = Character.toUpperCase(toReserve);
        int count = 0;
        Integer currentRefCount = this.inUse.get(Character.valueOf(toReserve));
        if (currentRefCount != null) {
            count = currentRefCount;
        }
        if (count == 0 && this.root != null) {
            this.root.reserve(toReserve);
        }
        this.inUse.put(Character.valueOf(toReserve), count + 1);
    }

    public void unreserve(char toRelease) {
        toRelease = Character.toUpperCase(toRelease);
        int count = 0;
        Integer currentRefCount = this.inUse.get(Character.valueOf(toRelease));
        if (currentRefCount != null) {
            count = currentRefCount;
        }
        if (--count < 0) {
            return;
        }
        if (count == 0) {
            this.inUse.remove(Character.valueOf(toRelease));
            if (this.root != null) {
                this.root.unreserve(toRelease);
            }
        } else {
            this.inUse.put(Character.valueOf(toRelease), count);
        }
    }

    public MnemonicGenerator newChild() {
        if (this.root == null) {
            return new MnemonicGenerator(this, this);
        }
        return new MnemonicGenerator(this.root, this.root);
    }

    public void dispose() {
        if (this.root != null) {
            for (Character charInUse : this.inUse.keySet()) {
                this.root.unreserve(charInUse.charValue());
            }
        }
        this.inUse.clear();
    }

    public static MnemonicGenerator forWizardPage() {
        MnemonicGenerator result = new MnemonicGenerator(true);
        result.reserve(LegacyActionTools.extractMnemonic((String)IDialogConstants.BACK_LABEL));
        result.reserve(LegacyActionTools.extractMnemonic((String)IDialogConstants.FINISH_LABEL));
        result.reserve(LegacyActionTools.extractMnemonic((String)IDialogConstants.NEXT_LABEL));
        return result;
    }
}

