/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.utils;

import com.ibm.team.repository.common.IItemHandle;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ItemHandleFilter
extends ViewerFilter {
    private IItemHandle[] fExcludedItemHandles;
    private ITreeContentProvider fContentProvider;

    public ItemHandleFilter(IItemHandle[] excludedItemHandles) {
        this(excludedItemHandles, null);
    }

    public ItemHandleFilter(IItemHandle[] excludedItemHandles, ITreeContentProvider contentProvider) {
        this.fExcludedItemHandles = excludedItemHandles;
        this.fContentProvider = contentProvider;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof IItemHandle)) {
            return true;
        }
        if (this.containsItem(this.fExcludedItemHandles, (IItemHandle)element)) {
            return false;
        }
        if (this.fContentProvider == null) {
            return true;
        }
        Object[] children = this.fContentProvider.getChildren(element);
        if (children == null || children.length == 0) {
            return true;
        }
        int i = 0;
        while (i < children.length) {
            if (this.select(viewer, element, children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsItem(IItemHandle[] items, IItemHandle item) {
        int i = 0;
        while (i < items.length) {
            if (items[i].sameItemId(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

