/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts.impl;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.ui.internal.parts.EnhancedFillLayout;
import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.internal.viewers.ControlUpdater;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.ControlSiteDecorator;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class SelectionPart
extends AbstractPart
implements IAdaptable {
    private WritableValue currentSelection = new WritableValue<Object>(null);
    private IPartResult result;
    private AbstractPart part;
    private ISelectionProvider selectionProvider;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionPart.this.handleSelectionChanged(event.getSelection());
        }
    };

    public SelectionPart(IControlSite site, IPartFactory contents, Object nestedInput, IPartResult outerResult, String titleMsg, String msg) {
        super(site, outerResult);
        Composite parent = site.getParent();
        this.result = outerResult;
        GridLayoutFactory.fillDefaults().applyTo(parent);
        if (msg != null) {
            Label msgLabel = new Label(parent, 0);
            msgLabel.setText(msg);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)msgLabel);
        }
        final Composite nested = new Composite(parent, 0);
        nested.setLayout((Layout)new EnhancedFillLayout());
        this.part = contents.createPart(new ControlSiteDecorator(site){

            public void setSelectionProvider(ISelectionProvider selectionProvider) {
                SelectionPart.this.doSetSelectionProvider(selectionProvider);
                super.setSelectionProvider(selectionProvider);
            }

            public Composite getParent() {
                return nested;
            }
        }, nestedInput);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)nested);
        ButtonBar buttons = new ButtonBar(parent, MessageDialogFactory.getChoicesForType(5), new IPartResult(){

            public void setResult(Object _result) {
                if (_result == MessageDialogFactory.OKAY.getValue()) {
                    SelectionPart.this.doOkay();
                } else if (_result == MessageDialogFactory.CANCEL.getValue()) {
                    SelectionPart.this.doCancel();
                }
            }
        });
        new ControlUpdater(){

            protected void updateControl(Control theControl) {
                ISelection sel = (ISelection)SelectionPart.this.currentSelection.getValue();
                theControl.setEnabled(sel instanceof IStructuredSelection && !((IStructuredSelection)sel).isEmpty());
            }
        }.setControl((Control)buttons.getButton(MessageDialogFactory.OKAY.getValue()));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo(buttons.getControl());
        site.setDefaultButton(buttons.getButton(MessageDialogFactory.OKAY.getValue()));
        site.getNameable().setName(titleMsg);
    }

    protected void handleSelectionChanged(ISelection selection) {
        this.currentSelection.setValue(selection);
    }

    protected void doSetSelectionProvider(ISelectionProvider selectionProvider2) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(this.listener);
        }
        this.selectionProvider = selectionProvider2;
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.listener);
            this.handleSelectionChanged(this.selectionProvider.getSelection());
        } else {
            this.handleSelectionChanged((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void doOkay() {
        this.result.setResult(this.currentSelection.getValue());
        this.getControlSite().close();
    }

    private void doCancel() {
        this.result.setResult(null);
        this.getControlSite().close();
    }

    public Object getAdapter(Class adapter) {
        return Adapters.getAdapter((Object)this.part, (Class)adapter);
    }
}

