/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts.impl;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.internal.viewers.ChoiceEnumeration;
import com.ibm.team.repository.rcp.ui.internal.viewers.ChoiceValue;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialog;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class MessageDialogFactory
implements IPartFactory {
    private ChoiceEnumeration choices;
    private String message;
    private ImageDescriptor imageDescriptor;
    private String title;
    public static final int NONE = 0;
    public static final int TYPE_ERROR = 1;
    public static final int TYPE_INFORMATION = 2;
    public static final int TYPE_QUESTION = 3;
    public static final int TYPE_WARNING = 4;
    public static final int TYPE_CONFIRM = 5;
    public static final ChoiceValue OKAY = new ChoiceValue(IDialogConstants.OK_LABEL, new Integer(0));
    public static final ChoiceValue CANCEL = new ChoiceValue(IDialogConstants.CANCEL_LABEL, new Integer(1));
    public static final ChoiceValue YES = new ChoiceValue(IDialogConstants.YES_LABEL, new Integer(2));
    public static final ChoiceValue NO = new ChoiceValue(IDialogConstants.NO_LABEL, new Integer(3));
    public static final ChoiceValue APPLY = new ChoiceValue(Messages.MessageDialogFactory_0, new Integer(1234));
    private final String helpContextId;
    private final String helpContextMessage;

    public MessageDialogFactory(ChoiceEnumeration choices, ImageDescriptor descriptor, String title, String message) {
        this(choices, descriptor, title, message, null, null);
    }

    public MessageDialogFactory(ChoiceEnumeration choices, ImageDescriptor descriptor, String title, String message, String helpContextId, String helpContextMessage) {
        this.choices = choices;
        this.imageDescriptor = descriptor;
        this.message = message;
        this.title = title;
        this.helpContextId = helpContextId;
        this.helpContextMessage = helpContextMessage;
    }

    public MessageDialogFactory(int type, String title, String message) {
        this(MessageDialogFactory.getChoicesForType(type), MessageDialogFactory.getImageForType(type), title, message, null, null);
    }

    public static void showMessage(Shell parentShell, int severity, String title, String message) {
        MessageDialogFactory.showMessage(parentShell, title, StatusUtil.newStatus(MessageDialogFactory.class, (int)severity, (String)message));
    }

    public static Shell showMessage(Shell parentShell, IStatus toShow) {
        int dialogType = MessageDialogFactory.statusSeverityToDialogType(toShow.getSeverity());
        return Parts.openDialog(parentShell, null, new MessageDialogFactory(dialogType, MessageDialogFactory.getTitleForType(dialogType), toShow.getMessage()));
    }

    public static Shell showMessage(Shell parentShell, String title, int severity, String message) {
        return MessageDialogFactory.showMessage(parentShell, title, StatusUtil.newStatus(MessageDialogFactory.class, (int)severity, (String)message));
    }

    public static Shell showMessage(Shell parentShell, String title, IStatus toShow) {
        return Parts.openDialog(parentShell, null, new MessageDialogFactory(MessageDialogFactory.statusSeverityToDialogType(toShow.getSeverity()), title, toShow.getMessage()));
    }

    public static boolean confirm(Shell parentShell, String title, String message) {
        final Object[] result = new Object[1];
        Parts.openModalDialog(parentShell, new IPartResult(){

            public void setResult(Object r) {
                result[0] = r;
            }
        }, new MessageDialogFactory(5, title, message));
        return result[0] == OKAY.getValue();
    }

    public static int statusSeverityToDialogType(int statusSeverity) {
        switch (statusSeverity) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 2: {
                return 4;
            }
        }
        return 2;
    }

    public static String getTitleForType(int type) {
        switch (type) {
            case 1: {
                return Messages.MessageDialogFactory_1;
            }
            case 2: {
                return Messages.MessageDialogFactory_2;
            }
            case 5: {
                return Messages.MessageDialogFactory_3;
            }
            case 3: {
                return Messages.MessageDialogFactory_4;
            }
            case 4: {
                return Messages.MessageDialogFactory_5;
            }
        }
        return Messages.MessageDialogFactory_6;
    }

    public static ChoiceEnumeration getChoicesForType(int type) {
        switch (type) {
            case 5: {
                return new ChoiceEnumeration().add(OKAY).add(CANCEL);
            }
            case 3: {
                return new ChoiceEnumeration().add(YES).add(NO);
            }
        }
        return new ChoiceEnumeration().add(OKAY);
    }

    public static ImageDescriptor getImageForType(int type) {
        switch (type) {
            case 1: {
                return MessageDialogFactory.getSwtImage(1);
            }
            case 2: {
                return MessageDialogFactory.getSwtImage(2);
            }
            case 5: {
                return MessageDialogFactory.getSwtImage(4);
            }
            case 3: {
                return MessageDialogFactory.getSwtImage(4);
            }
            case 4: {
                return MessageDialogFactory.getSwtImage(8);
            }
        }
        return null;
    }

    public static ImageDescriptor getSwtImage(int swtImageConstant) {
        Display d = Display.getCurrent();
        return ImageDescriptor.createFromImage((Image)d.getSystemImage(swtImageConstant), (Device)d);
    }

    public static ButtonBar createOkayCancelBar(WidgetToolkit toolkit, Composite parent, IPartResult result) {
        return MessageDialogFactory.createButtonBar(toolkit, new MnemonicGenerator(false), parent, MessageDialogFactory.getChoicesForType(5), result);
    }

    public static ButtonBar createOkayCancelBar(WidgetToolkit toolkit, MnemonicGenerator generator, Composite parent, IPartResult result) {
        return MessageDialogFactory.createButtonBar(toolkit, generator, parent, MessageDialogFactory.getChoicesForType(5), result);
    }

    public static ButtonBar createButtonBar(Composite parent, WidgetFactoryContext context, ChoiceEnumeration choiceEnumeration, IPartResult result, boolean isVertical) {
        return new ButtonBar(parent, choiceEnumeration, result, context.getToolkit(), context.getMnemonics(), isVertical);
    }

    public static ButtonBar createButtonBar(Composite parent, WidgetFactoryContext context, ChoiceEnumeration choiceEnumeration, IPartResult result) {
        return new ButtonBar(parent, choiceEnumeration, result, context.getToolkit(), context.getMnemonics(), false);
    }

    public static ButtonBar createButtonBar(WidgetToolkit toolkit, MnemonicGenerator mnemonics, Composite parent, ChoiceEnumeration choiceEnumeration, IPartResult result) {
        return new ButtonBar(parent, choiceEnumeration, result, toolkit, mnemonics, false);
    }

    public static ButtonBar createButtonBar(WidgetToolkit toolkit, Composite parent, ChoiceEnumeration choiceEnumeration, IPartResult result) {
        return new ButtonBar(parent, choiceEnumeration, result, toolkit, new MnemonicGenerator(false), false);
    }

    public AbstractPart createPart(IControlSite site, Object initialInput) {
        if (initialInput == null) {
            initialInput = new IPartResult(){

                public void setResult(Object result) {
                }
            };
        }
        return new MessageDialog(site, (IPartResult)initialInput, this.imageDescriptor, this.message, this.choices, this.title, this.helpContextId, this.helpContextMessage);
    }

    public static void showError(Shell shell, String errorMessage) {
        MessageDialogFactory.showMessage(shell, StatusUtil.newStatus(MessageDialogFactory.class, (int)4, (String)errorMessage));
    }
}

