/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts.impl;

import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.internal.viewers.ChoiceEnumeration;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

class MessageDialog
extends AbstractPart {
    static Point cachedMinimumSize = null;

    public MessageDialog(IControlSite site, final IPartResult result, ImageDescriptor imageDescriptor, String message, ChoiceEnumeration choices, String title, final String helpId, String helpText) {
        super(site, null);
        site.getNameable().setName(title);
        ResourceManager manager = site.getResources();
        Composite parent = site.getParent();
        int messageDialogBugCorrection = LayoutConstants.getMargins().y / 2;
        Point defaultSpacing = LayoutConstants.getSpacing();
        GridLayoutFactory.fillDefaults().spacing(defaultSpacing.x * 2, defaultSpacing.y).margins(0, messageDialogBugCorrection).numColumns(2).applyTo(parent);
        Dialog.applyDialogFont((Control)parent);
        Image image = manager.createImageWithDefault(imageDescriptor);
        if (image != null) {
            Label imageLabel = new Label(parent, 0);
            image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        }
        if (message != null) {
            Label messageLabel = new Label(parent, 64);
            messageLabel.setText(message);
            Point size = MessageDialog.getCachedMinimumSize();
            GridDataFactory.fillDefaults().align(4, 1).grab(true, true).hint(size.x, -1).applyTo((Control)messageLabel);
        }
        if (helpId != null) {
            Link link = new Link(parent, 0);
            link.setText("<a href=\"help\">" + helpText + "</a>");
            link.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpId);
                }
            });
            Point size = MessageDialog.getCachedMinimumSize();
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000008).grab(false, true).hint(size.x, -1).span(2, 1).applyTo((Control)link);
        }
        Label spacer = new Label(parent, 0);
        GridDataFactory.generate((Control)spacer, (int)2, (int)1);
        ButtonBar buttons = new ButtonBar(parent, choices, new IPartResult(){

            public void setResult(Object result_) {
                result.setResult(result_);
                MessageDialog.this.getControlSite().close();
            }
        }, false);
        GridDataFactory.fillDefaults().span(2, 1).align(0x1000008, 1).applyTo(buttons.getControl());
    }

    public MessageDialog(IControlSite site, IPartResult result, ImageDescriptor imageDescriptor, String message, ChoiceEnumeration choices, String title) {
        this(site, result, imageDescriptor, message, choices, title, null, "");
    }

    private static Point getCachedMinimumSize() {
        if (cachedMinimumSize == null) {
            GC gc = new GC((Drawable)Display.getCurrent());
            gc.setFont(JFaceResources.getDialogFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            cachedMinimumSize = new Point(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)300), 0);
            gc.dispose();
        }
        return cachedMinimumSize;
    }
}

