/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts.impl;

import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

class InputPart
extends AbstractPart {
    private Text[] texts;
    private boolean[] allowBlanks;
    private Button okButton;
    private IPartResult result;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            int i = 0;
            while (i < InputPart.this.texts.length) {
                if (InputPart.this.texts[i].getText().trim().equals("") && !InputPart.this.allowBlanks[i]) {
                    InputPart.this.okButton.setEnabled(false);
                    return;
                }
                ++i;
            }
            InputPart.this.okButton.setEnabled(true);
        }
    };

    public InputPart(IControlSite site, String[] inputs, IPartResult result, boolean[] allowBlanks, String[] initialValue) {
        super(site, result);
        Composite parent = site.getParent();
        this.allowBlanks = allowBlanks;
        this.result = result;
        Dialog.applyDialogFont((Control)parent);
        this.texts = new Text[inputs.length];
        int i = 0;
        while (i < inputs.length) {
            String msg = inputs[i];
            Label label = new Label(parent, 0);
            label.setText(msg);
            Text text = new Text(parent, 2052);
            GridDataFactory.fillDefaults().hint(300, -1).grab(true, false).applyTo((Control)text);
            String val = initialValue[i];
            text.setText(val);
            if (val.length() > 0) {
                text.selectAll();
            }
            text.addModifyListener(this.listener);
            this.texts[i] = text;
            ++i;
        }
        ButtonBar buttons = new ButtonBar(parent, MessageDialogFactory.getChoicesForType(5), new IPartResult(){

            public void setResult(Object _result) {
                if (_result == MessageDialogFactory.OKAY.getValue()) {
                    InputPart.this.doOkay();
                } else if (_result == MessageDialogFactory.CANCEL.getValue()) {
                    InputPart.this.doCancel();
                }
            }
        });
        this.okButton = buttons.getButton(MessageDialogFactory.OKAY.getValue());
        this.okButton.setEnabled(false);
        GridDataFactory.fillDefaults().span(2, 1).align(131072, 1024).grab(true, true).applyTo(buttons.getControl());
        site.setDefaultButton(this.okButton);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(parent);
    }

    private void doOkay() {
        this.result.setResult(this.getInputs());
        this.getControlSite().close();
    }

    private void doCancel() {
        this.result.setResult(null);
        this.getControlSite().close();
    }

    private String[] getInputs() {
        if (this.texts == null || this.texts.length == 0) {
            return null;
        }
        String[] result = new String[this.texts.length];
        int i = 0;
        while (i < this.texts.length) {
            result[i] = this.texts[i].getText();
            ++i;
        }
        return result;
    }
}

