/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.core.utils.ClassIdentifier;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExtContributionItem;
import com.ibm.team.repository.rcp.ui.internal.parts.PageViewRegistry;
import com.ibm.team.repository.rcp.ui.internal.parts.PartHost;
import com.ibm.team.repository.rcp.ui.internal.parts.ViewId;
import com.ibm.team.repository.rcp.ui.internal.utils.MementoUtil;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IMenuProvider;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;

public final class ViewHost
extends PartHost
implements IViewPart {
    public static final String INPUT = "input";
    private ClassIdentifier implementationClass;
    private Object currentInput = null;
    private IReusablePart reusablePart = null;
    private static final String VIEWSTATE_ID = "viewState";
    private IMemento savedState;
    private IPersistable persistable;

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        this.implementationClass = new ClassIdentifier(cfig.getNamespace(), (String)data);
    }

    public AbstractPart createPart(IPartSite site, Composite parent) {
        IMenuProvider menuProvider;
        Class implementation;
        try {
            implementation = this.implementationClass.loadClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(this.formatError(NLS.bind((String)"Cannot load class {0}", (Object)this.implementationClass.getTypeName())));
        }
        if (!AbstractPart.class.isAssignableFrom(implementation)) {
            throw new RuntimeException(this.formatError(NLS.bind((String)"{0} is not an instance of {1}", (Object)implementation.getClass().getName(), (Object)AbstractPart.class.getName())));
        }
        AbstractPart part = PartFactory.createPart(implementation, site, this.currentInput);
        this.savedState = null;
        final IReusablePart reusablePartAdapter = (IReusablePart)Adapters.getAdapter((Object)part, IReusablePart.class);
        if (reusablePartAdapter != null) {
            this.reusablePart = new IReusablePart(){

                public void setInput(Object newInput) {
                    ViewHost.this.currentInput = newInput;
                    reusablePartAdapter.setInput(ViewHost.this.currentInput);
                }
            };
        }
        this.persistable = (IPersistable)Adapters.getAdapter((Object)part, IPersistable.class);
        IWorkbenchPage page = this.getSite().getPage();
        PageViewRegistry pvr = PageViewRegistry.findRegistryForPage(page);
        ViewId myId = new ViewId(this.getViewSite().getId(), this.getViewSite().getSecondaryId());
        pvr.addView(myId);
        pvr.setInput(myId, this.currentInput);
        if (reusablePartAdapter != null && this.currentInput != null) {
            reusablePartAdapter.setInput(this.currentInput);
        }
        if ((menuProvider = (IMenuProvider)Adapters.getAdapter((Object)part, IMenuProvider.class)) != null) {
            MenuExtContributionItem toolbarContribution = new MenuExtContributionItem();
            MenuExtContributionItem menuContribution = new MenuExtContributionItem();
            toolbarContribution.setMenu(menuProvider.getToolbarContributions());
            menuContribution.setMenu(menuProvider.getMenuContributions());
            this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)toolbarContribution);
            this.getViewSite().getActionBars().getMenuManager().add((IContributionItem)menuContribution);
        }
        return part;
    }

    private String formatError(String string) {
        return NLS.bind((String)"Error in view ID {0} in plugin {1}: {2}", (Object[])new Object[]{this.getSite().getId(), this.getSite().getPluginId(), string});
    }

    public IViewSite getViewSite() {
        return (IViewSite)this.getSite();
    }

    public void init(IViewSite site) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
    }

    protected IMemento getSavedState() {
        if (this.savedState == null) {
            return XMLMemento.createWriteRoot((String)"empty");
        }
        return this.savedState;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (memento != null) {
            try {
                Object objectBeingEdited = MementoUtil.loadChild(memento, INPUT, Object.class, null);
                this.currentInput = objectBeingEdited;
                this.savedState = memento.getChild(VIEWSTATE_ID);
            }
            catch (CoreException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
    }

    public void saveState(IMemento memento) {
        IPersistableElement element = (IPersistableElement)Adapters.getAdapter((Object)this.currentInput, IPersistableElement.class);
        if (element != null) {
            MementoUtil.saveChild(memento, INPUT, this.currentInput);
        }
        IMemento partState = memento.createChild(VIEWSTATE_ID);
        if (this.persistable != null) {
            this.persistable.saveState(partState);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IReusablePart.class) {
            return this.reusablePart;
        }
        return super.getAdapter(adapter);
    }
}

