/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.ui.parts.AbstractControlSite;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

class PartDialog
implements IAdaptable {
    private Shell shell;
    private AbstractPart part;

    public PartDialog(IPartFactory factory, Object input, Shell parent, int flags) {
        this.shell = new Shell(parent, flags);
        AbstractControlSite site = new AbstractControlSite((Composite)this.shell){

            public void close() {
                PartDialog.this.shell.dispose();
            }

            public void setName(String newName) {
                PartDialog.this.shell.setText(newName);
                super.setName(newName);
            }

            public void setDefaultButton(Button defaultButton) {
                PartDialog.this.shell.setDefaultButton(defaultButton);
            }
        };
        Image[] defaultImages = Window.getDefaultImages();
        ArrayList<Image> undisposed = new ArrayList<Image>();
        int i = 0;
        while (i < defaultImages.length) {
            Image next = defaultImages[i];
            if (!next.isDisposed()) {
                undisposed.add(next);
            }
            ++i;
        }
        defaultImages = undisposed.toArray(new Image[undisposed.size()]);
        this.shell.setImages(defaultImages);
        this.part = factory.createPart(site, input);
        Point margins = LayoutConstants.getMargins();
        site.setMargins(Geometry.createDiffRectangle((int)margins.x, (int)margins.x, (int)margins.y, (int)margins.y));
        this.shell.pack();
        Point size = this.shell.getSize();
        this.shell.setLocation(this.getInitialLocation(size));
        this.constrainShellSize();
    }

    public Shell getShell() {
        return this.shell;
    }

    public void open() {
        this.shell.open();
    }

    private Point getInitialLocation(Point initialSize) {
        Composite parent = this.shell.getParent();
        Monitor monitor = this.shell.getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected void constrainShellSize() {
        Rectangle constrained;
        Rectangle bounds = this.shell.getBounds();
        if (!bounds.equals((Object)(constrained = this.getConstrainedShellBounds(bounds)))) {
            this.shell.setBounds(constrained);
        }
    }

    private Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Monitor mon = this.getClosestMonitor(this.getShell().getDisplay(), Geometry.centerPoint((Rectangle)result));
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    private Monitor getClosestMonitor(Display toSearch, Point toFind) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = toSearch.getMonitors();
        Monitor result = monitors[0];
        int idx = 0;
        while (idx < monitors.length) {
            Monitor current = monitors[idx];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++idx;
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        return Adapters.getAdapter((Object)this.part, (Class)adapter);
    }
}

