/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts;

import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.INameable;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;

public class ControlSiteDecorator
implements IControlSite {
    private IControlSite toDecorate;

    public ControlSiteDecorator(IControlSite toDecorate) {
        this.toDecorate = toDecorate;
    }

    public static IControlSite createDynamicDecorator(final IControlSite decorator, final IControlSite toDecorate) {
        HashSet allInterfaces = new HashSet();
        Class<?> current = toDecorate.getClass();
        while (current != null) {
            allInterfaces.addAll(Arrays.asList(current.getInterfaces()));
            current = current.getSuperclass();
        }
        Class[] interfaces = allInterfaces.toArray(new Class[allInterfaces.size()]);
        return (IControlSite)Proxy.newProxyInstance(ControlSiteDecorator.class.getClassLoader(), interfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().isAssignableFrom(decorator.getClass())) {
                    return method.invoke((Object)decorator, args);
                }
                return method.invoke((Object)toDecorate, args);
            }
        });
    }

    public void addInput(IWorkingCopy newInput) {
        this.toDecorate.addInput(newInput);
    }

    public void close() {
        this.toDecorate.close();
    }

    public MnemonicGenerator getMnemonicGenerator() {
        return this.toDecorate.getMnemonicGenerator();
    }

    public INameable getNameable() {
        return this.toDecorate.getNameable();
    }

    public IOperationRunner getOperationRunner() {
        return this.toDecorate.getOperationRunner();
    }

    public Composite getParent() {
        return this.toDecorate.getParent();
    }

    public ResourceManager getResources() {
        return this.toDecorate.getResources();
    }

    public Shell getShell() {
        return this.toDecorate.getShell();
    }

    public WidgetToolkit getToolkit() {
        return this.toDecorate.getToolkit();
    }

    public boolean removeInput(IWorkingCopy toRemove, boolean force) {
        return this.toDecorate.removeInput(toRemove, force);
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.toDecorate.setSelectionProvider(selectionProvider);
    }

    public void setStatus(IStatus statusMessage) {
    }

    public void setBusy(boolean isBusy) {
    }

    public IMemento getMemento() {
        return this.toDecorate.getMemento();
    }

    public void setDefaultButton(Button defaultButton) {
        this.toDecorate.setDefaultButton(defaultButton);
    }

    public WidgetFactoryContext getContext() {
        return this.toDecorate.getContext();
    }
}

