/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.jface.labelProviders.IElementRemovedListener;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.ImagePool;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.menus.CheckAction;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.menus.SeparatorExt;
import com.ibm.team.repository.rcp.ui.internal.parts.BackButton;
import com.ibm.team.repository.rcp.ui.internal.parts.ForwardButton;
import com.ibm.team.repository.rcp.ui.internal.parts.UndoStack;
import com.ibm.team.repository.rcp.ui.internal.selection.ITypedSelectionService;
import com.ibm.team.repository.rcp.ui.internal.selection.SelectionServiceRegistry;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.MementoUtil;
import com.ibm.team.repository.rcp.ui.parts.AbstractViewPart;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.repository.rcp.ui.parts.IPinnablePart;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.XMLMemento;

public abstract class AbstractViewWithInput
extends AbstractViewPart
implements IReusablePart,
IPinnablePart,
IPersistable {
    private static final String PINNED_STATE = "pinned_state";
    private static final String LINKED_STATE = "linked_state";
    private Object currentInput;
    private CheckAction linkedAction;
    private Class type;
    private IChangeListener selectionListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (!AbstractViewWithInput.this.isLinked()) {
                return;
            }
            AbstractViewWithInput.this.updateToMatchSelection();
        }
    };
    private CheckAction pinnedAction;
    private UndoStack history;
    private IChangeListener historyListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            AbstractViewWithInput.this.history.moveTo(source);
            AbstractViewWithInput.this.setInput(source);
        }
    };
    private BackButton backButton;
    private ForwardButton forwardButton;
    private List menuEntries;
    private ITypedSelectionService selectionService;
    private Class inputType;
    private InputLabelProvider labelProvider;
    private PushAction testSaveInputButton;
    private PushAction testLoadInputButton;

    public AbstractViewWithInput(IPartSite site, Class type, Object initialInput) {
        super(site, initialInput);
        this.history = new UndoStack(10);
        this.type = type;
        IMemento memento = site.getMemento();
        this.inputType = type;
        this.selectionService = SelectionServiceRegistry.getService(site.getPage());
        this.selectionService.addListener(type, this.selectionListener);
        this.linkedAction = new CheckAction(ImagePool.LINK_BUTTON, Messages.AbstractViewWithInput_2);
        this.pinnedAction = new CheckAction(ImagePool.PIN_VIEW, Messages.AbstractViewWithInput_3);
        this.pinnedAction.setSelected(MementoUtil.getBoolean(memento, PINNED_STATE, false));
        this.linkedAction.setSelected(MementoUtil.getBoolean(memento, LINKED_STATE, false));
        this.pinnedAction.addChangeListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                if (property == IActionExt.PROP_SELECTED && AbstractViewWithInput.this.pinnedAction.getSelection()) {
                    AbstractViewWithInput.this.linkedAction.setSelected(false);
                }
            }
        });
        this.linkedAction.addChangeListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                if (property == IActionExt.PROP_SELECTED && AbstractViewWithInput.this.linkedAction.getSelection()) {
                    AbstractViewWithInput.this.pinnedAction.setSelected(false);
                    AbstractViewWithInput.this.updateToMatchSelection();
                }
            }
        });
        this.labelProvider = new InputLabelProvider();
        this.backButton = new BackButton(this.history, this.labelProvider);
        this.backButton.addListener(this.historyListener);
        this.forwardButton = new ForwardButton(this.history, this.labelProvider);
        this.forwardButton.addListener(this.historyListener);
        this.testSaveInputButton = new PushAction("Save state (test)", new Runnable(){

            public void run() {
                XMLMemento memento = XMLMemento.createWriteRoot((String)"testInput");
                Object input = AbstractViewWithInput.this.getInput();
                MementoUtil.saveState((IMemento)memento, input);
                try {
                    FileOutputStream stream = new FileOutputStream("/temp.xml");
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf8");
                    memento.save((Writer)writer);
                    writer.close();
                }
                catch (Exception e) {
                    StatusUtil.log((Object)this, (String)"Can't write file", (Throwable)e);
                }
            }
        });
        this.testLoadInputButton = new PushAction("Load state (test)", new Runnable(){

            public void run() {
                try {
                    FileInputStream stream = new FileInputStream("/temp.xml");
                    InputStreamReader reader = new InputStreamReader((InputStream)stream, "utf8");
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                    Object newInput = MementoUtil.loadState((IMemento)memento, Object.class);
                    AbstractViewWithInput.this.setInput(newInput);
                    reader.close();
                }
                catch (Exception e) {
                    StatusUtil.log((Object)this, (String)"Can't write file", (Throwable)e);
                }
            }
        });
        ArrayList<IActionExt> contributions = new ArrayList<IActionExt>();
        contributions.add(SeparatorExt.getInstance());
        contributions.add(this.backButton);
        contributions.add(this.forwardButton);
        if (this.useLinkAction()) {
            contributions.add(this.linkedAction);
        }
        contributions.add(this.pinnedAction);
        contributions.add(SeparatorExt.getInstance());
        this.menuEntries = contributions;
        this.doSetInput(null);
    }

    protected boolean useLinkAction() {
        return false;
    }

    protected Object adaptInput(Object input) {
        if (input == null) {
            return null;
        }
        return Adapters.getAdapter((Object)input, (Class)this.type);
    }

    protected final boolean isLinked() {
        return this.getSite().getPart() != this.getSite().getPage().getActivePart() && this.linkedAction.getSelection();
    }

    protected IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode(String.valueOf(RepositoryUiPlugin.PLUGIN_ID) + '/' + this.getClass().getName());
    }

    public void saveState(IMemento memento) {
        MementoUtil.putBoolean(memento, PINNED_STATE, this.pinnedAction.getSelection());
        MementoUtil.putBoolean(memento, LINKED_STATE, this.linkedAction.getSelection());
    }

    public final boolean isPinned() {
        return this.pinnedAction.getSelection();
    }

    public final void setInput(Object item) {
        if ((item = this.adaptInput(item)) == null) {
            return;
        }
        if (!Util.equals((Object)this.currentInput, (Object)item)) {
            this.doSetInput(item);
            if (item != null) {
                this.inputChanged(item);
            } else {
                this.inputCleared();
            }
        }
    }

    private void doSetInput(Object item) {
        if (item != null) {
            HashSet<Set> oldEntries = new HashSet<Set>();
            oldEntries.add(this.history.getKnownEntries());
            this.history.push(item);
            oldEntries.removeAll(this.history.getKnownEntries());
            for (Object e : oldEntries) {
                this.labelProvider.handleElementRemoved(e);
            }
        }
        this.currentInput = item;
    }

    protected final void setInputDescription(Object theInput, String newDescription) {
        if (this.currentInput == theInput) {
            this.getSite().getNameable().setContentDescription(newDescription);
        }
        if (theInput != null && (this.currentInput == theInput || this.history.getKnownEntries().contains(theInput))) {
            this.labelProvider.setText(this.currentInput, newDescription);
        }
    }

    protected void inputChanged(Object item) {
    }

    protected void inputCleared() {
    }

    public void dispose() {
        this.selectionService.removeListener(this.inputType, this.selectionListener);
        this.history.removeListener(this.historyListener);
    }

    public final Object getInput() {
        return this.linkedAction.getSelection() ? null : this.currentInput;
    }

    private void updateToMatchSelection() {
        Collection elements = this.selectionService.getSelection(this.type);
        if (elements.isEmpty()) {
            this.setInput(null);
        } else {
            Object item = elements.iterator().next();
            this.setInput(item);
        }
    }

    public void addMenuEntries(List output) {
        output.addAll(this.menuEntries);
    }

    public void addToolbarEntries(List output) {
        output.addAll(this.menuEntries);
    }

    private class InputLabelProvider
    extends BaseLabelProvider
    implements IElementRemovedListener {
        private Map<Object, String> names = new HashMap<Object, String>();

        private InputLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            String text = this.names.get(element);
            if (text != null) {
                label.setText(text);
            }
        }

        public void setText(Object element, String newText) {
            this.names.put(element, newText);
            this.fireChangeEvent(Collections.singleton(element));
        }

        public void handleElementRemoved(Object element) {
            this.names.remove(element);
        }
    }
}

