/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.parts;

import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.ErrorHandlingPart;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.INameable;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractControlSite
implements IControlSite,
INameable {
    private ErrorHandlingPart errorPart = null;
    private Composite parentControl = null;
    private ResourceManager resources;
    private JobRunner jobRunner = null;
    private Button defaultButton = null;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (AbstractControlSite.this.errorPart != null) {
                AbstractControlSite.this.errorPart.getNestedControl().dispose();
            }
            AbstractControlSite.this.dispose();
        }
    };
    private WidgetToolkit toolkit;
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            if (AbstractControlSite.this.defaultButton == null) {
                return;
            }
            if (Display.getCurrent().getFocusControl() instanceof Button) {
                return;
            }
            if (e.character == '\r') {
                Display d = Display.getCurrent();
                Point center = Geometry.centerPoint((Rectangle)AbstractControlSite.this.defaultButton.getBounds());
                center = d.map((Control)AbstractControlSite.this.defaultButton.getParent(), null, center);
                AbstractControlSite.this.defaultButton.setFocus();
                Event clickEvent = new Event();
                clickEvent.type = 1;
                clickEvent.character = (char)32;
                Display.getCurrent().post(clickEvent);
                clickEvent = new Event();
                clickEvent.type = 2;
                clickEvent.character = (char)32;
                Display.getCurrent().post(clickEvent);
            }
        }
    };
    private MnemonicGenerator mnemonicGenerator;
    private JobRunner userJobRunner;

    public AbstractControlSite(Composite theControl) {
        theControl.addDisposeListener(this.disposeListener);
        theControl.addTraverseListener(this.traverseListener);
        this.parentControl = theControl;
    }

    public final MnemonicGenerator getMnemonicGenerator() {
        if (this.mnemonicGenerator == null) {
            this.mnemonicGenerator = this.createMnemonicGenerator();
        }
        return this.mnemonicGenerator;
    }

    protected MnemonicGenerator createMnemonicGenerator() {
        return new MnemonicGenerator(true);
    }

    public void setMargins(Rectangle margins) {
        this.getErrorHandlingPart().setMargins(margins);
    }

    public WidgetToolkit getToolkit() {
        if (this.toolkit == null) {
            this.toolkit = this.createToolkit();
        }
        return this.toolkit;
    }

    protected WidgetToolkit createToolkit() {
        WidgetToolkit result = WidgetToolkit.createSwtToolkit();
        return result;
    }

    public void setBusy(boolean isBusy) {
    }

    public void addInput(IWorkingCopy newInput) {
    }

    public boolean removeInput(IWorkingCopy toRemove, boolean force) {
        return true;
    }

    public final INameable getNameable() {
        return this;
    }

    public void setContentDescription(String contentDescription) {
    }

    public void setImage(ImageDescriptor theImage) {
    }

    public void setName(String newName) {
        if (this.jobRunner != null) {
            this.jobRunner.setName(newName);
        }
    }

    public void setTooltip(String toolTip) {
    }

    public final IOperationRunner getOperationRunner() {
        return this.getErrorHandlingPart().getOperationRunner();
    }

    public final Composite getParent() {
        return this.getErrorHandlingPart().getNestedControl();
    }

    protected void dispose() {
        if (this.errorPart != null) {
            this.errorPart.dispose();
            this.errorPart = null;
        }
        if (this.resources != null) {
            this.resources.dispose();
            this.resources = null;
        }
        if (this.toolkit != null) {
            this.toolkit = null;
        }
        if (this.jobRunner != null) {
            this.jobRunner.dispose();
        }
        if (this.userJobRunner != null) {
            this.userJobRunner.dispose();
        }
    }

    protected IOperationRunner getParentOperationRunner() {
        if (this.jobRunner == null) {
            this.jobRunner = new JobRunner(false);
        }
        return this.jobRunner;
    }

    protected IOperationRunner getUserOperationRunner() {
        if (this.userJobRunner == null) {
            this.userJobRunner = new JobRunner(true);
        }
        return this.userJobRunner;
    }

    private ErrorHandlingPart getErrorHandlingPart() {
        if (this.errorPart == null) {
            this.errorPart = new ErrorHandlingPart(this.parentControl, WidgetFactoryContext.create(this.getToolkit(), this.getMnemonicGenerator(), this.getParentOperationRunner(), new JobRunner(true)));
        }
        return this.errorPart;
    }

    public final Shell getShell() {
        return this.getParent().getShell();
    }

    public abstract void close();

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
    }

    public Preferences getPreferences() {
        return PreferencesUtil.getEmptyPreferences();
    }

    public boolean hasPreferenceStore() {
        return false;
    }

    public final ResourceManager getResources() {
        if (this.resources == null) {
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resources;
    }

    public void setStatus(IStatus statusMessage) {
    }

    public void setDefaultButton(Button defaultButton) {
        this.defaultButton = defaultButton;
    }

    public WidgetFactoryContext getContext() {
        return WidgetFactoryContext.create(this.toolkit, this.getMnemonicGenerator(), this.getOperationRunner(), this.getUserOperationRunner());
    }

    public IMemento getMemento() {
        return XMLMemento.createWriteRoot((String)"temp");
    }
}

