/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.operations;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class StatusCollector
implements IStatusCollector {
    private Collection<IStatus> problems = new ArrayList<IStatus>();
    private String title;
    private String message;
    private Throwable exception;

    public void reportProblem(IStatus toReport) {
        if (toReport.getSeverity() != 0) {
            this.problems.add(toReport);
        }
    }

    public IStatus getStatus() {
        if (this.problems.isEmpty() && this.exception == null) {
            return Status.OK_STATUS;
        }
        if (this.problems.size() == 1) {
            return this.problems.iterator().next();
        }
        if (this.exception != null) {
            return StatusUtil.newStatus((Object)this, (Throwable)this.exception);
        }
        int severity = 0;
        for (IStatus next : this.problems) {
            if (next.getSeverity() <= severity) continue;
            severity = next.getSeverity();
        }
        IStatus[] problemsArray = this.problems.toArray(new IStatus[this.problems.size()]);
        String statusMessage = this.title != null ? this.title : Messages.StatusCollector_0;
        return new MultiStatus(RepositoryUiPlugin.PLUGIN_ID, 0, problemsArray, statusMessage, null);
    }

    public void setProblemSummary(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public boolean isCustomMessageSet() {
        return this.message != null;
    }

    public String getTitle() {
        if (this.title == null) {
            if (this.getStatus().isOK()) {
                return Messages.StatusCollector_1;
            }
            return Messages.StatusCollector_2;
        }
        return this.title;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getMessage() {
        if (this.message == null) {
            return NLS.bind((String)Messages.StatusCollector_3, (Object)this.getTitle());
        }
        return this.message;
    }

    public void reportException(Throwable exception) {
        this.exception = exception;
    }
}

