/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.operations;

import com.ibm.team.repository.rcp.core.internal.LoggingHelper;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;

public class OperationManager {
    public static void runOperation(String taskName, Operation op) {
        OperationManager.runOperation(taskName, op, false);
    }

    public static void runOperation(String taskName, final Operation op, boolean user) {
        Job theJob = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                StatusCollector collector = new StatusCollector();
                try {
                    op.run(monitor, collector);
                }
                catch (OperationFailedException e) {
                    LoggingHelper.log((String)RepositoryUiPlugin.PLUGIN_ID, (IStatus)e.getReason());
                    return StatusUtil.newStatus((Object)((Object)this), (Throwable)((Object)e));
                }
                return collector.getStatus();
            }
        };
        theJob.setUser(user);
        theJob.schedule();
    }

    public static void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.OperationManager_0);
        }
    }
}

