/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.operations;

import com.ibm.team.foundation.common.internal.util.TeamFoundationException;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JobRunner
implements IOperationRunner {
    private Job theJob;
    private LinkedHashMap<Operation, String> queryNames = new LinkedHashMap();

    public static void enqueue(String taskName, boolean isUser, Operation operation) {
        JobRunner runner = new JobRunner(taskName, isUser);
        runner.enqueue(taskName, operation);
    }

    public JobRunner(boolean isUser) {
        this(Messages.JobRunner_0, isUser);
    }

    public JobRunner(String jobName, boolean isUser) {
        this.theJob = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                StatusCollector collector = new StatusCollector();
                SubMonitor reporter = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        JobRunner.this.run(reporter, collector);
                    }
                    catch (InvocationTargetException e) {
                        IStatus iStatus = StatusUtil.newStatus((Object)((Object)this), (Throwable)e.getTargetException());
                        reporter.done();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    reporter.done();
                    monitor.done();
                }
                IStatus status = collector.getStatus();
                if (status.getSeverity() != 0) {
                    if (JobRunner.this.theJob.isUser()) {
                        JobRunner.this.handleUserError(collector);
                    } else {
                        return status;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.theJob.setUser(isUser);
    }

    protected void handleUserError(StatusCollector collector) {
        if (this.log(collector.getStatus())) {
            IStatus status = collector.getStatus();
            if (status.isMultiStatus() || !collector.isCustomMessageSet()) {
                JFaceUtils.showError(collector.getTitle(), collector.getMessage(), collector.getStatus());
            } else {
                JFaceUtils.showError(collector.getTitle(), collector.getMessage(), null);
            }
        }
    }

    protected boolean log(IStatus status) {
        Throwable t = status.getException();
        if (t != null) {
            boolean expected = this.isExpected(t);
            if (!expected) {
                StatusUtil.log((IStatus)status);
            }
            if (t instanceof TeamOperationCanceledException || t instanceof PermissionDeniedException) {
                return false;
            }
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            boolean logResult = true;
            int i = 0;
            while (i < children.length) {
                logResult &= this.log(children[i]);
                ++i;
            }
            return logResult;
        }
        return true;
    }

    private boolean isExpected(Throwable x) {
        boolean expected = TeamFoundationException.isExpected((Throwable)x);
        return expected;
    }

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchPage page;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            if (workbench.getWorkbenchWindowCount() > 0) {
                window = workbench.getWorkbenchWindows()[0];
            } else {
                return null;
            }
        }
        if ((page = window.getActivePage()) == null) {
            if (window.getPages().length > 0) {
                page = window.getPages()[0];
            } else {
                return null;
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(String taskName, Operation subtask) {
        if (taskName == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<Operation, String> linkedHashMap = this.queryNames;
        synchronized (linkedHashMap) {
            if (this.queryNames.isEmpty()) {
                this.theJob.setName(taskName);
            }
            if (!this.queryNames.containsKey(subtask)) {
                this.queryNames.put(subtask, taskName);
            }
        }
        this.schedule(this.theJob);
    }

    protected void schedule(Job theJob) {
        theJob.schedule();
    }

    public void setName(String name) {
        this.setJobName(name);
    }

    protected void setJobName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.theJob.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(SubMonitor reporter, IStatusCollector problems) throws InvocationTargetException {
        int remain;
        do {
            String nextName;
            Operation next;
            LinkedHashMap<Operation, String> linkedHashMap = this.queryNames;
            synchronized (linkedHashMap) {
                remain = this.queryNames.size();
                if (remain == 0) {
                    break;
                }
                next = this.queryNames.keySet().iterator().next();
                nextName = (String)this.queryNames.remove(next);
            }
            reporter.setWorkRemaining(remain * 100);
            try {
                if (nextName == null) {
                    throw new NullPointerException();
                }
                this.theJob.setName(nextName);
                problems.setProblemSummary(nextName, null);
                reporter.setTaskName("");
                next.run((IProgressMonitor)reporter.newChild(100, 0), problems);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (OperationFailedException e) {
                if (!this.reportProblem(nextName, next, e.getReason())) continue;
                problems.reportProblem(e.getReason());
            }
        } while (remain != 1);
    }

    protected boolean reportProblem(String nextName, Operation next, IStatus reason) {
        return true;
    }

    protected Shell getParentShell() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dequeue(Operation subtask) {
        LinkedHashMap<Operation, String> linkedHashMap = this.queryNames;
        synchronized (linkedHashMap) {
            this.queryNames.remove(subtask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.theJob.cancel();
        LinkedHashMap<Operation, String> linkedHashMap = this.queryNames;
        synchronized (linkedHashMap) {
            this.queryNames.clear();
        }
    }
}

