/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionExtContributionItem;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComparatorSorter;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentTreeContentProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.DirtyIndicationLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.EarlySelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IdentityConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.MenuManagerWithDefaultAdditions;
import com.ibm.team.repository.rcp.ui.internal.viewers.RefreshAction;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleTreeViewer {
    public static final int ALL_LEVELS = -1;
    private TreeViewer viewer;
    ConcurrentTreeContentProvider contentProvider;
    private DirtyIndicationLabelProvider labelProvider;
    private MenuManager popupMenu;
    private Display display;
    private IBusyHandler progress;
    private ITreePathRunnable doubleClickHandler;
    private List<IPartResult> expandListeners = new ArrayList<IPartResult>();
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            List<TreePath> paths;
            ISelection sel = event.getSelection();
            if (SimpleTreeViewer.this.doubleClickHandler != null && !(paths = SimpleTreeViewer.this.getPathsInSelection(sel)).isEmpty()) {
                SimpleTreeViewer.this.doubleClickHandler.run(paths.iterator().next(), SimpleTreeViewer.this.viewer.getControl().getShell());
            }
        }
    };
    private RefreshAction refreshAction;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)sel;
                SimpleTreeViewer.this.refreshAction.setSelection(ss.toList());
            } else {
                SimpleTreeViewer.this.refreshAction.setSelection(Collections.EMPTY_LIST);
            }
        }
    };
    private IViewerLabelProvider standardLabelProvider;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            SimpleTreeViewer.this.disposed();
        }
    };
    private Set<TreePath> pendingExpansions = new HashSet<TreePath>();
    private LinkedList<Object> queuedExpansions = new LinkedList();
    private int expanding = 0;
    private ISetListener addRemoveListener = new ISetListener(){

        public void changed(SetDiff diff) {
            final Collection additions = diff.getAdditions();
            if (!additions.isEmpty()) {
                SWTUtil.greedyExec(Display.getCurrent(), SimpleTreeViewer.this.viewer.getControl(), new Runnable(){

                    public void run() {
                        for (Object next : additions) {
                            List<TreePath> paths = SimpleTreeViewer.this.getPathsToElement(next);
                            for (TreePath nextPath : paths) {
                                if (!SimpleTreeViewer.this.pendingExpansions.contains(nextPath) && (SimpleTreeViewer.this.expansionFilter == null || !SimpleTreeViewer.this.expansionFilter.select(nextPath.getLastSegment()))) continue;
                                SimpleTreeViewer.this.doExpand(nextPath);
                            }
                        }
                    }
                });
            }
        }
    };
    private DelegatingSetWithListeners knownElements = new DelegatingSetWithListeners();
    private final Map<IFilter, FilterAdapter> filterMapping = new HashMap<IFilter, FilterAdapter>();
    private EarlySelectionProvider selectionProvider;
    private IFilter expansionFilter;
    private ITreeProvider treeProvider;
    private IConversion hoverProvider = IdentityConversion.getInstance();
    private SimpleTreeViewerTooltipSupport tooltipSupport;
    private static final String PENDING_NODE = Messages.SimpleTreeViewer_0;

    public SimpleTreeViewer(Tree tree, ITreeProvider provider) {
        this.treeProvider = provider;
        this.viewer = new TreeViewer(tree);
        this.viewer.setUseHashlookup(true);
        this.display = tree.getDisplay();
        this.viewer.addDoubleClickListener(this.doubleClickListener);
        this.viewer.getControl().addDisposeListener(this.disposeListener);
        this.popupMenu = new MenuManagerWithDefaultAdditions();
        ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)this.popupMenu);
        this.viewer.addSelectionChangedListener(this.selectionListener);
        this.popupMenu.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                SimpleTreeViewer.this.popupMenu.getMenu().setVisible(true);
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                SimpleTreeViewer.this.expansionChanged();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                SimpleTreeViewer.this.expansionChanged();
                for (IPartResult next : SimpleTreeViewer.this.expandListeners) {
                    next.setResult(event.getElement());
                }
            }
        });
        this.contentProvider = new ConcurrentTreeContentProvider(provider, PENDING_NODE, false);
        this.contentProvider.addDirtyListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                SimpleTreeViewer.this.updateProgress(property == ConcurrentTreeContentProvider.PROP_DIRTY);
            }
        });
        this.knownElements.setTarget(this.contentProvider.getKnownElements());
        this.knownElements.addListener(this.addRemoveListener);
        this.refreshAction = new RefreshAction(this.contentProvider);
        this.popupMenu.add((IContributionItem)new ActionExtContributionItem(this.refreshAction));
        this.labelProvider = new DirtyIndicationLabelProvider(this.viewer.getControl(), this.contentProvider, null);
        this.labelProvider.setElementToIgnore(PENDING_NODE);
        this.standardLabelProvider = LabelProviders.create(this.knownElements);
        this.setLabelProvider(this.standardLabelProvider);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.selectionProvider = new EarlySelectionProvider((ISelectionProvider)this.viewer, this.knownElements);
        this.tooltipSupport = new SimpleTreeViewerTooltipSupport();
    }

    protected void expansionChanged() {
        if (this.expanding == 0) {
            this.pendingExpansions.clear();
            this.expansionFilter = null;
        }
    }

    protected void disposed() {
        this.knownElements.removeListener(this.addRemoveListener);
        this.popupMenu.dispose();
    }

    public void setTreeProvider(ITreeProvider treeProvider) {
        this.treeProvider = treeProvider;
        int prefetches = this.contentProvider.getMaxPrefetches();
        this.contentProvider = new ConcurrentTreeContentProvider(treeProvider, PENDING_NODE, false);
        this.contentProvider.addDirtyListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                SimpleTreeViewer.this.updateProgress(property == ConcurrentTreeContentProvider.PROP_DIRTY);
            }
        });
        this.knownElements.setTarget(this.contentProvider.getKnownElements());
        this.refreshAction.setContentProvider(this.contentProvider);
        this.labelProvider.setContentProvider(this.contentProvider);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.contentProvider.setMaxPrefetches(prefetches);
    }

    public void setMaxPrefetches(int max) {
        this.contentProvider.setMaxPrefetches(max);
    }

    public void setDoubleClickHandler(ITreePathRunnable runnable) {
        this.doubleClickHandler = runnable;
    }

    protected void updateProgress(boolean b) {
        if (this.progress == null) {
            return;
        }
        if (b) {
            this.progress.setBusy(true);
        } else {
            int dirtyCount = this.contentProvider.getDirtyCount();
            if (dirtyCount <= 0) {
                this.progress.setBusy(false);
            }
        }
    }

    public SimpleTreeViewer(Composite parent, ITreeProvider provider) {
        this(parent, provider, 770);
    }

    public SimpleTreeViewer(Composite parent, ITreeProvider provider, int style) {
        this(new Tree(parent, style), provider);
    }

    public Object getParent(Object node) {
        return this.contentProvider.getParent(node);
    }

    public MenuManager getContextMenu() {
        return this.popupMenu;
    }

    public void setLabelProvider(IViewerLabelProvider lp) {
        if (lp != this.standardLabelProvider) {
            this.standardLabelProvider.dispose();
        }
        this.labelProvider.setLabelProvider(lp);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    public void setSorter(final Comparator comparator) {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Object p = ((ConcurrentTreeContentProvider)SimpleTreeViewer.this.viewer.getContentProvider()).getPendingNode();
                if (o1 == p) {
                    return -1;
                }
                if (o2 == p) {
                    return 1;
                }
                return comparator.compare(o1, o2);
            }
        };
        this.viewer.setSorter((ViewerSorter)new ComparatorSorter(comp));
    }

    private void update(final Object element) {
        SWTUtil.greedyExec(this.display, new Runnable(){

            public void run() {
                if (!SimpleTreeViewer.this.viewer.getControl().isDisposed()) {
                    SimpleTreeViewer.this.viewer.update(element, null);
                }
            }
        });
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public ITreeSelection getSelection() {
        ISelection sel = this.viewer.getSelection();
        if (sel instanceof ITreeSelection) {
            return (ITreeSelection)sel;
        }
        return TreeSelection.EMPTY;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public Tree getTree() {
        return this.viewer.getTree();
    }

    public boolean getExpandedState(TreePath element) {
        return this.viewer.getExpandedState((Object)element) || this.pendingExpansions.contains(element);
    }

    public void expand(Collection<TreePath> treePaths) {
        this.pendingExpansions.clear();
        for (TreePath next : treePaths) {
            this.setExpandedState(next, true);
        }
    }

    public void setExpandedState(TreePath element, boolean newState) {
        ++this.expanding;
        try {
            if (newState) {
                TreePath next = element;
                while (next != null) {
                    this.viewer.setExpandedState((Object)next, newState);
                    this.pendingExpansions.add(next);
                    next = next.getParentPath();
                }
            } else {
                this.viewer.setExpandedState((Object)element, newState);
                this.pendingExpansions.remove(newState);
            }
        }
        finally {
            --this.expanding;
        }
    }

    public void expandMatching(IFilter elementFilter) {
        if (elementFilter != null) {
            ArrayList elements = new ArrayList();
            elements.addAll(this.knownElements.toCollection());
            for (Object next : elements) {
                if (!elementFilter.select(next)) continue;
                List<TreePath> paths = this.getPathsToElement(next);
                for (TreePath nextPath : paths) {
                    this.doExpand(nextPath);
                }
            }
        }
        this.expansionFilter = elementFilter;
    }

    private void doExpand(TreePath elementOrTreePath) {
        ++this.expanding;
        try {
            if (this.expanding == 1) {
                this.viewer.setExpandedState((Object)elementOrTreePath, true);
                while (!this.queuedExpansions.isEmpty()) {
                    this.viewer.setExpandedState(this.queuedExpansions.removeFirst(), true);
                }
            } else {
                this.queuedExpansions.add(elementOrTreePath);
            }
        }
        finally {
            --this.expanding;
        }
    }

    public void toggleExpandedState(TreePath element) {
        this.setExpandedState(element, !this.getExpandedState(element));
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public void refresh() {
        this.viewer.refresh();
        LinkedList<Object> elementsToRefresh = new LinkedList<Object>();
        elementsToRefresh.add(this.getInput());
        while (!elementsToRefresh.isEmpty()) {
            Object next = elementsToRefresh.removeFirst();
            ISetWithListeners knownChildren = this.contentProvider.getChildrenSet(next);
            if (knownChildren == null) continue;
            IRefreshable refreshable = (IRefreshable)Adapters.getAdapter((Object)knownChildren, IRefreshable.class);
            if (refreshable != null) {
                refreshable.refresh();
            }
            elementsToRefresh.addAll(knownChildren.toCollection());
        }
    }

    public void setCellEditor(CellEditor[] editors) {
        this.viewer.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.viewer.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.viewer.setColumnProperties(columnProperties);
    }

    public void editElement(Object element) {
        this.viewer.editElement(element, 0);
    }

    public ISetWithListeners getKnownElements() {
        return this.knownElements;
    }

    public SimpleTreeViewer setProgressService(IBusyHandler progress) {
        this.endProgress();
        this.progress = progress;
        return this;
    }

    private void endProgress() {
        if (this.progress != null) {
            this.progress.setBusy(false);
        }
    }

    public List<TreePath> getPathsInSelection(ISelection selection) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (selection instanceof ITreeSelection) {
            ITreeSelection ts = (ITreeSelection)selection;
            result.addAll((Collection<TreePath>)Arrays.asList(ts.getPaths()));
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            HashSet<TreePath> found = new HashSet<TreePath>();
            for (Object next : ss.toList()) {
                for (TreePath nextPath : this.getPathsToElement(next)) {
                    if (!found.add(nextPath)) continue;
                    result.add(nextPath);
                }
            }
        }
        return result;
    }

    public List<TreePath> getPathsToElement(Object selectedObject) {
        TreePath[] parents = this.contentProvider.getParents(selectedObject);
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        int i = 0;
        while (i < parents.length) {
            TreePath next = parents[i];
            result.add(next.createChildPath(selectedObject));
            ++i;
        }
        return result;
    }

    public void expandAll() {
        this.expandMatching(new IFilter(){

            public boolean select(Object toTest) {
                return true;
            }
        });
    }

    public void addFilter(IFilter filter) {
        FilterAdapter adapter = new FilterAdapter(filter);
        if (this.filterMapping.containsKey(filter)) {
            return;
        }
        this.filterMapping.put(filter, adapter);
        this.viewer.addFilter((ViewerFilter)adapter);
    }

    public void removeFilter(IFilter filter) {
        FilterAdapter adapter = this.filterMapping.remove(filter);
        if (adapter == null) {
            return;
        }
        this.viewer.removeFilter((ViewerFilter)adapter);
    }

    public void selectAndReveal(ITreeSelection ss) {
        TreePath[] paths = ss.getPaths();
        int idx = 0;
        while (idx < paths.length) {
            TreePath nextPath = paths[idx];
            this.setExpandedState(nextPath.getParentPath(), true);
            ++idx;
        }
        this.getSelectionProvider().setSelection((ISelection)ss);
    }

    public ITreeProvider getTreeProvider() {
        return this.treeProvider;
    }

    public Collection<TreePath> getExpandedTreePaths() {
        TreePath[] treePaths = this.viewer.getExpandedTreePaths();
        return Arrays.asList(treePaths);
    }

    public void setHoverProvider(IConversion hoverProvider) {
        if (hoverProvider == null) {
            throw new IllegalArgumentException();
        }
        this.hoverProvider = hoverProvider;
    }

    public void collapseAll() {
        this.expansionFilter = null;
        Collection<TreePath> treePaths = this.getExpandedTreePaths();
        for (TreePath next : treePaths) {
            this.setExpandedState(next, false);
        }
        this.pendingExpansions.clear();
    }

    public void addExpandListener(IPartResult listener) {
        this.expandListeners.add(listener);
    }

    public void removeExpandListener(IPartResult listener) {
        this.expandListeners.remove(listener);
    }

    public ISetWithListeners getKnownChildren(Object parent) {
        return this.contentProvider.getChildrenSet(parent);
    }

    public void selectMatching(IFilter toSelect) {
        this.selectionProvider.setSelection(toSelect);
    }

    class FilterAdapter
    extends ViewerFilter {
        private final IFilter filter;

        public FilterAdapter(IFilter filter) {
            this.filter = filter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element == ((ConcurrentTreeContentProvider)SimpleTreeViewer.this.viewer.getContentProvider()).getPendingNode()) {
                return true;
            }
            return this.filter.select(element);
        }
    }

    private class SimpleTreeViewerTooltipSupport
    extends TooltipSupport {
        public SimpleTreeViewerTooltipSupport() {
            super(SimpleTreeViewer.this.viewer.getControl(), true, false);
        }

        public Object getElement(Control control, int x, int y) {
            Point localCoordinates = new Point(x, y);
            Tree tree = SimpleTreeViewer.this.viewer.getTree();
            TreeItem item = tree.getItem(localCoordinates);
            if (item == null) {
                return null;
            }
            boolean isImageTooltip = item.getImageBounds(0).contains(x, y);
            if (isImageTooltip) {
                this.setPreferredFocusSize(PREFERRED_SIZE);
                Object element = item.getData();
                if (element == null) {
                    return null;
                }
                element = SimpleTreeViewer.this.hoverProvider.createAdapter(element);
                if (element == null) {
                    return null;
                }
                return element;
            }
            return null;
        }
    }
}

