/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComparatorSorter;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentStructuredContentProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.EarlySelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SetWithListenersToRemoveNotifier;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import java.util.Comparator;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class SimpleComboViewer {
    private ComboViewer comboViewer;
    private ConcurrentStructuredContentProvider contentProvider;
    private IBusyHandler progress;
    private IElementRemovedNotifier notifier;
    private EarlySelectionProvider selectionProvider;
    private DelegatingLabelProvider lp = new DelegatingLabelProvider(){

        public void updateLabel(ViewerLabel label, Object element) {
            super.updateLabel(label, element);
        }

        protected void rebroadcastChangeEvent(LabelProviderChangedEvent event) {
            SimpleComboViewer.this.selectionProvider.disableEvents(true);
            try {
                ISelection before = SimpleComboViewer.this.comboViewer.getSelection();
                super.rebroadcastChangeEvent(event);
                ISelection after = SimpleComboViewer.this.comboViewer.getSelection();
                if (!before.equals(after)) {
                    SimpleComboViewer.this.comboViewer.setSelection(before);
                }
            }
            finally {
                SimpleComboViewer.this.selectionProvider.disableEvents(false);
            }
        }
    };

    public SimpleComboViewer(Composite parent) {
        this(parent, 2060);
    }

    public SimpleComboViewer(Composite parent, int flags) {
        Combo combo = new Combo(parent, flags);
        this.comboViewer = new ComboViewer(combo);
        this.comboViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SimpleComboViewer.this.doDispose();
            }
        });
        combo.setVisibleItemCount(15);
        this.comboViewer.setUseHashlookup(true);
        this.contentProvider = new ConcurrentStructuredContentProvider();
        this.comboViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.notifier = new SetWithListenersToRemoveNotifier(this.contentProvider.getKnownElements());
        this.selectionProvider = new EarlySelectionProvider((ISelectionProvider)this.comboViewer, this.contentProvider.getKnownElements());
        this.lp.setLabelProvider(LabelProviders.create(this.notifier));
        this.comboViewer.setLabelProvider((IBaseLabelProvider)this.lp);
    }

    protected void doDispose() {
        this.selectionProvider.dispose();
    }

    public void sortByLabel() {
        this.comboViewer.setSorter(new ViewerSorter());
    }

    public void setLabelProvider(IViewerLabelProvider provider) {
        this.lp.setLabelProvider(provider);
    }

    public SimpleComboViewer setProgressService(IBusyHandler progress) {
        this.endProgress();
        this.progress = progress;
        return this;
    }

    public void setInput(ISetWithListeners input) {
        try {
            this.selectionProvider.disableEvents(true);
            this.comboViewer.setInput((Object)input);
        }
        finally {
            this.selectionProvider.disableEvents(false);
        }
    }

    public void setSelectionCriteria(IFilter selectionCriteria) {
        this.selectionProvider.setSelection(selectionCriteria);
    }

    private void endProgress() {
        if (this.progress != null) {
            this.progress.setBusy(false);
        }
    }

    public ISetWithListeners getKnownElements() {
        return this.contentProvider.getKnownElements();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Control getControl() {
        return this.comboViewer.getControl();
    }

    public IStructuredSelection getSelection() {
        ISelection sel = this.selectionProvider.getSelection();
        if (sel instanceof IStructuredSelection) {
            return (IStructuredSelection)sel;
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelectedElement(Object newSelection) {
        this.selectionProvider.setSelection((ISelection)(newSelection == null ? new StructuredSelection() : new StructuredSelection(newSelection)));
    }

    public void setSorter(Comparator comparator) {
        this.comboViewer.setSorter((ViewerSorter)new ComparatorSorter(comparator));
    }

    public void setEnabled(boolean b) {
        this.comboViewer.getControl().setEnabled(b);
    }
}

