/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import java.util.Collection;
import org.eclipse.swt.widgets.Display;

public class OptionalTreeLevel
extends AbstractSetWithListeners
implements IRefreshable {
    private int updateScheduled = 0;
    private ISetWithListeners toWrap;
    private Object currentNode;
    private DelegatingSetWithListeners delegatingSet = new DelegatingSetWithListeners();
    private ISetListener delegateListener = new ISetListener(){

        public void changed(SetDiff diff) {
            OptionalTreeLevel.this.fireDiff(diff);
        }
    };
    private ITreeProvider treeProvider;
    private ISetListener wrappedListener = new ISetListener(){

        public void changed(SetDiff diff) {
            OptionalTreeLevel.this.updateDelegation();
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        public void setStale(Object staleObject, boolean isStale) {
            OptionalTreeLevel.this.updateStale();
        }
    };

    public OptionalTreeLevel(ISetWithListeners toWrap, ITreeProvider treeProvider) {
        this.toWrap = toWrap;
        this.treeProvider = treeProvider;
        this.delegatingSet.setTarget(EmptySetWithListeners.getInstance());
        this.setStale(true);
    }

    protected void updateStale() {
        if (this.updateScheduled == 0) {
            if (this.isAllocated()) {
                this.setStale(this.delegatingSet.isStale() || this.toWrap.isStale());
            } else {
                this.setStale(true);
            }
        }
    }

    protected void updateDelegation() {
        if (this.updateScheduled > 0) {
            return;
        }
        Collection wrappedContents = this.toWrap.toCollection();
        Object newNode = null;
        if (wrappedContents.size() == 1) {
            newNode = wrappedContents.iterator().next();
        }
        if (newNode != null && newNode == this.currentNode) {
            this.updateStale();
            return;
        }
        ++this.updateScheduled;
        this.setStale(true);
        SWTUtil.greedyExec(Display.getCurrent(), new Runnable(){

            public void run() {
                Collection wrappedContents = OptionalTreeLevel.this.toWrap.toCollection();
                Object newNode = null;
                if (wrappedContents.size() == 1) {
                    newNode = wrappedContents.iterator().next();
                }
                if (newNode != null && newNode == OptionalTreeLevel.this.currentNode) {
                    OptionalTreeLevel optionalTreeLevel = OptionalTreeLevel.this;
                    optionalTreeLevel.updateScheduled = optionalTreeLevel.updateScheduled - 1;
                    OptionalTreeLevel.this.updateStale();
                    return;
                }
                OptionalTreeLevel.this.currentNode = newNode;
                if (wrappedContents.isEmpty()) {
                    OptionalTreeLevel.this.delegatingSet.setTarget(EmptySetWithListeners.getInstance());
                } else if (newNode == null) {
                    OptionalTreeLevel.this.delegatingSet.setTarget(OptionalTreeLevel.this.toWrap);
                } else {
                    OptionalTreeLevel.this.delegatingSet.setTarget(OptionalTreeLevel.this.treeProvider.getChildren(newNode));
                }
                OptionalTreeLevel optionalTreeLevel = OptionalTreeLevel.this;
                optionalTreeLevel.updateScheduled = optionalTreeLevel.updateScheduled - 1;
                OptionalTreeLevel.this.updateStale();
            }
        });
    }

    protected void allocate() {
        this.toWrap.addListener(this.wrappedListener);
        this.delegatingSet.addListener(this.delegateListener);
        this.delegatingSet.addStaleListener(this.staleListener);
        this.toWrap.addStaleListener(this.staleListener);
        super.allocate();
        this.updateDelegation();
    }

    protected void deallocate() {
        this.toWrap.removeListener(this.wrappedListener);
        this.delegatingSet.removeListener(this.delegateListener);
        this.delegatingSet.removeStaleListener(this.staleListener);
        this.toWrap.addStaleListener(this.staleListener);
        super.deallocate();
        this.setStale(true);
    }

    protected Collection computeElements() {
        return this.delegatingSet.toCollection();
    }

    public boolean canRefresh() {
        IRefreshable refreshable = (IRefreshable)Adapters.getAdapter((Object)this.toWrap, IRefreshable.class);
        if (refreshable != null && refreshable.canRefresh()) {
            return true;
        }
        refreshable = (IRefreshable)Adapters.getAdapter((Object)this.delegatingSet.getTarget(), IRefreshable.class);
        return refreshable != null && refreshable.canRefresh();
    }

    public void refresh() {
        IRefreshable refreshable = (IRefreshable)Adapters.getAdapter((Object)this.toWrap, IRefreshable.class);
        if (refreshable != null) {
            refreshable.refresh();
        }
        if ((refreshable = (IRefreshable)Adapters.getAdapter((Object)this.delegatingSet.getTarget(), IRefreshable.class)) != null) {
            refreshable.refresh();
        }
    }
}

