/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.tree.AbstractObservableSet;
import com.ibm.team.repository.rcp.ui.internal.tree.IObservableTree;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;

public class LeafNodesSet
extends AbstractObservableSet
implements IRefreshable {
    private HashSet leafNodes = new HashSet();
    private HashMap mapElementsOntoNodeInfo = new HashMap();
    private IObservableTree tree;
    private Object input;
    private int staleCount = 0;

    public LeafNodesSet(IObservableTree tree) {
        this.tree = tree;
    }

    public LeafNodesSet(Object initialInput, IObservableTree tree) {
        this.tree = tree;
        this.setInput(initialInput);
    }

    private void doSetStale(boolean stale) {
        this.setStale(stale);
    }

    public void processDiff(SetDiff diff) {
        HashSet removals = new HashSet();
        HashSet additions = new HashSet();
        for (Object next : diff.getRemovals()) {
            this.elementRemoved(next, removals);
        }
        for (Object next : diff.getAdditions()) {
            this.elementDiscovered(next, additions);
        }
        HashSet newRemovals = new HashSet();
        newRemovals.addAll(removals);
        newRemovals.removeAll(additions);
        HashSet newAdditions = new HashSet();
        newAdditions.addAll(additions);
        newAdditions.removeAll(removals);
        this.leafNodes.addAll(newAdditions);
        this.leafNodes.removeAll(newRemovals);
        if (!newAdditions.isEmpty() || !newRemovals.isEmpty()) {
            this.setStale(this.staleCount > 0);
            this.fireSetChange(Diffs.createSetDiff(newAdditions, newRemovals));
        }
    }

    public void setInput(Object input) {
        Set<Object> removals = Collections.EMPTY_SET;
        Set<Object> additions = Collections.EMPTY_SET;
        if (this.input != null) {
            removals = Collections.singleton(this.input);
        } else if (input != null) {
            additions = Collections.singleton(input);
        }
        this.input = input;
        this.processDiff(Diffs.createSetDiff(additions, removals));
    }

    private void elementRemoved(Object input2, Set removals) {
        NodeInfo newNode = (NodeInfo)this.mapElementsOntoNodeInfo.get(input2);
        if (newNode != null) {
            NodeInfo nodeInfo = newNode;
            nodeInfo.count = nodeInfo.count - 1;
            if (newNode.count == 0) {
                this.mapElementsOntoNodeInfo.remove(input2);
                if (newNode.children != null) {
                    for (Object next : newNode.children) {
                        this.elementRemoved(next, removals);
                    }
                    newNode.children.dispose();
                } else {
                    removals.add(input2);
                }
            }
        }
    }

    private void elementDiscovered(Object input2, HashSet additions) {
        NodeInfo newNode = (NodeInfo)this.mapElementsOntoNodeInfo.get(input2);
        if (newNode == null) {
            newNode = new NodeInfo(input2);
            this.mapElementsOntoNodeInfo.put(input2, newNode);
            if (newNode.children != null) {
                for (Object next : newNode.children) {
                    this.elementDiscovered(next, additions);
                }
            } else {
                additions.add(input2);
            }
        } else {
            NodeInfo nodeInfo = newNode;
            nodeInfo.count = nodeInfo.count + 1;
        }
    }

    protected Set getWrappedSet() {
        return this.leafNodes;
    }

    public Object getElementType() {
        return Object.class;
    }

    public void dispose() {
        for (NodeInfo next : this.mapElementsOntoNodeInfo.values()) {
            if (next.children == null) continue;
            next.dispose();
        }
        this.mapElementsOntoNodeInfo.clear();
        this.leafNodes.clear();
        super.dispose();
    }

    public boolean canRefresh() {
        return true;
    }

    public void refresh() {
        for (NodeInfo next : this.mapElementsOntoNodeInfo.values()) {
            if (!(next.children instanceof IRefreshable)) continue;
            IRefreshable refreshable = (IRefreshable)next.children;
            refreshable.refresh();
        }
    }

    private class NodeInfo
    implements IStaleListener,
    ISetChangeListener {
        private int count;
        private Object element;
        IObservableSet children;
        private boolean wasStale = false;

        public NodeInfo(Object input2) {
            this.element = input2;
            this.children = LeafNodesSet.this.tree.createChildSet(this.element);
            if (this.children != null) {
                this.children.addStaleListener((IStaleListener)this);
                this.children.addSetChangeListener((ISetChangeListener)this);
                this.handleStale(new StaleEvent((IObservable)this.children));
            }
            this.count = 1;
        }

        public void handleSetChange(SetChangeEvent event) {
            IObservableSet source = event.getObservableSet();
            SetDiff diff = event.diff;
            boolean oldStale = LeafNodesSet.this.isStale();
            this.handleStale(new StaleEvent((IObservable)source));
            LeafNodesSet.this.processDiff(diff);
            if (oldStale && !LeafNodesSet.this.isStale() && diff.getAdditions().isEmpty() && diff.getRemovals().isEmpty()) {
                LeafNodesSet.this.fireSetChange(diff);
            }
        }

        public void handleStale(StaleEvent event) {
            if (this.wasStale != this.children.isStale()) {
                if (this.wasStale) {
                    LeafNodesSet leafNodesSet = LeafNodesSet.this;
                    leafNodesSet.staleCount = leafNodesSet.staleCount - 1;
                } else {
                    LeafNodesSet leafNodesSet = LeafNodesSet.this;
                    leafNodesSet.staleCount = leafNodesSet.staleCount + 1;
                }
                this.wasStale = !this.wasStale;
            }
            LeafNodesSet.this.doSetStale(LeafNodesSet.this.staleCount > 0);
        }

        public void dispose() {
            if (this.children != null) {
                this.children.dispose();
                this.children = null;
                if (this.wasStale) {
                    LeafNodesSet leafNodesSet = LeafNodesSet.this;
                    leafNodesSet.staleCount = leafNodesSet.staleCount - 1;
                }
            }
        }
    }
}

