/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EmbeddedMenu
extends MenuManager {
    private boolean dirty = true;
    private boolean eventFired = false;
    private boolean computingVisibility = false;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            EmbeddedMenu.this.dirty = true;
            EmbeddedMenu.this.fireAboutToShow();
        }
    };
    private IContributionItem[] oldItems;
    private List listeners = new ArrayList();

    public EmbeddedMenu() {
    }

    public EmbeddedMenu(String id) {
        super(id);
    }

    public void add(IContributionItem item) {
        super.add(item);
    }

    public void add(IAction action) {
        super.add(action);
    }

    public void addMenuListener(IMenuListener listener) {
        this.listeners.add(listener);
    }

    public void removeMenuListener(IMenuListener listener) {
        this.listeners.remove(listener);
    }

    public void fill(Menu menu, int index) {
        if (index == -1) {
            index = menu.getItemCount();
        }
        if (!this.dirty && menu.getParentItem() != null) {
            new MenuItem(menu, 0, index);
            return;
        }
        IContributionItem separator = null;
        boolean isFirst = true;
        IContributionItem[] items = this.getContributionItemsToFill();
        int i = 0;
        while (i < items.length) {
            int numAdded;
            int newItemCount;
            IContributionItem item = items[i];
            int oldItemCount = menu.getItemCount();
            if (item.isVisible()) {
                if (item.isSeparator()) {
                    separator = item;
                } else {
                    if (separator != null) {
                        if (!isFirst) {
                            separator.fill(menu, index);
                            newItemCount = menu.getItemCount();
                            numAdded = newItemCount - oldItemCount;
                            index += numAdded;
                            oldItemCount = menu.getItemCount();
                        }
                        separator = null;
                    }
                    isFirst = false;
                    item.fill(menu, index);
                }
            }
            newItemCount = menu.getItemCount();
            numAdded = newItemCount - oldItemCount;
            index += numAdded;
            ++i;
        }
        this.dirty = false;
    }

    private void fireIfNecessary() {
        if (this.eventFired) {
            return;
        }
        this.fireAboutToShow();
    }

    protected IContributionItem[] getContributionItems() {
        return this.getItems();
    }

    private IContributionItem[] getContributionItemsToFill() {
        if (this.oldItems != null) {
            int i = 0;
            while (i < this.oldItems.length) {
                IContributionItem oldItem = this.oldItems[i];
                oldItem.dispose();
                ++i;
            }
            this.oldItems = null;
        }
        this.oldItems = this.getContributionItems();
        return this.oldItems;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isVisible() {
        if (this.computingVisibility) {
            return true;
        }
        try {
            this.computingVisibility = true;
            this.fireIfNecessary();
            boolean bl = super.isVisible();
            return bl;
        }
        finally {
            this.computingVisibility = false;
        }
    }

    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
        this.eventFired = false;
    }

    private void fireAboutToShow() {
        this.eventFired = true;
        IMenuListener[] l = this.listeners.toArray(new IMenuListener[this.listeners.size()]);
        int i = 0;
        while (i < l.length) {
            IMenuListener listener = l[i];
            listener.menuAboutToShow((IMenuManager)this);
            ++i;
        }
    }
}

