/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentTreeContentProvider;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class DirtyIndicationLabelProvider
extends BaseLabelProvider {
    private ConcurrentTreeContentProvider cp;
    private final Color busy;
    private final Color black;
    private IChangeListener dirtyListener;
    private IViewerLabelProvider wrapped;
    private Color grayColor;
    Object ignoredElement;
    private ILabelProviderListener nestedListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            if (event.getElements() == null) {
                DirtyIndicationLabelProvider.this.fireAllElementsChangedEvent();
            } else {
                DirtyIndicationLabelProvider.this.fireChangeEvent(Arrays.asList(event.getElements()));
            }
        }
    };

    public DirtyIndicationLabelProvider(Control context, ConcurrentTreeContentProvider cp, IViewerLabelProvider toConvert) {
        this(cp, toConvert, context.getForeground(), context.getBackground());
    }

    public void setElementToIgnore(Object element) {
        this.ignoredElement = element;
    }

    public DirtyIndicationLabelProvider(ConcurrentTreeContentProvider cp, IViewerLabelProvider convert, Color foreground, Color background) {
        this.cp = cp;
        RGB fg = foreground.getRGB();
        RGB bg = background.getRGB();
        RGB grayed = SWTUtil.mix(fg, bg, 0.5);
        this.busy = this.grayColor = new Color((Device)Display.getCurrent(), grayed);
        this.black = foreground;
        this.wrapped = convert;
        if (this.wrapped != null) {
            this.wrapped.addListener(this.nestedListener);
        }
        this.dirtyListener = new IChangeListener(){

            public void changed(Object source, Object property) {
                DirtyIndicationLabelProvider.this.dirtyChanged(source);
            }
        };
        cp.addDirtyListener(this.dirtyListener);
    }

    public void setLabelProvider(IViewerLabelProvider provider) {
        if (this.wrapped != null) {
            this.wrapped.removeListener(this.nestedListener);
        }
        this.wrapped = provider;
        if (this.wrapped != null) {
            this.wrapped.addListener(this.nestedListener);
        }
    }

    public IViewerLabelProvider getNestedLabelProvider() {
        return this.wrapped;
    }

    private void dirtyChanged(Object element) {
        this.fireChangeEvent(Collections.singleton(element));
    }

    public void updateLabel(ViewerLabel label, Object element) {
        label.setForeground(this.black);
        if (element == this.ignoredElement) {
            label.setText(element.toString());
            return;
        }
        this.wrapped.updateLabel(label, element);
        if (this.cp.isDirty(element)) {
            label.setForeground(this.busy);
        }
    }

    public void dispose() {
        if (this.wrapped != null) {
            this.wrapped.removeListener(this.nestedListener);
            this.wrapped.dispose();
        }
        this.cp.removeDirtyListener(this.dirtyListener);
        super.dispose();
        this.grayColor.dispose();
    }

    public void setContentProvider(ConcurrentTreeContentProvider contentProvider) {
        this.cp.removeDirtyListener(this.dirtyListener);
        this.cp = contentProvider;
        this.cp.addDirtyListener(this.dirtyListener);
    }
}

