/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingSetWithListeners<T>
extends AbstractSetWithListeners<T> {
    private ISetWithListeners<T> target;
    private ISetListener<T> targetListener = new ISetListener<T>(){

        @Override
        public void changed(SetDiff<T> diff) {
            DelegatingSetWithListeners.this.fireDiff(diff);
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        public void setStale(Object staleObject, boolean isStale) {
            DelegatingSetWithListeners.this.setStale(isStale);
        }
    };

    public void setTarget(ISetWithListeners<T> realTarget) {
        if (this.target == realTarget) {
            return;
        }
        ISetWithListeners<T> oldTarget = this.target;
        if (this.isAllocated()) {
            if (oldTarget != null) {
                oldTarget.removeListener(this.targetListener);
                oldTarget.removeStaleListener(this.staleListener);
            }
            if (realTarget != null) {
                realTarget.addListener(this.targetListener);
                realTarget.addStaleListener(this.staleListener);
                if (realTarget.isStale()) {
                    this.setStale(true);
                }
            }
            if (oldTarget != null) {
                if (realTarget != null) {
                    this.fireDiff(SetDiff.computeDiff(this.target.toCollection(), realTarget.toCollection()));
                } else {
                    this.fireCollectionRemoved(oldTarget.toCollection());
                }
            } else if (realTarget != null) {
                this.fireCollectionAdded(realTarget.toCollection());
            }
            if (realTarget == null || !realTarget.isStale()) {
                this.setStale(false);
            }
        } else {
            this.setStale(realTarget != null);
        }
        this.target = realTarget;
    }

    @Override
    protected void allocate() {
        if (this.target != null) {
            this.target.addListener(this.targetListener);
            this.target.addStaleListener(this.staleListener);
            this.setStale(this.target.isStale());
        }
        super.allocate();
    }

    @Override
    protected void deallocate() {
        if (this.target != null) {
            this.target.removeListener(this.targetListener);
            this.target.removeStaleListener(this.staleListener);
            this.setStale(true);
        }
        super.deallocate();
    }

    @Override
    protected Collection<T> computeElements() {
        if (this.target == null) {
            return Collections.EMPTY_LIST;
        }
        return this.target.toCollection();
    }

    public ISetWithListeners getTarget() {
        return this.target;
    }
}

