/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredSet<T>
extends AbstractSetWithListeners<T>
implements IRefreshable {
    private ISetWithListeners<T> toWrap;
    private Collection<T> oldContents = null;
    private boolean isDeferred;
    private boolean deferRequested = false;
    private Runnable deferRunnable = new Runnable(){

        public void run() {
            if (DeferredSet.this.deferRequested) {
                DeferredSet.this.makeDeferred(true);
            }
        }
    };
    private ISetListener<T> addRemoveListener = new ISetListener<T>(){

        @Override
        public void changed(SetDiff<T> diff) {
            if (DeferredSet.this.deferRequested) {
                SWTUtil.runOnce(DeferredSet.this.getRealm(), DeferredSet.this.deferRunnable);
            }
            DeferredSet.this.fireDiff(diff);
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        public void setStale(Object staleObject, boolean isStale) {
            DeferredSet.this.setStale(isStale);
        }
    };

    public DeferredSet(ISetWithListeners<T> toWrap) {
        this.toWrap = toWrap;
        this.isDeferred = false;
    }

    protected void startDeferred() {
        this.oldContents = new ArrayList<T>();
        this.oldContents.addAll(this.toWrap.toCollection());
        this.toWrap.removeListener(this.addRemoveListener);
        this.toWrap.removeStaleListener(this.staleListener);
    }

    public void setDeferred(boolean isDeferred) {
        if (isDeferred) {
            this.deferRequested = true;
        } else {
            this.deferRequested = false;
            this.makeDeferred(false);
        }
    }

    private void makeDeferred(boolean isDeferred) {
        if (isDeferred != this.isDeferred) {
            this.isDeferred = isDeferred;
            this.deferRequested = false;
            if (this.isAllocated()) {
                if (isDeferred) {
                    this.startDeferred();
                } else {
                    this.stopDeferred();
                }
            }
        }
    }

    private void stopDeferred() {
        this.toWrap.addListener(this.addRemoveListener);
        this.toWrap.addStaleListener(this.staleListener);
        Collection<T> newContents = this.toWrap.toCollection();
        SetDiff diff = SetDiff.computeDiff(this.oldContents, newContents);
        this.oldContents = null;
        this.fireDiff(diff);
        this.setStale(this.toWrap.isStale());
    }

    @Override
    protected Collection<T> computeElements() {
        if (this.oldContents != null) {
            return this.oldContents;
        }
        return this.toWrap.toCollection();
    }

    @Override
    protected void allocate() {
        if (!this.isDeferred) {
            this.toWrap.addListener(this.addRemoveListener);
            this.toWrap.addStaleListener(this.staleListener);
            this.setStale(this.toWrap.isStale());
        }
        super.allocate();
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        if (this.oldContents != null) {
            this.oldContents = null;
            this.setStale(true);
        } else {
            this.toWrap.removeListener(this.addRemoveListener);
            this.toWrap.removeStaleListener(this.staleListener);
        }
    }

    public boolean isDeferred() {
        return this.isDeferred;
    }

    @Override
    public boolean canRefresh() {
        IRefreshable refreshable = (IRefreshable)Adapters.getAdapter(this.toWrap, IRefreshable.class);
        return refreshable != null && refreshable.canRefresh();
    }

    @Override
    public void refresh() {
        IRefreshable refreshable = (IRefreshable)Adapters.getAdapter(this.toWrap, IRefreshable.class);
        if (refreshable != null) {
            refreshable.refresh();
        }
    }
}

