/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.CachingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import java.util.ArrayList;
import org.eclipse.core.databinding.observable.Realm;

public class CrossRealmSet
extends CachingSet {
    private ISetWithListeners originalSet;
    private Realm originalRealm;
    protected ISetListener setListener = new ISetListener(){

        public void changed(SetDiff diff) {
            CrossRealmSet.this.updateSet();
        }
    };
    protected IStaleListener staleListener = new IStaleListener(){

        public void setStale(Object staleObject, boolean isStale) {
            CrossRealmSet.this.updateSet();
        }
    };

    public CrossRealmSet(Realm realm, ISetWithListeners toObserve) {
        super(realm);
        this.originalSet = toObserve;
        this.originalRealm = toObserve.getRealm();
        this.setStale(true);
    }

    protected void updateSet() {
        if (!this.originalRealm.isCurrent()) {
            throw new IllegalStateException("Wrong realm");
        }
        final boolean isStale = this.originalSet.isStale();
        final ArrayList originalContents = new ArrayList();
        originalContents.addAll(this.originalSet.toCollection());
        this.getRealm().asyncExec(new Runnable(){

            public void run() {
                CrossRealmSet.this.setContents(originalContents);
                if (CrossRealmSet.this.isAllocated()) {
                    CrossRealmSet.this.setStale(isStale);
                }
            }
        });
    }

    protected void allocate() {
        super.allocate();
        this.originalRealm.asyncExec(new Runnable(){

            public void run() {
                CrossRealmSet.this.originalSet.addStaleListener(CrossRealmSet.this.staleListener);
                CrossRealmSet.this.originalSet.addListener(CrossRealmSet.this.setListener);
                CrossRealmSet.this.updateSet();
            }
        });
    }

    protected void deallocate() {
        super.deallocate();
        this.originalRealm.asyncExec(new Runnable(){

            public void run() {
                CrossRealmSet.this.originalSet.removeStaleListener(CrossRealmSet.this.staleListener);
                CrossRealmSet.this.originalSet.removeListener(CrossRealmSet.this.setListener);
            }
        });
        this.setStale(true);
    }
}

