/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class ConvertingSelectionProvider
extends AbstractSelectionProvider {
    private IDynamicFunction converter;
    private ISelectionProvider input;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = event.getSelection();
            ConvertingSelectionProvider.this.fireSelectionChangedEvent(ConvertingSelectionProvider.this.convertSelection(sel));
        }
    };

    public ConvertingSelectionProvider(ISelectionProvider input, IDynamicFunction converter) {
        this.converter = converter;
        this.input = input;
    }

    protected void allocate() {
        this.input.addSelectionChangedListener(this.selectionChangedListener);
    }

    protected void deallocate() {
        this.input.removeSelectionChangedListener(this.selectionChangedListener);
    }

    public ISelection getSelection() {
        ISelection originalSelection = this.input.getSelection();
        return this.convertSelection(originalSelection);
    }

    private ISelection convertSelection(ISelection originalSelection) {
        if (originalSelection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)originalSelection;
            ArrayList elements = new ArrayList();
            for (Object next : ss) {
                Object converted = this.converter.computeResult(next);
                if (converted == null) continue;
                elements.add(converted);
            }
            return new StructuredSelection(elements);
        }
        return originalSelection;
    }

    public void setSelection(ISelection selection) {
    }
}

