/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class ConcurrentStructuredContentProvider
implements IStructuredContentProvider {
    private ISetWithListeners set = EmptySetWithListeners.getInstance();
    private Display display;
    private Viewer viewer;
    private IFilter filter = AcceptAllFilter.getInstance();
    private KnownElementsSet elements = new KnownElementsSet();
    private ISetListener listener = new ISetListener(){

        public void changed(SetDiff diff) {
            if (ConcurrentStructuredContentProvider.this.isDisposed()) {
                return;
            }
            Collection added = diff.getAdditions();
            Collection removed = diff.getRemovals();
            ArrayList filtered = new ArrayList();
            for (Object object : added) {
                if (!ConcurrentStructuredContentProvider.this.filter.select(object)) continue;
                filtered.add(object);
            }
            ConcurrentStructuredContentProvider.this.doAdd(filtered.toArray());
            ConcurrentStructuredContentProvider.this.doRemove(removed.toArray());
        }
    };
    private Method addMethod;
    private Method removeMethod;
    private IBusyHandler progressService;
    private IStaleListener staleListener = new IStaleListener(){

        public void setStale(Object staleObject, boolean isStale) {
            if (isStale) {
                ConcurrentStructuredContentProvider.this.startProgress();
            } else {
                ConcurrentStructuredContentProvider.this.endProgress();
            }
        }
    };

    public ConcurrentStructuredContentProvider setProgressService(IBusyHandler progress) {
        this.endProgress();
        this.progressService = progress;
        return this;
    }

    private void endProgress() {
        if (this.progressService != null) {
            this.progressService.setBusy(false);
        }
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = this.set.toArray();
        return result;
    }

    private void doAdd(Object[] toAdd) {
        if (toAdd.length > 0) {
            this.viewer.getSelection();
            try {
                this.addMethod.invoke((Object)this.viewer, new Object[]{toAdd});
            }
            catch (IllegalArgumentException e) {
                RepositoryUiPlugin.log(e);
            }
            catch (IllegalAccessException e) {
                RepositoryUiPlugin.log(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                RepositoryUiPlugin.log(e);
            }
            this.viewer.getSelection();
            this.elements.doFireAdd(toAdd);
        }
    }

    private void doRemove(Object[] removed) {
        if (removed.length > 0) {
            try {
                this.removeMethod.invoke((Object)this.viewer, new Object[]{removed});
            }
            catch (IllegalArgumentException e) {
                RepositoryUiPlugin.log(e);
            }
            catch (IllegalAccessException e) {
                RepositoryUiPlugin.log(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                RepositoryUiPlugin.log(e);
            }
            this.elements.doFireRemove(removed);
        }
    }

    public ISetWithListeners getKnownElements() {
        return this.elements;
    }

    public void dispose() {
        this.endProgress();
        this.setInput(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.display = viewer.getControl().getDisplay();
        this.viewer = viewer;
        try {
            this.addMethod = viewer.getClass().getMethod("add", Object[].class);
            this.removeMethod = viewer.getClass().getMethod("remove", Object[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("This content provider only works with viewers that have an add(Object[]) method and a remove(Object[]) method", e);
        }
        this.setInput((ISetWithListeners)newInput);
    }

    private void setInput(ISetWithListeners newSet) {
        if (newSet == null) {
            newSet = EmptySetWithListeners.getInstance();
        }
        this.endProgress();
        if (this.set != null) {
            this.set.removeListener(this.listener);
            this.set.removeStaleListener(this.staleListener);
            this.endProgress();
        }
        SetDiff diff = SetDiff.computeDiff(this.set.toCollection(), newSet.toCollection());
        this.set = newSet;
        this.elements.doFireDiff(diff);
        if (this.set != null) {
            this.set.addListener(this.listener);
            this.set.addStaleListener(this.staleListener);
            if (this.set.isStale()) {
                this.startProgress();
            }
        }
    }

    private void startProgress() {
        if (this.progressService != null) {
            this.progressService.setBusy(false);
        }
    }

    private boolean isDisposed() {
        return this.viewer.getControl() == null || this.viewer.getControl().isDisposed();
    }

    private class KnownElementsSet
    extends AbstractSetWithListeners {
        private KnownElementsSet() {
        }

        protected Collection computeElements() {
            return ConcurrentStructuredContentProvider.this.set.toCollection();
        }

        public void doFireDiff(SetDiff diff) {
            this.fireDiff(diff);
        }

        public void doFireAdd(Object[] toAdd) {
            if (this.isAllocated() && toAdd.length > 0) {
                HashSet toFire = new HashSet(Arrays.asList(toAdd));
                this.doFireDiff(SetDiff.createAddition(toFire));
            }
        }

        public void doFireRemove(Object[] toRemove) {
            if (this.isAllocated() && toRemove.length > 0) {
                HashSet toFire = new HashSet(Arrays.asList(toRemove));
                this.doFireDiff(SetDiff.createRemoval(toFire));
            }
        }
    }
}

