/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.viewers.TableViewerColumn;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColumnData<T> {
    private static final String POSITION = "position";
    private Table table;
    private TableViewerColumn<T> column;
    private TableColumn swtWidget;
    ResourceManager resourceMgr;
    IViewerLabelProvider labelProvider;
    private int size;
    private String id;
    private boolean visible;
    private int persistedPosition;
    private SelectionListener listener;

    public ColumnData(TableViewerColumn col, Table table, Preferences toLoad, String id, int defaultPosition, SelectionListener selectionListener) {
        this.listener = selectionListener;
        this.column = col;
        this.table = table;
        this.resourceMgr = new LocalResourceManager(JFaceResources.getResources());
        boolean isVisible = true;
        this.id = id;
        this.size = col.getSizing().getWidth();
        if (toLoad != null) {
            if (this.size != -1) {
                isVisible = toLoad.getBoolean("visible", isVisible);
                int newSize = toLoad.getInt("size", this.size);
                if (newSize > 0) {
                    this.size = newSize;
                }
            }
            this.persistedPosition = toLoad.getInt(POSITION, defaultPosition);
        } else {
            this.persistedPosition = defaultPosition;
        }
        if (this.size != -1) {
            int newPosition = this.computePosition(this.persistedPosition);
            this.swtWidget = new TableColumn(table, this.column.getSizing().getAlignment(), newPosition);
            this.swtWidget.setData(this.getClass().getName(), (Object)this);
            ImageDescriptor descriptor = this.column.getHeaderImage();
            if (descriptor != null) {
                this.swtWidget.setImage(this.resourceMgr.createImageWithDefault(descriptor));
            }
            this.swtWidget.setText(this.column.getHeaderText());
            this.swtWidget.addSelectionListener(this.listener);
            this.swtWidget.setMoveable(this.column.getSizing().isMoveable());
            if (isVisible) {
                this.swtWidget.setResizable(this.column.getSizing().isResizable());
                this.swtWidget.setWidth(this.size);
            } else {
                this.swtWidget.setWidth(0);
                this.swtWidget.setResizable(false);
            }
            this.visible = isVisible;
        }
        this.labelProvider = this.column.getLabelProvider();
    }

    public String getId() {
        return this.id;
    }

    public Comparator getComparator() {
        return this.column.getComparator();
    }

    public void save(Preferences toSave) {
        if (this.size != -1) {
            toSave.putBoolean("visible", this.isVisible());
            if (this.swtWidget != null && !this.swtWidget.isDisposed()) {
                int width = this.swtWidget.getWidth();
                if (width <= 0) {
                    width = this.size;
                }
                toSave.putInt("size", width);
                toSave.putInt(POSITION, this.getCurrentPosition());
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        if (visible) {
            if (this.swtWidget != null) {
                this.swtWidget.setResizable(this.column.getSizing().isResizable());
                this.swtWidget.setWidth(this.size);
            }
        } else if (this.swtWidget != null) {
            this.size = this.swtWidget.getWidth();
            this.swtWidget.setResizable(false);
            this.swtWidget.setWidth(0);
        }
        this.visible = visible;
    }

    private int getCurrentPosition() {
        TableColumn[] existingColumns = this.table.getColumns();
        int[] order = this.table.getColumnOrder();
        int idx = 0;
        while (idx < order.length) {
            int nextId = order[idx];
            TableColumn next = existingColumns[nextId];
            if (next == this.swtWidget) {
                return idx;
            }
            ++idx;
        }
        return this.persistedPosition;
    }

    private int computePosition(int persistedPosition) {
        TableColumn[] existingColumns = this.table.getColumns();
        int[] order = this.table.getColumnOrder();
        int idx = 0;
        while (idx < order.length) {
            int nextId = order[idx];
            TableColumn next = existingColumns[nextId];
            ColumnData cd = (ColumnData)next.getData(this.getClass().getName());
            if (cd.persistedPosition > persistedPosition) {
                return idx;
            }
            ++idx;
        }
        return existingColumns.length;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void dispose() {
        if (this.swtWidget != null) {
            this.persistedPosition = this.getCurrentPosition();
            this.size = this.swtWidget.getWidth();
            this.swtWidget.removeSelectionListener(this.listener);
            this.table.setRedraw(false);
            try {
                this.swtWidget.dispose();
            }
            finally {
                this.table.setRedraw(true);
            }
            this.swtWidget = null;
        }
        this.labelProvider = null;
        this.resourceMgr.dispose();
    }

    public TableViewerColumn<T> getColumn() {
        return this.column;
    }

    public TableColumn getSwtWidget() {
        return this.swtWidget;
    }
}

