/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingSet<T>
extends AbstractSetWithListeners<T> {
    private Set<T> cachedResult = new HashSet<T>();

    public CachingSet() {
    }

    public CachingSet(Realm targetRealm) {
        super(targetRealm);
    }

    @Override
    protected final Collection<T> computeElements() {
        return this.cachedResult;
    }

    protected final void setContents(Collection<T> result) {
        this.checkThread();
        SetDiff diff = SetDiff.computeDiff(this.cachedResult, result);
        this.cachedResult.clear();
        this.cachedResult.addAll(result);
        this.fireDiff(diff);
    }

    protected final void addElements(Collection<T> toAdd) {
        this.checkThread();
        if (toAdd.isEmpty()) {
            return;
        }
        ArrayList<T> added = new ArrayList<T>(toAdd.size());
        for (T o : toAdd) {
            if (!this.cachedResult.add(o)) continue;
            added.add(o);
        }
        if (!added.isEmpty()) {
            this.fireCollectionAdded(added);
        }
    }

    protected final void removeElements(Collection<T> toRemove) {
        this.checkThread();
        if (toRemove.isEmpty()) {
            return;
        }
        ArrayList<T> removed = new ArrayList<T>(toRemove.size());
        for (T o : toRemove) {
            if (!this.cachedResult.remove(o)) continue;
            removed.add(o);
        }
        if (!removed.isEmpty()) {
            this.fireCollectionRemoved(removed);
        }
    }

    protected final void asyncSetContents(final Collection<T> result) {
        SWTUtil.greedyExec(this.getRealm(), new Runnable(){

            public void run() {
                CachingSet.this.setContents(result);
            }
        });
    }

    protected final void asyncAddElements(final Collection<T> toAdd) {
        if (toAdd.isEmpty()) {
            return;
        }
        SWTUtil.greedyExec(this.getRealm(), new Runnable(){

            public void run() {
                CachingSet.this.addElements(toAdd);
            }
        });
    }

    protected final void asyncRemoveElements(final Collection<T> toRemove) {
        if (toRemove.isEmpty()) {
            return;
        }
        SWTUtil.greedyExec(this.getRealm(), new Runnable(){

            public void run() {
                CachingSet.this.removeElements(toRemove);
            }
        });
    }
}

