/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.viewers.ChoiceEnumeration;
import com.ibm.team.repository.rcp.ui.internal.viewers.ChoiceValue;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ButtonBar {
    private Button[] buttons;
    private boolean vertical;
    SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            ButtonBar.this.buttonPressed(event.widget.getData());
        }
    };
    IPartResult resultListener;
    private Composite composite;
    private Composite alignmentComposite;
    private WidgetToolkit toolkit = null;

    public ButtonBar(Composite parent, ChoiceEnumeration buttons, IPartResult result) {
        this(parent, buttons, result, false);
    }

    public ButtonBar(Composite parent, ChoiceEnumeration buttons, IPartResult result, boolean vertical) {
        this(result, vertical);
        this.createButtonBar(parent, buttons, new MnemonicGenerator(false));
    }

    public ButtonBar(Composite parent, ChoiceEnumeration buttons, IPartResult result, WidgetToolkit toolkit, boolean vertical) {
        this(parent, buttons, result, toolkit, new MnemonicGenerator(false), vertical);
    }

    public ButtonBar(Composite parent, ChoiceEnumeration buttons, IPartResult result, WidgetToolkit toolkit, MnemonicGenerator generator, boolean vertical) {
        this(result, vertical);
        this.toolkit = toolkit;
        this.createButtonBar(parent, buttons, generator);
    }

    public ButtonBar(Composite parent, ChoiceEnumeration buttons, IPartResult result, WidgetFactoryContext context, boolean vertical) {
        this(parent, buttons, result, context.getToolkit(), context.getMnemonics(), vertical);
    }

    protected ButtonBar(IPartResult result, boolean vertical) {
        this.vertical = vertical;
        this.resultListener = result;
    }

    public Button[] getButtons() {
        return this.buttons;
    }

    private void buttonPressed(Object data) {
        this.resultListener.setResult(data);
    }

    public final Control getControl() {
        return this.composite;
    }

    public final Button getButton(Object value) {
        int i = 0;
        while (i < this.buttons.length) {
            Button next = this.buttons[i];
            if (next.getData() == value) {
                return next;
            }
            ++i;
        }
        return null;
    }

    protected Composite createComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        result.setBackground(parent.getBackground());
        return result;
    }

    protected final Control createButtonBar(Composite parent, ChoiceEnumeration buttons, MnemonicGenerator generator) {
        this.composite = this.createComposite(parent);
        this.alignmentComposite = this.createComposite(this.composite);
        this.composite.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return ButtonBar.this.alignmentComposite.computeSize(wHint, hHint, flushCache);
            }

            protected void layout(Composite composite, boolean flushCache) {
                Point compositeSize = ButtonBar.this.alignmentComposite.computeSize(-1, -1, flushCache);
                Rectangle outerBounds = composite.getClientArea();
                ButtonBar.this.alignmentComposite.setBounds(outerBounds.width - compositeSize.x, 0, compositeSize.x, compositeSize.y);
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(this.vertical ? 1 : 0).spacing(LayoutConstants.getSpacing()).equalWidth(true).applyTo(this.alignmentComposite);
        this.createButtonsForButtonBar(this.alignmentComposite, buttons, generator);
        return this.composite;
    }

    private void createButtonsForButtonBar(Composite parent, ChoiceEnumeration buttonData, MnemonicGenerator generator) {
        ChoiceValue[] choices = buttonData.getChoices();
        this.buttons = new Button[choices.length];
        int i = 0;
        while (i < choices.length) {
            ChoiceValue next;
            Button button = this.createButton(parent, next, (next = choices[i]) == buttonData.getDefault(), generator);
            if (!this.vertical) {
                ++((GridLayout)parent.getLayout()).numColumns;
            }
            button.addSelectionListener((SelectionListener)this.selectionAdapter);
            Point buttonSize = Geometry.max((Point)button.computeSize(-1, -1, true), (Point)LayoutConstants.getMinButtonSize());
            GridDataFactory.fillDefaults().hint(buttonSize).applyTo((Control)button);
            button.setData(next.getValue());
            this.buttons[i] = button;
            ++i;
        }
    }

    protected Button createButton(Composite parent, ChoiceValue buttonData, boolean defaultButton, MnemonicGenerator generator) {
        Button button;
        if (this.toolkit == null) {
            button = new Button(parent, 8);
            button.setText(generator.generate(buttonData.getText()));
        } else {
            button = this.toolkit.createButton(parent, generator.generate(buttonData.getText()), 8);
        }
        button.setFont(JFaceResources.getDialogFont());
        return button;
    }

    public void setEnabled(boolean b) {
        int i = 0;
        while (i < this.buttons.length) {
            Button next = this.buttons[i];
            next.setEnabled(b);
            ++i;
        }
    }
}

