/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.IBatchAddRemoveListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSetWithListeners<E>
implements ISetWithListeners<E>,
Iterable<E> {
    private List<ISetListener<E>> setListeners = new ArrayList<ISetListener<E>>();
    private List<IStaleListener> staleListeners = new ArrayList<IStaleListener>();
    private boolean isStale = false;
    private boolean allocated = false;
    private Realm realm;

    public AbstractSetWithListeners() {
        this.realm = Realm.getDefault();
        this.checkThread();
    }

    public AbstractSetWithListeners(Realm targetRealm) {
        this.realm = targetRealm;
        Assert.isNotNull((Object)this.realm);
    }

    @Override
    public final Object[] toArray() {
        this.checkThread();
        return this.computeElements().toArray();
    }

    protected abstract Collection<E> computeElements();

    protected final void fireCollectionRemoved(Collection<E> removed) {
        HashSet<E> set = removed instanceof Set ? (HashSet<E>)removed : new HashSet<E>(removed);
        this.fireDiff(SetDiff.create(set, (Collection)Collections.emptySet()));
    }

    protected final void fireCollectionAdded(Collection<E> added) {
        HashSet<E> set = added instanceof Set ? (HashSet<E>)added : new HashSet<E>(added);
        this.fireDiff(SetDiff.create((Collection)Collections.emptySet(), set));
    }

    protected final void fireDiff(SetDiff<E> diff) {
        this.checkThread();
        if (!diff.isEmpty()) {
            for (ISetListener<E> next : this.setListeners) {
                next.changed(diff);
            }
        }
    }

    protected final void fireRemoved(E removed) {
        this.fireDiff(SetDiff.create((Collection)Collections.singleton(removed), (Collection)Collections.emptySet()));
    }

    protected final void fireAdded(E added) {
        this.fireDiff(SetDiff.create((Collection)Collections.emptySet(), (Collection)Collections.singleton(added)));
    }

    @Override
    public final void addListener(ISetListener<E> listener) {
        this.checkThread();
        this.setAllocated(true);
        this.setListeners.add(listener);
    }

    @Override
    public final void addListener(IBatchAddRemoveListener listener) {
        this.addListener(new BatchListenerToSetListener(listener));
    }

    @Override
    public void removeListener(ISetListener<E> listener) {
        this.checkThread();
        this.setListeners.remove(listener);
        this.setAllocated(!this.setListeners.isEmpty());
    }

    @Override
    public final void removeListener(IBatchAddRemoveListener listener) {
        this.removeListener(new BatchListenerToSetListener(listener));
    }

    @Override
    public final void addStaleListener(IStaleListener listener) {
        this.checkThread();
        this.staleListeners.add(listener);
    }

    protected final void checkThread() {
        if (!this.realm.isCurrent()) {
            throw new IllegalStateException("This method must be called in the correct realm");
        }
    }

    @Override
    public final void removeStaleListener(IStaleListener listener) {
        this.checkThread();
        this.staleListeners.remove(listener);
    }

    private void setAllocated(boolean b) {
        this.checkThread();
        if (this.allocated != b) {
            this.allocated = b;
            if (this.allocated) {
                this.allocate();
            } else {
                this.deallocate();
            }
        }
    }

    protected void deallocate() {
    }

    protected void allocate() {
    }

    protected final boolean isAllocated() {
        this.checkThread();
        return this.allocated;
    }

    protected final void setStale(boolean newStale) {
        this.checkThread();
        if (this.isStale != newStale) {
            this.isStale = newStale;
            ArrayList<IStaleListener> listCopy = new ArrayList<IStaleListener>();
            listCopy.addAll(this.staleListeners);
            for (IStaleListener staleListener : listCopy) {
                staleListener.setStale(this, this.isStale);
            }
        }
    }

    @Override
    public final boolean isStale() {
        this.checkThread();
        return this.isStale;
    }

    @Override
    public final Collection<E> toCollection() {
        this.checkThread();
        return this.computeElements();
    }

    @Override
    public Iterator<E> iterator() {
        this.checkThread();
        return this.computeElements().iterator();
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BatchListenerToSetListener<T>
    implements ISetListener<T> {
        private IBatchAddRemoveListener l;

        public BatchListenerToSetListener(IBatchAddRemoveListener l) {
            this.l = l;
        }

        @Override
        public void changed(SetDiff<T> diff) {
            this.l.added(diff.getAdditions().toArray());
            this.l.removed(diff.getRemovals().toArray());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.l == null ? 0 : this.l.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BatchListenerToSetListener other = (BatchListenerToSetListener)obj;
            return !(this.l == null ? other.l != null : !this.l.equals(other.l));
        }
    }
}

